/*
 * 쐬F 2005/02/19
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.source.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

import org.kikaineko.util.StringMgn;

/**
 * Javãg[NNXB
 * 
 * @author Masayuki Ioki
 *  
 */
public class JavaToken {
    private static String[] yoyakugoWithOutPremit = { "package", "import",
            "class", "extends", "public", "protected", "private", "void",
            "static", "true", "false", "null", "throw", "throws", "new",
            "return", "super", "for", "if", "while", "do" };

    private static String[] premit = { "int", "char", "byte", "double",
            "float", "long", "short", "String", "boolean" };

    private static Class[] premitClass = { int.class, char.class, byte.class,
            double.class, float.class, long.class, short.class, String.class,
            boolean.class };

    /**
     * Javãg[NɈv邩ǂ𔻒肷B
     * 
     * @param s
     * @return
     */
    public static boolean isYoyakugo(String s) {
        if (isPremit(s)) {
            return true;
        }

        for (int i = 0; i < yoyakugoWithOutPremit.length; i++) {
            if (yoyakugoWithOutPremit[i].equals(s))
                return true;
        }
        return false;
    }

    /**
     * 񂪃v~eBu^\𔻒肷B
     * 
     * @param s
     * @return
     */
    public static boolean isPremit(String s) {
        for (int i = 0; i < premit.length; i++) {
            if (premit[i].equals(s))
                return true;
        }
        return false;
    }

    /**
     * 񂪕\v~eBu^̃NXԂB
     * 
     * @param s
     * @return
     */
    public static Class getPremitClass(String s) {
        for (int i = 0; i < premit.length; i++) {
            if (premit[i].equals(s))
                return premitClass[i];
        }
        return null;
    }

    /**
     * 񂪕\z̒`ԂB 
     * Ⴆ΁A [I  int[] ԂB
     * 
     * @param ar
     * @return
     */
    public static String arrayType(String ar) {
        StringBuffer sb = new StringBuffer();
        int dim = StringMgn.count(ar, "[");

        ar = ar.substring(dim);
        if (ar.startsWith("I"))
            sb.append("int");
        else if (ar.startsWith("F"))
            sb.append("float");
        else if (ar.startsWith("J"))
            sb.append("long");
        else if (ar.startsWith("D"))
            sb.append("double");
        else if (ar.startsWith("C"))
            sb.append("char");
        else if (ar.startsWith("B"))
            sb.append("byte");
        else if (ar.startsWith("S"))
            sb.append("short");
        else if (ar.startsWith("Z"))
            sb.append("boolean");
        else if (ar.startsWith("L")) {
            ar = ar.substring(1, ar.length() - 1);
            sb.append(ar);
        }
        for (int i = 0; i < dim; i++) {
            sb.append("[]");
        }
        return sb.toString();
    }

    /**
     * žƂȂNXԂB 
     * int[] int[][] Ȃ΁Aint.class ԂB
     * 
     * @param class1
     * @return
     */
    public static Class unitTypeInArray(Class clazz) {
        String ar = clazz.getName();
        ar = ar.substring(ar.lastIndexOf("[") + 1);
        if (ar.startsWith("I"))
            return int.class;
        else if (ar.startsWith("F"))
            return float.class;
        else if (ar.startsWith("J"))
            return long.class;
        else if (ar.startsWith("D"))
            return double.class;
        else if (ar.startsWith("C"))
            return char.class;
        else if (ar.startsWith("B"))
            return byte.class;
        else if (ar.startsWith("S"))
            return short.class;
        else if (ar.startsWith("Z"))
            return boolean.class;
        else if (ar.startsWith("L")) {
            try {
                ar = ar.substring(1, ar.length() - 1);
                return Class.forName(ar);
            } catch (Exception e) {

            }
        }
        return null;
    }

    /**
     * @param class1
     * @return
     */
    public static Class underOneDimentionArray(Class clazz) {
        int dim = StringMgn.count(clazz.getName(), "[");
        Class uclazz=unitTypeInArray(clazz);
       
        for(int i=0;i<dim-1;i++){
            uclazz=Array.newInstance(uclazz,0).getClass();
        }
        
        return uclazz;
    }

    /**
     * @param class1
     * @return
     */
    public static boolean isConcrete(Class clazz) {
        if(clazz.isArray())
            clazz=unitTypeInArray(clazz);
        
        if(clazz.isPrimitive())
            return true;
        else if(clazz.isInterface())
            return false;
        else if(Modifier.isAbstract(clazz.getModifiers()))
            return false;
        return true;
    }

    /**
     * @param class1
     * @return
     */
    public static String getClassName(Class clazz) {
        if(clazz.isArray())
            return arrayType(clazz.getName());
        return clazz.getName();
    }

    /**
     * @param class1
     * @return
     */
    public static Method[] getAbstratcMethods(Class clazz) {
        Method[] ms=clazz.getDeclaredMethods();
        Vector v=new Vector();
        for(int i=0;i<ms.length;i++){
            if(Modifier.isAbstract(ms[i].getModifiers()))
                v.add(ms[i]);
        }
        
        Method[] res=new Method[v.size()];
        for(int i=0;i<res.length;i++){
            res[i]=(Method)v.get(i);
        }
        return res;
    }

}