/*
 * 쐬F 2005/03/27
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.source.util;

import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.List;

import junit.framework.TestCase;

/**
 * @author masayuki
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class JavaTokenTest extends TestCase {

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}
	
	public void testGetAbstractMethods(){
	    Method[] ms=JavaToken.getAbstratcMethods(String.class);
	    assertEquals(0,ms.length);
	    ms=JavaToken.getAbstratcMethods(AbstractList.class);
	    assertEquals(1,ms.length);
	    System.out.println(ms[0].getName());
	}
	
	public void testGetClassName(){
	    assertEquals("int",JavaToken.getClassName(int.class));
	    assertEquals("int[]",JavaToken.getClassName(int[].class));
	}
	
	public void testIsConcreteArray(){
	    assertEquals(true,JavaToken.isConcrete(int[].class));
	    assertEquals(true,JavaToken.isConcrete(StringBuffer[][].class));
	    assertEquals(false,JavaToken.isConcrete(List[].class));
	    
	}
	
	public void testIsConst(){
	    assertEquals(true,JavaToken.isConcrete(String.class));
	    assertEquals(true,JavaToken.isConcrete(int.class));
	    assertEquals(false,JavaToken.isConcrete(AbstractList.class));
	}
	
	public void testUnitInArray(){
		assertEquals(int.class,JavaToken.unitTypeInArray(int[].class));
		assertEquals(double.class,JavaToken.unitTypeInArray(double[].class));
		assertEquals(String.class,JavaToken.unitTypeInArray(String[].class));
		assertEquals(StringBuffer.class,JavaToken.unitTypeInArray(StringBuffer[].class));
		assertEquals(int.class,JavaToken.unitTypeInArray(int[][].class));
	}
	
	public void testUnderOneDimentionArray(){
	    assertNull(JavaToken.underOneDimentionArray(int.class));
	    assertEquals(int.class,JavaToken.underOneDimentionArray(int[].class));
	    assertEquals(int[].class,JavaToken.underOneDimentionArray(int[][].class));
	    assertEquals(int[][].class,JavaToken.underOneDimentionArray(int[][][].class));
	    assertEquals(StringBuffer[][].class,JavaToken.underOneDimentionArray(StringBuffer[][][].class));
	    assertEquals(String[].class,JavaToken.underOneDimentionArray(String[][].class));
		
	}
	
	public void testArrayType(){
		assertEquals("int[]",JavaToken.arrayType(int[].class.getName()));
		assertEquals("float[]",JavaToken.arrayType(float[].class.getName()));
		assertEquals("long[]",JavaToken.arrayType(long[].class.getName()));
		assertEquals("double[]",JavaToken.arrayType(double[].class.getName()));
		assertEquals("char[]",JavaToken.arrayType(char[].class.getName()));
		assertEquals("byte[]",JavaToken.arrayType(byte[].class.getName()));
		assertEquals("short[]",JavaToken.arrayType(short[].class.getName()));
		assertEquals("boolean[]",JavaToken.arrayType(boolean[].class.getName()));
		assertEquals("java.lang.String[]",JavaToken.arrayType(String[].class.getName()));
		assertEquals("java.util.List[]",JavaToken.arrayType(List[].class.getName()));
		
		assertEquals("int[]",JavaToken.arrayType("[I"));
		assertEquals("float[]",JavaToken.arrayType("[F"));
		assertEquals("long[]",JavaToken.arrayType("[J"));
		assertEquals("double[]",JavaToken.arrayType("[D"));
		assertEquals("char[]",JavaToken.arrayType("[C"));
		assertEquals("byte[]",JavaToken.arrayType("[B"));
		assertEquals("short[]",JavaToken.arrayType("[S"));
		assertEquals("boolean[]",JavaToken.arrayType("[Z"));
		assertEquals("java.lang.String[]",JavaToken.arrayType("[Ljava.lang.String;"));
	}
	
	public void testTAJUUArray(){
		assertEquals("int[][][]",JavaToken.arrayType("[[[I"));
	}

}
