/*
 * Created on 2005/02/18
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.kikaineko.source.util;

/**
 * g[N̔z\B
 * g[N̔z_Ɉ߂̃\bh񋟂B
 * @author Masayuki Ioki
 */
public class TokenArray {
	private Token[] tokens;

	private int addLength = 50;//50

	private int length;

	/**
	 * @param tokens@g[N̔z
	 */
	public TokenArray(Token[] ts) {
		this.tokens = new Token[ts.length];
		length = ts.length;
		System.arraycopy(ts, 0, tokens, 0, tokens.length);
	}

	public TokenArray() {
		tokens = new Token[addLength];
		length = 0;
	}

	/**
	 * @return
	 */
	public int length() {
		return length;
	}

	/**
	 * ŏkindindexԂB
	 * @param word
	 * @return
	 */
	public int indexOfKind(int kind) {
		return indexOfKind(kind, 0);
	}

	/**
	 * fromIndexȍ~̍ŏkindindexԂB
	 * @param number
	 * @param i
	 * @return
	 */
	public int indexOfKind(int kind, int fromIndex) {
		for (int i = fromIndex; i < length(); i++) {
			if (tokens[i].getKind() == kind && !tokens[i].isLiteral)
				return i;
		}
		return -1;
	}

	/**
	 * ŏvalindexԂB
	 * @param string
	 * @return
	 */
	public int indexOfVal(String string) {
		return indexOfVal(string, 0);
	}
	/**
	 * fromIndexȍ~̍ŏvalindexԂB
	 * @param string
	 * @param fromIndex
	 * @return
	 */
	public int indexOfVal(String string, int fromIndex) {
		for (int i = fromIndex; i < length(); i++) {
			if (tokens[i].getVal().equals(string) && !tokens[i].isLiteral)
				return i;
		}
		return -1;
	}

	/**
	 * iԖڂTokenԂB
	 * @param i
	 * @return
	 */
	public Token get(int i) {
		return tokens[i];
	}

	/**
	 * iԖڂToken̒lԂB
	 * @param i
	 * @return
	 */
	public String getVal(int i) {
		return get(i).getVal();
	}
	/**
	 * iԖڂToken̎ނԂB
	 * @param i
	 * @return
	 */
	public int getKind(int i) {
		return get(i).getKind();
	}

	/**
	 * fromend ܂ł̕zԂB
	 * Ԃz񒷂end-fromƂȂB
	 * @param i
	 * @param j
	 * @return
	 */
	public TokenArray subArray(int from, int end) {
		Token[] tt = new Token[end - from];
		System.arraycopy(tokens, from, tt, 0, tt.length);
		return new TokenArray(tt);
	}

	/**
	 * from̕zԂB
	 * @param i
	 * @return
	 */
	public TokenArray subArray(int from) {
		return subArray(from, length());
	}

	/**
	 * @param ts
	 * @param word
	 * @return
	 */
	public static int indexOfKind(Token[] ts, int kind) {
		return indexOfKind(ts, kind, 0);
	}

	public static int indexOfKind(Token[] ts, int kind, int from) {
		for (int i = from; i < ts.length; i++) {
			if (ts[i].getKind() == kind && !ts[i].isLiteral)
				return i;
		}
		return -1;
	}

	public static int indexOfVal(Token[] ts, String val) {
		return indexOfVal(ts, val, 0);
	}

	public static int indexOfVal(Token[] ts, String val, int from) {
		for (int i = from; i < ts.length; i++) {
			if (ts[i].getVal().equals(val) && !ts[i].isLiteral)
				return i;
		}
		return -1;
	}

	public static Token[] subArray(Token[] ts, int from, int end) {
		Token[] tt = new Token[end - from];
		System.arraycopy(ts, from, tt, 0, tt.length);
		return tt;
	}

	public static Token[] subArray(Token[] ts, int from) {
		return subArray(ts, from, ts.length);
	}

	/**
	 * g[N̔zfromto܂ł폜B
	 * @param ts
	 * @param i
	 * @param j
	 * @return
	 */
	public static Token[] removeArray(Token[] ts, int from, int end) {
		Token[] tt = new Token[ts.length - end + from];
		System.arraycopy(ts, 0, tt, 0, from);
		System.arraycopy(ts, end, tt, from, tt.length - from);
		return tt;
	}

	/**
	 * @param ts
	 * @param i
	 * @return
	 */
	public static Token[] removeArray(Token[] ts, int from) {
		Token[] tt = new Token[from];
		System.arraycopy(ts, 0, tt, 0, from);
		return tt;
	}

	/**
	 * ̃g[N̔zɐVɃg[N̔zǉB
	 * @param tokens2
	 */
	public void addArray(Token[] ts) {

		if (ts.length == 0)
			return;

		if (tokens.length > ts.length + length()) {
			System.arraycopy(ts, 0, tokens, length(), ts.length);
			length += ts.length;
		} else {
			Token[] ts2 = new Token[tokens.length];
			System.arraycopy(tokens, 0, ts2, 0, tokens.length);
			tokens = new Token[ts2.length + addLength];
			System.arraycopy(ts2, 0, tokens, 0, ts2.length);
			addArray(ts);
		}
	}

	/**
	 * @param i
	 * @return
	 */
	public boolean isLiteral(int i) {
		return get(i).isLiteral;
	}

	/**
	 * w肵kindz񒆂ɂ邩ԂB
	 * @param ts
	 * @param word
	 * @return
	 */
	public static int howManyOfKind(Token[] ts, int kind) {
		int index = -1;
		int num = -1;
		do {
			num++;
			index = indexOfKind(ts, kind, index + 1);
		} while (index != -1);
		return num;
	}

	/**
	 * @param string
	 * @param string2
	 * @return
	 */
	public int indexOfVal(String string, String string2) {
		return indexOfVal(string,string2,0);
	}
	
	public int indexOfVal(String string, String string2,int ind) {
		int index = ind-1;
		do {
			index = indexOfVal(string,index+1);
			if(index==-1 || index==length()-1)
				return -1;
		} while (!getVal(index + 1).equals(string2));

		return index;
	}
	/**
	 * @param string
	 * @param string2
	 * @param string3
	 * @return
	 */
	public int indexOfVal(String string, String string2, String string3) {
		int index = -1;
		do {
			index = indexOfVal(string,string2,index+1);
			if(index==-1 || index>=length()-2)
				return -1;
		} while (!getVal(index + 1).equals(string2));

		return index;
	}

	/**
	 * fromto܂ł̕zԂƋɁA̕폜B
	 * @param i
	 * @param j
	 * @return
	 */
	public TokenArray takeSubArray(int from, int to) {
		TokenArray ta=subArray(from,to);
		length=length()+from-to;
		tokens=removeArray(tokens,from,to);
		return ta;
	}
	/**
	 * @param i
	 * @param j
	 * @return
	 */
	public TokenArray takeSubArray(int from) {
		return takeSubArray(from,length());
	}
	
	public String toString(){
		StringBuffer sb=new StringBuffer();
		for(int i=0;i<length();i++){
			sb.append(tokens[i].getVal());
			sb.append(" ");
		}
		return sb.toString();
	}

	/**
	 * z񒆂ɂ̕g[N邩ԂB
	 * @param string
	 * @return
	 */
	public int howManyOfVal(String val) {
		int index = -1;
		int num = -1;
		do {
			num++;
			index = indexOfVal(val,index+1);
		} while (index != -1);
		return num;
	}
	
	public Token getToken(int i){
		return tokens[i];
	}

}