/*
 * Created on 2005/02/19
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.kikaineko.mock.analysis;

import org.kikaineko.mock.analysis.exception.CannotAnalyzeSyntaxForKikainekoMockerException;
import org.kikaineko.mock.framework.Import;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.TestClass;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

/**
 * TestCasẽg[N󂯎ATestClassTarget𐶐
 * 
 * @author masayuki
 * 
 */
public class TestAnalyst implements Analyst {
	protected TokenArray ta;

	protected TestClass tc;

	protected TargetClass target;

	/**
	 * @param tokeArrayWithoutComment
	 */
	public TestAnalyst(TokenArray inTa) {
		this.ta = inTa;
	}

	public void analyze() throws Exception {
		setTestClass();
		setTargetClass();
		setSetUp();
		setTestMethod();
		setTearDown();
		setFields();
		
		tearDownForAnalyze();
	}
	
	protected void tearDownForAnalyze() throws Exception {
		checkbJ[@();
	}

	private void setFields() {
		String s = "";

		if (ta.length() == 0) {
			return;
		}
		ta.deleteThisVal("private");
		ta.deleteThisVal("public");
		ta.deleteThisVal("protected");
		ta.deleteThisVal("static");
		ta.deleteThisVal("transient");
		ta.deleteThisVal("final");
		s = ta.toString() + " }";
		if (s.startsWith("=")) {
			s = target.getInstanceName() + s;
		}
		tc.setFieldsPart(new TokenArray(s));
	}

	protected void checkbJ[@() throws Exception {
		if (ta.indexOfVal("{")!=-1) {
			throw new CannotAnalyzeSyntaxForKikainekoMockerException(ta
					.getToken(0).getLineNo(), ta.getVal(0));
		}
	}
	
	/**
	 * 
	 */
	private void setSetUp() {
		int start = getIndexOfSetUp();
		if (start != -1) {
			int end = getIndexOfClosed(ta, start, "{", "}");
			tc.setSetUp(ta.takeSubArray(start, end + 1));
		} else {
			// setUpI[o[ChȂꍇ
			// ftHg̉ȂeXgP[XĂ
			tc.setSetUp(new TokenArray("{}"));
		}
	}
	protected int getIndexOfSetUp() {
		int i= ta.indexOfVal("protected", "void", "setUp");
		if(i>=0){
			return i;
		}
		
		return ta.indexOfVal("public", "void", "setUp");
	}

	/**
	 * 
	 */
	private void setTearDown() {
		int start = getIndexOfTearDown();
		if (start != -1) {
			int end = getIndexOfClosed(ta, start, "{", "}");
			tc.setTearDown(ta.takeSubArray(start, end + 1));
		} else {
			// tearDownI[o[ChȂꍇ
			// ftHg̉ȂeXgP[XĂ
			tc.setTearDown(new TokenArray("{}"));
		}
	}
	protected int getIndexOfTearDown() {
		int i= ta.indexOfVal("protected", "void", "tearDown");
		if(i>=0){
			return i;
		}
		
		return ta.indexOfVal("public", "void", "tearDown");
	}

	private void setTestMethod() {
		int start = getIndexOfTestMethod();
		while (start != -1) {
			int end = getIndexOfClosed(ta, start, "{", "}");
			tc.addTestMethod(ta.takeSubArray(start, end + 1));
			start = getIndexOfTestMethod();
		}
	}

	protected int getIndexOfTestMethod() {
		int start = -1;
		do {
			start = ta.indexOfVal("public", "void", start + 1);
			if (start != -1 && ta.getVal(start + 2).startsWith("test"))
				return start;
		} while (start != -1);
		return -1;
	}

	protected int getIndexOfClosed(TokenArray arr, int start, String op, String cl) {
		int count = 0;
		for (int i = start; i < arr.length(); i++) {
			if (arr.getVal(i).equals(op))
				count++;
			else if (arr.getVal(i).equals(cl)) {
				count--;
				if (count == 0)
					return i;
			}
		}
		return -1;
	}

	/**
	 * @return
	 */
	protected void setTestClass() throws Exception {

		String pack = getPackage();

		Import[] im = getImports();

		int index = ta.indexOfVal("class");
		String name = ta.getVal(index + 1);

		index = ta.indexOfVal("extends");
		if (ta.getVal(index + 1).indexOf("TestCase") == -1) {
			throw new NotTestCaseException("This class is not TestCase : "
					+ name);
		}
		tc = new TestClass(pack, name);
		tc.setImports(im);

		ta = ta.takeSubArray(ta.indexOfVal("{", index) + 1, getIndexOfClosed(
				ta, index, "{", "}"));
	}

	private String getPackage() {
		int index = ta.indexOfVal("package");
		if (index == -1) {
			// ftHgpbP[W
			return "";
		}
		int endindex = ta.indexOfVal(";", index);
		StringBuffer sb = new StringBuffer();
		for (int i = index + 1; i < endindex; i++) {
			sb.append(ta.getVal(i));
		}
		return sb.toString();
	}

	protected Import[] getImports() {
		int num = ta.howManyOfVal("import");
		Import[] im = new Import[num];
		for (int i = 0; i < im.length; i++) {
			int from = ta.indexOfVal("import");
			int end = ta.indexOfVal(";", from);
			im[i] = new Import(ta.takeSubArray(from, end + 1));
		}
		return im;

	}

	/**
	 * @return
	 */
	protected void setTargetClass() throws Exception {
		int index = ta.indexOfKind(TokenKind.Word);
		while (LangMgn.isReserved(ta.getVal(index))) {
			index++;
		}
		target = new TargetClass(ta.getVal(index), ta.getVal(index + 1));

		target.setPack(tc.packageName());
		if (ta.getVal(index + 2).equals(";")) {
			ta = ta.takeSubArray(index + 3);
		}else if(ta.getVal(index + 2).equals("=") && ta.getVal(index + 3).equals("null")&& ta.getVal(index + 4).equals(";")){
			ta = ta.takeSubArray(index + 5);
		} else {
			ta = ta.takeSubArray(index + 2);
		}
	}

	public TargetClass getTargetClass() {
		return target;
	}

	/**
	 * @return
	 */
	public TestClass getTestClass() {
		return tc;
	}

}