package org.kikaineko.mock.analysis.innersi;

import java.lang.reflect.Array;
import java.util.Vector;

import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.source.util.TokenKind;

public class ArrayGenerate {

	public static void run(SharedFields sf) throws Exception {
		String type = sf.tokenArray.getVal(sf.index++);
		sf.index++;
		Expression.run(sf);
		Object o = sf.valueStack.pop();
		sf.typeStack.pop();
		int length = ((Number) o).intValue();

		if (!sf.tokenArray.getVal(sf.index + 1).equals("[")) {
			Object os = Array.newInstance(sf.classNameResolver.getClazz(type),
					length);
			sf.valueStack.push(os);
			sf.typeStack.push(os.getClass());
		} else {
			multiArray(sf, sf.classNameResolver.getClazz(type), length);
		}
	}

	private static void multiArray(SharedFields sf, Class unitType, int length)
			throws Exception {
		Class type = ClassNameResolver.getArrayClass(unitType);
		Object o = null;
		Vector lengthsVec = new Vector();
		lengthsVec.add(new Integer(length));
		boolean lastUndefine = false;
		while (sf.tokenArray.getVal(sf.index + 1).equals("[")) {
			sf.index++;// ]
			sf.index++;// [
			if (sf.tokenArray.getKind(sf.index) != TokenKind.ArrayClose) {
				Expression.run(sf);
				o = sf.valueStack.pop();
				sf.typeStack.pop();
				lengthsVec.add((Integer) o);
			} else {
				lastUndefine = true;
				lengthsVec.add(new Integer(0));
			}
			type = ClassNameResolver.getArrayClass(type);
		}
		int[] lengths = new int[lengthsVec.size()];
		for (int i = 0; i < lengths.length; i++) {
			lengths[i] = ((Number) lengthsVec.get(i)).intValue();
		}
		o = Array.newInstance(unitType, lengths);
		if (lastUndefine) {
			o = setLastNull(o, lengths);
		}
		sf.valueStack.push(o);
		sf.typeStack.push(type);
	}
	
	/**
	 * bJ[ł́AŌ̔z񒷂ȂƂ̑ΉfɂłȂB
	 * ܂
	 * int[][] temp=new int[2][];
	 * ̏ꍇAtemp[0]nullɂȂKv邪AnullɂłȂ
	 * iNULLŐ郊tNVȂ߁j
	 * ̃\bhɂNULLɂ낦
	 * @param source
	 * @param lengths
	 * @return
	 */
	protected static Object setLastNull(Object source, int[] lengths) {
		Object temp = source;
		Vector vec = new Vector();
		vec.add(temp);
		Vector tempVec = new Vector();
		for (int level = 0; level < lengths.length - 2; level++) {
			for (int i = 0; i < vec.size(); i++) {
				temp = vec.get(i);
				for (int index = 0; index < lengths[level]; index++) {
					tempVec.add(Array.get(temp, index));
				}
			}
			vec=tempVec;
			tempVec=new Vector();
		}
		for(int i=0;i<vec.size();i++){
			for(int index=0;index<lengths[lengths.length -2];index++){
				Array.set(vec.get(i), index, null);
			}
		}
		return source;
	}
}
