package org.kikaineko.mock.analysis.innersi;

import java.util.Enumeration;
import java.util.Hashtable;

import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.analysis.exception.TargetCannotBeUsedAtHereException;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;

public class AssertEquals {
	/**
	 * asserEqualsȊOassertFalse,assertTrue,assertNullɎgp
	 * 
	 * @param sf
	 * @throws Exception
	 */
	public static void runActual(SharedFields sf) throws Exception {
		TargetClass tempTarget = null;
		String methodName = null;
		Object[] firstVars = expressionOrTargetInvoke(sf, methodName);
		methodName = (String) firstVars[1];
		tempTarget = (TargetClass) firstVars[2];
		sf.index++;
		String firstVar = (String) firstVars[0];

		if (sf.tokenArray.getVal(sf.index).equals(";")) {
			doAssert(sf, methodName, firstVar, "", tempTarget);
		} else {
			// ɃRgĂP[X
			// ŏɃRgʂ
			sf.valueStack.pop();// Rg
			sf.typeStack.pop();

			firstVars = expressionOrTargetInvoke(sf, methodName);
			sf.index++;
			if (firstVars[1] != null) {
				methodName = (String) firstVars[1];
			}
			if (firstVars[2] != null) {
				tempTarget = (TargetClass) firstVars[2];
			}
			firstVar = (String) firstVars[0];
			doAssert(sf, methodName, firstVar, "", tempTarget);
		}

	}

	/**
	 * assertEqualŝƂɂ΂
	 * 
	 * @param sf
	 * @throws Exception
	 */
	public static void run(SharedFields sf) throws Exception {
		TargetClass tempTarget = null;
		String methodName = null;
		sf.index++;// (i߂
		Object[] firstVars = expressionOrTargetInvoke(sf, methodName);
		methodName = (String) firstVars[1];
		tempTarget = (TargetClass) firstVars[2];
		sf.index++;
		Object[] secondVars = expressionOrTargetInvoke(sf, methodName);
		if (secondVars[1] != null) {
			methodName = (String) secondVars[1];
		}
		if (secondVars[2] != null) {
			tempTarget = (TargetClass) secondVars[2];
		}
		sf.index++;

		String firstVar = (String) firstVars[0];
		String secondVar = (String) secondVars[0];

		if (sf.tokenArray.getVal(sf.index).equals(";")) {
			doAssert(sf, methodName, firstVar, secondVar, tempTarget);
		} else {
			// RgĂP[X
			Object[] thirdVars = expressionOrTargetInvoke(sf, methodName);
			sf.index++;
			if (thirdVars[1] != null) {
				methodName = (String) thirdVars[1];
			}
			if (thirdVars[2] != null) {
				tempTarget = (TargetClass) thirdVars[2];
			}
			String thirdVar = (String) thirdVars[0];

			doAssert(sf, methodName, secondVar, thirdVar, tempTarget);
			sf.valueStack.pop();// Rg
			sf.typeStack.pop();
		}

	}

	private static void doAssert(SharedFields sf, String methodName,
			String firstVar, String secondVar, TargetClass tempTarget) {
		if (methodName != null) {
			targetCalling(sf, methodName, tempTarget);
		} else if (isUndef(sf, firstVar)) {
			setUndefValue(sf, firstVar, true);
		} else if (isUndef(sf, secondVar)) {
			setUndefValue(sf, secondVar, false);
		} else {
			// undeftarget̂ŃX[
			sf.valueStack.pop();
			sf.valueStack.pop();
			sf.typeStack.pop();
			sf.typeStack.pop();
		}
	}

	private static void setUndefValue(SharedFields sf, String undefVarName,
			boolean firstFlag) {
		Object secondValue = sf.valueStack.pop();
		Class secondClass = (Class) sf.typeStack.pop();
		Object firstValue = sf.valueStack.pop();
		Class firstClass = (Class) sf.typeStack.pop();

		if (firstFlag) {
			defineValue(sf, undefVarName, secondValue, secondClass,
					(UndefinedValue) firstValue);
		} else {
			defineValue(sf, undefVarName, firstValue, firstClass,
					(UndefinedValue) secondValue);
		}
	}

	private static void defineValue(SharedFields sf, String varName,
			Object defValue, Class defClass, UndefinedValue uv) {
		VariableTable vt = sf.vt;
		vt.setVal(varName, defValue);
		vt.setType(varName, defClass);
		TargetClass definedTarget = findDefinedTarget(sf, uv);
		// ۂɕԂl̏C
		int undefinedHistorySymbol = uv
				.getTargetClassHistorySymbolGeneratingThisUndefValue();
		String definedValue = ToStringer.getStrick(defValue, defClass);
		definedTarget.overWriteHistory(undefinedHistorySymbol, definedValue);

		// \bh̕ԂlC
		String methodName = uv.getMethodNameGeneratingThisUndefValue();
		definedTarget.overWriteMethodReType(methodName, LangMgn
				.getClassName(defClass));

		// 폜
		definedTarget.getRawUndefinedValues().remove(varName);
	}

	private static TargetClass findDefinedTarget(SharedFields sf,
			UndefinedValue uv) {
		return findDefinedTargetInThisTarget(sf.target, uv);
	}

	private static TargetClass findDefinedTargetInThisTarget(
			TargetClass target, UndefinedValue uv) {
		Hashtable uvs = target.getRawUndefinedValues();
		for (Enumeration e = uvs.elements(); e.hasMoreElements();) {
			UndefinedValue u = (UndefinedValue) e.nextElement();
			if (u.equals(uv)) {
				return target;
			} else{
				TargetClass t = findDefinedTargetInThisTarget(u, uv);
				if (t != null)
					return t;
			}
		}

		return target;
	}

	private static void targetCalling(SharedFields sf, String methodName,
			TargetClass tempTarget) {
		Object expectedValue = sf.valueStack.pop();
		Class expectedClass = (Class) sf.typeStack.pop();
		tempTarget.expectValueAtCurrentHistory(ToStringer.getStrick(
				expectedValue, expectedClass));
		tempTarget.overWriteMethodReType(methodName, LangMgn
				.getClassName(expectedClass));
	}

	private static Object[] expressionOrTargetInvoke(SharedFields sf,
			String methodName) throws Exception {
		Object[] temp = new Object[3];
		temp[0] = sf.tokenArray.getVal(sf.index);
		String s = sf.tokenArray.getVal(sf.index);
		if (s.equals(sf.targetName)) {
			Token t = sf.tokenArray.get(sf.index);
			if (methodName != null) {
				// targetĂ΂ꂽƂƂŁAassertarget2Ă΂ꂽƂɂȂ
				throw new TargetCannotBeUsedAtHereException(t.getLineNo(), t
						.getVal());
			}

			sf.index++;// targeti߂
			temp[1] = TargetInvoke.run(sf, sf.target);
			sf.index++; // )i߂
			temp[2] = sf.target;
		} else {
			if (isUndef(sf, s)
					&& sf.tokenArray.getVal(sf.index + 1).equals(".")) {
				TargetClass tempTarget = (TargetClass) sf.vt.getVal(s);
				sf.index++;// targeti߂
				temp[1] = TargetInvoke.run(sf, tempTarget);
				sf.index++;// targeti߂
				temp[2] = tempTarget;
			} else {
				Expression.run(sf);
			}
		}
		return temp;
	}

	private static boolean isUndef(SharedFields sf, String name) {
		if (sf.vt.include(name)) {
			return sf.vt.getVal(name).getClass() == UndefinedValue.class;
		}
		return false;
		// return sf.target.getRawUndefinedValues().containsKey(name);
	}

}
