package org.kikaineko.mock.analysis.innersi;

import java.lang.reflect.Array;
import java.util.Stack;

import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.analysis.TypeOwner;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.util.Operator;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class CallingVariable {
	public static void run(SharedFields sf, String s) throws Exception {
		TokenArray tokenArray = sf.tokenArray;
		Stack valueStack = sf.valueStack;
		TypeOwner typeStack = sf.typeStack;
		VariableTable vt = sf.vt;

		Token t = tokenArray.getToken(sf.index++);
		if (t.getKind() == TokenKind.Eq) {
			Expression.run(sf);
			Object o = valueStack.pop();
			typeStack.pop();
			//if (o instanceof UndefinedValue) {
			if (o instanceof TargetClass) {
				TargetClass tempTarget=(TargetClass)o;
				UndefinedValue undefV = (UndefinedValue)sf.valueStack.pop();
				sf.typeStack.pop();
				
				undefV.setInstanceName(s);
				undefV.setClass(vt.getType(s));
				
				tempTarget.getRawUndefinedValues().put(s, undefV);
				sf.vt.setValAndLevel(s, undefV, sf.currentLevel);
				
				String typeName=LangMgn.getClassName(vt.getType(s));
				tempTarget.overWriteMethodReType(sf.lastCallintTargetMethodName,typeName);
				
				/*
				UndefinedValue undefV=(UndefinedValue)o;
				undefV.setInstanceName(s);
				undefV.setClass(vt.getType(s));
				
				sf.target.getRawUndefinedValues().put(s, undefV);
				sf.vt.setValAndLevel(s, o, sf.currentLevel);
				*/
				/*
				 TargetClass tempTarget=(TargetClass)o;
				UndefinedValue undefV = (UndefinedValue)sf.valueStack.pop();
				sf.typeStack.pop();
				tempTarget.getRawUndefinedValues().put(name, undefV);
				sf.vt.setValAndLevel(name, undefV, sf.currentLevel);

				tempTarget.overWriteMethodReType(sf.lastCallintTargetMethodName, LangMgn.getClassName(type));
				
				 */
			} else {
				vt.setVal(s, o);
			}
		} else if (t.getKind() == TokenKind.SaikiWa) {
			Expression.run(sf);
			Object o = valueStack.pop();
			vt.setVal(s, Operator.operate(vt.getVal(s), o, "+"));
		} else if (t.getKind() == TokenKind.SaikiSeki) {
			Expression.run(sf);
			Object o = valueStack.pop();
			vt.setVal(s, Operator.operate(vt.getVal(s), o, "*"));
		} else if (t.getKind() == TokenKind.SaikiSa) {
			Expression.run(sf);
			Object o = valueStack.pop();
			vt.setVal(s, Operator.operate(o, vt.getVal(s), "-"));
		} else if (t.getKind() == TokenKind.SaikiShou) {
			Expression.run(sf);
			Object o = valueStack.pop();
			vt.setVal(s, Operator.operate(o, vt.getVal(s), "/"));

		} else if (t.getKind() == TokenKind.Piriod) {
			VariableOrClassPush.run(sf, s);
			// TODO
			// valueStack.push(vt.getVal(s));
			// typeStack.push(vt.getType(s));
			MethodCalling.run(sf, "method");
		} else if (t.getKind() == TokenKind.ArrayOpen) {
			Expression.run(sf);
			int index = ((Number) valueStack.pop()).intValue();
			typeStack.pop();
			sf.index++;// ]
			Object contents = vt.getVal(s);
			while (tokenArray.getKind(sf.index) == TokenKind.ArrayOpen) {
				sf.index++; // [
				contents = Array.get(contents, index);
				Expression.run(sf);
				index = ((Number) valueStack.pop()).intValue();
				typeStack.pop();
				sf.index++;// ]
			}
			sf.index++;// =
			Expression.run(sf);
			Object o = valueStack.pop();
			typeStack.pop();
			Array.set(contents, index, o);
		} else if (t.getKind() == TokenKind.PP) {
			// u++
			Object o = vt.getVal(s);
			valueStack.push(o);
			typeStack.push(vt.getType(s));
			Object ro = SmallInterpreterSupportor.getIncOrDec(o, "+");
			// type is not changed
			vt.setVal(s, ro);
		} else if (t.getKind() == TokenKind.MM) {
			// u--
			Object o = vt.getVal(s);
			valueStack.push(o);
			typeStack.push(vt.getType(s));
			Object ro = SmallInterpreterSupportor.getIncOrDec(o, "-");

			// type is not changed
			vt.setVal(s, ro);
		}
	}

}
