package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenKind;

public class Expression {
	public static void run(SharedFields sf) throws Exception {
		/*
		try{
			doRun(sf);
		}catch (CannotUseUndefValueException cuuv) {
			//̒̂ǂŕsl̎gp֎~Ɉ
			throw new CannotUseUndefValueException(sf.tokenArray.getToken(sf.index).getLineNo());
		}*/
		doRun(sf);
	}
	public static void doRun(SharedFields sf) throws Exception {
		Term.run(sf);
		while (true) {
			Token t = sf.tokenArray.getToken(sf.index);
			
			if (t.getKind() == TokenKind.Plus) {
				sf.index++;
				Term.run(sf);
				SmallInterpreterSupportor.operation(sf.valueStack,
						sf.typeStack, "+");
			} else if (t.getKind() == TokenKind.Minus) {
				sf.index++;
				Term.run(sf);
				SmallInterpreterSupportor.operation(sf.valueStack,
						sf.typeStack, "-");
			} else if (t.getKind() == TokenKind.CondEq) {
				sf.index++;
				Term.run(sf);
				conditionPush(sf, "==");
			} else if (t.getKind() == TokenKind.CondNotEq) {
				sf.index++;
				Term.run(sf);
				conditionPush(sf, "!=");
			} else if (t.getKind() == TokenKind.CondGT) {
				sf.index++;
				Term.run(sf);
				conditionPush(sf, ">");
			} else if (t.getKind() == TokenKind.CondLT) {
				sf.index++;
				Term.run(sf);
				conditionPush(sf, "<");
			} else if (t.getKind() == TokenKind.CondGE) {
				sf.index++;
				Term.run(sf);
				conditionPush(sf, ">=");
			} else if (t.getKind() == TokenKind.CondLE) {
				sf.index++;
				Term.run(sf);
				conditionPush(sf, "<=");
			} else if (t.getKind() == TokenKind.DoubleAnpa) {
				// &&
				if (toBoolean(sf)) {
					sf.index++;
					Expression.run(sf);
				} else {
					sf.valueStack.push(new Boolean(false));
					sf.typeStack.push(boolean.class);
					IgnoreOpenedKakko.run(sf);
				}
			} else if (t.getKind() == TokenKind.DoubleBar) {
				// ||
				if (toBoolean(sf)) {
					sf.valueStack.push(new Boolean(true));
					sf.typeStack.push(boolean.class);
					IgnoreOpenedKakko.run(sf);
				} else {
					sf.index++;
					Expression.run(sf);
				}
			} else {
				break;
			}
		}
	}
	static boolean toBoolean(SharedFields sf) {
		Object o1 = sf.valueStack.pop();
		Class o1Clazz = (Class) sf.typeStack.pop();
		if (o1Clazz.equals(boolean.class)) {
			Boolean b = (Boolean) o1;
			return b.booleanValue();
		}
		return false;
	}

	private static void conditionPush(SharedFields sf, String conditionOperate) {
		Object o1 = sf.valueStack.pop();
		sf.typeStack.pop();
		Object o2 = sf.valueStack.pop();
		sf.typeStack.pop();
		if (conditionOperate.equals("==")) {
			sf.valueStack.push(Boolean.valueOf(specialEquals(o1, o2)));
			sf.typeStack.push(boolean.class);
		} else if (conditionOperate.equals("!=")) {
			sf.valueStack.push(Boolean.valueOf(!specialEquals(o1, o2)));
			sf.typeStack.push(boolean.class);
		} else if (conditionOperate.equals(">")) {
			sf.valueStack.push(Boolean.valueOf(specialGreater(o1, o2)));
			sf.typeStack.push(boolean.class);
		} else if (conditionOperate.equals("<")) {
			sf.valueStack.push(Boolean.valueOf(specialLess(o1, o2)));
			sf.typeStack.push(boolean.class);
		} else if (conditionOperate.equals(">=")) {
			sf.valueStack.push(Boolean.valueOf(specialGreaterEqual(o1, o2)));
			sf.typeStack.push(boolean.class);
		} else if (conditionOperate.equals("<=")) {
			sf.valueStack.push(Boolean.valueOf(specialLesserEqual(o1, o2)));
			sf.typeStack.push(boolean.class);
		}
	}

	private static boolean specialEquals(Object o1, Object o2) {
		if (o1 != null) {
			return o1.equals(o2);
		}
		return o1 == o2;
	}

	private static boolean specialGreater(Object o1, Object o2) {
		double d1 = ((Number) o1).doubleValue();
		double d2 = ((Number) o2).doubleValue();
		return d1 < d2;
	}

	private static boolean specialLess(Object o1, Object o2) {
		double d1 = ((Number) o1).doubleValue();
		double d2 = ((Number) o2).doubleValue();
		return d1 > d2;
	}

	private static boolean specialGreaterEqual(Object o1, Object o2) {
		boolean b = specialEquals(o1, o2);
		if (b) {
			return b;
		}
		return specialGreater(o1, o2);
	}

	private static boolean specialLesserEqual(Object o1, Object o2) {
		boolean b = specialEquals(o1, o2);
		if (b) {
			return b;
		}
		return specialLess(o1, o2);
	}

}
