package org.kikaineko.mock.analysis.innersi;

import java.util.Stack;

import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.analysis.TypeOwner;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class TargetInvoke {
	public static String run(SharedFields sf,TargetClass tempTarget) throws Exception {
		TokenArray tokenArray = sf.tokenArray;

		Token t = tokenArray.getToken(sf.index++);
		String name = null;
		if (t.getKind() == TokenKind.Piriod) {
			Object[] rs=invokeMethod(sf);
			name =(String)rs[0];
			Class[] argsClasses=(Class[])rs[1];
			Object[] args=(Object[])rs[2];
			tempTarget.invokingMethod("void", name,argsClasses, args);
		} else if (t.getKind() == TokenKind.Eq) {
			Object[] rs = doNew(sf);
			name =(String)rs[0];
			Class[] argsClasses=(Class[])rs[1];
			Object[] args=(Object[])rs[2];
			tempTarget.invokingMethod("", name, argsClasses,args);
		}
		return name;
	}

	private static Object[] doNew(SharedFields sf) throws Exception {
		String name = "";
		Object[] args=null;
		Class[] argClazzes=null;
		TokenArray tokenArray = sf.tokenArray;
		Stack valueStack = sf.valueStack;
		TypeOwner typeStack = sf.typeStack;
		ClassNameResolver classNameResolver = sf.classNameResolver;
		TargetClass target = sf.target;

		if (tokenArray.getVal(sf.index).equals("new")) {
			sf.index++;
			
			Object[] os=invokeMethod(sf);
			name =(String)os[0];
			argClazzes=(Class[])os[1];
			args=(Object[])os[2];
			String className = name.substring(0, name.indexOf('('));
			if (!target.getClassName().equals(className)) {
				// eNX݂ꍇ
				// RXgN^̖ONXɃZbgB
				target.setClassName(className);

				// eNX擾A^[QbgɃZbgB
				Class c = classNameResolver.getClazz(target.getSuperName());
				target.setSuperClass(c);
			}
		} else {
			// falseɂȂꍇǉ(2006.09.04)
			// ܂At@Ng[\bhDIƂꍇɑΉ
			// newȂ߁AAȃNXsƂȂB
			// ̏ꍇɂ́AeImplƂOɂ

			// target = null; ȂĂꍇ邯ǁA܂
			// [NXɃk񂾂`Ȃ疳Ȃ

			// index=tokenArray.indexOfVal(";", index);

			Object o = null;
			try {
				Expression.run(sf);
				o = valueStack.pop();
				typeStack.pop();
			} catch (Throwable e) {
				e.printStackTrace();
			}

			if (o == null) {
				name = target.getSuperName() + "Impl()";
				String className = name.substring(0, name.indexOf('('));
				// RXgN^̖ONXɃZbgB
				target.setClassName(className);
				// eNX擾A^[QbgɃZbgB
				Class c = classNameResolver.getClazz(target.getSuperName());
				target.setSuperClass(c);
			} else {
				name = o.getClass().getName() + "()";
				name = name.substring(name.lastIndexOf(".") + 1);
				String className = name.substring(0, name.indexOf('('));
				// RXgN^̖ONXɃZbgB
				target.setClassName(className);
				// eNX擾A^[QbgɃZbgB
				Class c = classNameResolver.getClazz(target.getSuperName());
				target.setSuperClass(c);
			}
		}
		Object[] rs={name,argClazzes,args};
		return rs;
	}

	private static Object[] invokeMethod(SharedFields sf) throws Exception {
		TokenArray tokenArray = sf.tokenArray;

		String name = tokenArray.getVal(sf.index++);
		Object[] o2 = Arg.run(sf);
		Object[] argsVaules = (Object[]) o2[0];
		Class[] argsClasses = (Class[]) o2[1];
		
		String methodSign = SmallInterpreterSupportor.getMethodSignature(
				argsClasses, name);
		// ÔߌĂ΂ꂽ\bhL^
		sf.lastCallintTargetMethodName = methodSign;

		Object[] rs={methodSign,argsClasses,argsVaules};
		return rs;
	}

}
