package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class Variable {
	public static void run(SharedFields sf, Class type) throws Exception {
		TokenArray tokenArray = sf.tokenArray;

		Token t = tokenArray.getToken(sf.index++);
		if (t.getKind() == TokenKind.ArrayOpen) {
			array(sf, type);
		} else {
			String name = t.getVal();
			Token t2 = tokenArray.getToken(sf.index++);

			if (t2.getKind() == TokenKind.ArrayOpen) {
				array2(sf, type, name);
			} else {
				sf.vt.addVariable(name, type, sf.currentLevel);
				if (t2.getVal().equals("=")) {
					notArray(sf, type, name);
				}
			}
		}

		if (tokenArray.getVal(sf.index).equals(",")) {
			sf.index++;
			Variable.run(sf, type);
		}
	}

	private static void notArray(SharedFields sf, Class type, String name)
			throws Exception {
		
		if (sf.tokenArray.getVal(sf.index).equals(sf.targetName)) {
			// sl
			sf.index++;
			UndefinedValue undefV = UndefinedValue.getCompornent(type, name);
			TargetInvokingForUndefinedValue.run(sf, undefV, sf.target);

			Object o = sf.valueStack.pop();
			sf.typeStack.pop();
			sf.target.getRawUndefinedValues().put(name, undefV);
			sf.vt.setValAndLevel(name, o, sf.currentLevel);
			
		} else if (isUndefVal(sf)) {
			// slslĂ΂
			UndefinedValue targetUndef = (UndefinedValue) sf.vt
					.getVal(sf.tokenArray.getVal(sf.index));

			sf.index++;

			UndefinedValue undefV = UndefinedValue.getCompornent(type, name);
			TargetInvokingForUndefinedValue.run(sf, undefV, targetUndef);

			Object o = sf.valueStack.pop();
			sf.typeStack.pop();
			targetUndef.getRawUndefinedValues().put(name, undefV);
			sf.vt.setValAndLevel(name, o, sf.currentLevel);
			
		} else if (isCastTarget(sf)) {
			// LXg𖳎
			// sl
			sf.index++;// (
			sf.index++;// somethingClass
			sf.index++;// )
			sf.index++;//

			UndefinedValue undefV = UndefinedValue.getCompornent(type, name);
			TargetInvokingForUndefinedValue.run(sf, undefV, sf.target);

			Object o = sf.valueStack.pop();
			sf.typeStack.pop();
			sf.target.getRawUndefinedValues().put(name, undefV);
			sf.vt.setValAndLevel(name, o, sf.currentLevel);
		} else if (isCastUndefVal(sf)) {
			// slslĂ΂
			// LXg𖳎
			// sl
			sf.index++;// (
			sf.index++;// somethingClass
			sf.index++;// )

			UndefinedValue targetUndef = (UndefinedValue) sf.vt
					.getVal(sf.tokenArray.getVal(sf.index));

			sf.index++;

			UndefinedValue undefV = UndefinedValue.getCompornent(type, name);
			TargetInvokingForUndefinedValue.run(sf, undefV, targetUndef);

			Object o = sf.valueStack.pop();
			sf.typeStack.pop();
			targetUndef.getRawUndefinedValues().put(name, undefV);
			sf.vt.setValAndLevel(name, o, sf.currentLevel);
			
		} else {
			Expression.run(sf);
			Object o = sf.valueStack.pop();
			sf.typeStack.pop();

			if (o instanceof TargetClass) {
				TargetClass tempTarget=(TargetClass)o;
				UndefinedValue undefV = (UndefinedValue)sf.valueStack.pop();
				sf.typeStack.pop();
				tempTarget.getRawUndefinedValues().put(name, undefV);
				sf.vt.setValAndLevel(name, undefV, sf.currentLevel);

				tempTarget.overWriteMethodReType(sf.lastCallintTargetMethodName, LangMgn.getClassName(type));
				
			} else {

				// byte,short̏ꍇAinteger^Ă܂̂
				// Ŏ~߂
				// byte b =1; ̏ꍇAnew Integet(1)Ă܂B
				o = SmallInterpreterSupportor.toByteOrShort(type, o);

				sf.vt.setValAndLevel(name, o, sf.currentLevel);
			}
		}
	}

	private static boolean isCastTarget(SharedFields sf) {
		return sf.tokenArray.getVal(sf.index).equals("(")
				&& sf.tokenArray.getVal(sf.index + 3).equals(sf.targetName);
	}

	private static boolean isCastUndefVal(SharedFields sf) {
		if (sf.tokenArray.getVal(sf.index).equals("(")) {
			Token t = sf.tokenArray.get(sf.index + 3);
			if (t.getKind() == TokenKind.Word) {
				if (sf.vt.include(t.getVal())) {
					return sf.vt.getVal(t.getVal()).getClass() == UndefinedValue.class;
				}
			}
		}
		return false;
	}

	private static boolean isUndefVal(SharedFields sf) {
		Token t = sf.tokenArray.get(sf.index);
		if (t.getKind() == TokenKind.Word) {
			if (sf.vt.include(t.getVal())) {
				return sf.vt.getVal(t.getVal()).getClass() == UndefinedValue.class;
			}
		}
		return false;
	}

	private static void array(SharedFields sf, Class type) throws Exception {
		TokenArray tokenArray = sf.tokenArray;
		sf.index++;// ]i܂
		String name = tokenArray.getVal(sf.index++);
		if (name.equals("[")) {
			// 
			type = multiArrayType(sf, type);
			name = tokenArray.getVal(sf.index++);
			sf.vt.addVariable(name, ClassNameResolver.getArrayClass(type),
					sf.currentLevel);
		} else {
			sf.vt.addVariable(name, ClassNameResolver.getArrayClass(type),
					sf.currentLevel);
		}
		String s = tokenArray.getVal(sf.index++);
		if (s.equals("=")) {
			SetVariableArray.run(sf, name);
		}
	}

	private static Class multiArrayType(SharedFields sf, Class type) {
		TokenArray tokenArray = sf.tokenArray;
		while (tokenArray.getKind(sf.index) != TokenKind.Word) {
			if (tokenArray.getKind(sf.index) == TokenKind.ArrayClose) {
				type = ClassNameResolver.getArrayClass(type);
			}
			sf.index++;
		}
		return type;
	}

	private static void array2(SharedFields sf, Class type, String name)
			throws Exception {
		TokenArray tokenArray = sf.tokenArray;
		sf.index++;// ]i܂
		String s = tokenArray.getVal(sf.index);
		if (s.equals("[")) {
			sf.index++;// [
			type = multiArrayType(sf, type);
			sf.index--;// =
		}
		sf.vt.addVariable(name, ClassNameResolver.getArrayClass(type),
				sf.currentLevel);
		s = tokenArray.getVal(sf.index++);
		if (s.equals("=")) {
			SetVariableArray.run(sf, name);
		}
	}
}
