package org.kikaineko.mock.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Hashtable;

import org.kikaineko.source.util.LangMgn;

public class ToStringer implements KikainekoChar {
	/**
	 * @param i
	 * @return
	 */
	public static String get(int i) {
		return "int" + FIELD_OPEN + String.valueOf(i) + FIELD_CLOSE;
	}

	public static String get(double i) {
		return "double" + FIELD_OPEN + String.valueOf(i) + FIELD_CLOSE;
	}

	public static String get(long i) {
		return "long" + FIELD_OPEN + String.valueOf(i) + FIELD_CLOSE;
	}

	public static String get(float i) {
		return "float" + FIELD_OPEN + String.valueOf(i) + FIELD_CLOSE;
	}

	public static String get(boolean i) {
		return "boolean" + FIELD_OPEN + String.valueOf(i) + FIELD_CLOSE;
	}

	public static String get(byte i) {
		return "byte" + FIELD_OPEN + String.valueOf(i) + FIELD_CLOSE;
	}

	public static String get(short i) {
		return "short" + FIELD_OPEN + String.valueOf(i) + FIELD_CLOSE;
	}

	/**
	 * ͂ꂽɑ΂āA@BLGXP[vV[PXɂāAꕶGXP[vB
	 * 
	 * @param s
	 * @return
	 */
	public static String get(String s) {
		if (s == null)
			return "java.lang.String" + FIELD_OPEN + NULL + FIELD_CLOSE;

		StringBuffer sb = new StringBuffer();

		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (c == ESC || c == ARRAYCL || c == ARRAYOP || c == FIELD_OPEN
					|| c == FIELD_CLOSE) {
				sb.append(ESC);
			}
			sb.append(c);
		}

		return "java.lang.String" + FIELD_OPEN + sb.toString() + FIELD_CLOSE;
	}

	/**
	 * char^́Aׂint^̕\ƂĕԂB
	 * 
	 * @param i
	 * @return
	 */
	public static String get(char i) {
		return get((int) i).replaceAll("int", "char");
	}

	public static String get(Class c) {
		return "java.lang.Class" + FIELD_OPEN + c.getName() + FIELD_CLOSE;
	}

	/**
	 * v~eBu^̃bp[̕\^B
	 * 
	 * @param o
	 * @return
	 */
	private static String getPrimitiveWrapper(Object o) {
		String s = o.getClass().getName();
		if (s.equals(Integer.class.getName()))
			return "java.lang.Integer" + FIELD_OPEN + o.toString()
					+ FIELD_CLOSE;
		else if (s.equals(Long.class.getName()))
			return "java.lang.Long" + FIELD_OPEN + o.toString() + FIELD_CLOSE;
		else if (s.equals(Float.class.getName()))
			return "java.lang.Float" + FIELD_OPEN + o.toString() + FIELD_CLOSE;
		else if (s.equals(Double.class.getName()))
			return "java.lang.Double" + FIELD_OPEN + o.toString() + FIELD_CLOSE;
		else if (s.equals(Boolean.class.getName())) {
			return "java.lang.Boolean" + FIELD_OPEN + o.toString()
					+ FIELD_CLOSE;
		} else if (s.equals(Character.class.getName())) {
			char c = ((Character) o).charValue();
			return "java.lang.Character" + FIELD_OPEN + (int) c + FIELD_CLOSE;
		} else if (s.equals(Byte.class.getName()))
			return "java.lang.Byte" + FIELD_OPEN + o.toString() + FIELD_CLOSE;
		else if (s.equals(Short.class.getName()))
			return "java.lang.Short" + FIELD_OPEN + o.toString() + FIELD_CLOSE;
		else if (s.equals(String.class.getName()))
			return get((String) o);

		return null;
	}

	/**
	 * v~eBu^̃bp[̕\^B
	 * 
	 * @param o
	 * @return
	 */
	private static String getPrimitive(Object o, Class clazz) {
		if (int.class == clazz)
			return get(((Integer) o).intValue());
		else if (long.class == clazz)
			return get(((Long) o).longValue());
		else if (float.class == clazz)
			return get(((Float) o).floatValue());
		else if (double.class == clazz)
			return get(((Double) o).doubleValue());
		else if (boolean.class == clazz)
			return get(((Boolean) o).booleanValue());
		else if (char.class == clazz)
			return get(((Character) o).charValue());
		else if (byte.class == clazz)
			return get(((Byte) o).byteValue());
		else if (short.class == clazz)
			return get(((Short) o).shortValue());
		else if (String.class == clazz)
			return get(((String) o).toString());

		return null;
	}

	/**
	 * IuWFNg^̕\́ÃIuWFNg^tB[h \̏WƂĕ\B
	 * 
	 * @param o
	 * @return
	 */
	private static String innnerGet(Object o, Class clazz) {
		if (o == null)
			return "java.lang.Object" + FIELD_OPEN + NULL + FIELD_CLOSE;

		if (clazz != null && clazz.isPrimitive()) {
			return getPrimitive(o, clazz);
		}

		String s = getPrimitiveWrapper(o);
		if (s != null)
			return s;

		// LbV@\ǉ
		// ŏzQƂł邩IH
		if (!cash.containsKey(String.valueOf(o.hashCode()))) {
			cash.put(String.valueOf(o.hashCode()), o.getClass().getName()
					+ FIELD_OPEN + KikainekoChar.NULL + FIELD_CLOSE);
		} else {
			return (String) cash.get(String.valueOf(o.hashCode()));
		}

		if (o.getClass().isArray()) {
			if(clazz==null){
				clazz=o.getClass();
			}
			return array(o, clazz);
		}

		StringBuffer sb = new StringBuffer();
		try {

			Field[] fs = FieldSorter.sortWithOutFinalStaticTrans(o);
			AccessibleObject.setAccessible(fs, true);
			for (int i = 0; i < fs.length; i++) {
				sb.append(ToStringer.innnerGet(fs[i].get(o), fs[i]
						.getType()));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		String returnString = o.getClass().getName() + FIELD_OPEN
				+ sb.toString() + FIELD_CLOSE;

		// LbVB
		// ͓lʕϐŕێĂ󋵂̂߂ɃZbg
		cash.put(String.valueOf(o.hashCode()), returnString);
		return returnString;
	}

	/**
	 * z̕\^B
	 * 
	 * @param o
	 * @return
	 */
	private static String array(Object o, Class clazz) {
		Class unitClassInArray = LangMgn.underOneDimentionArray(clazz);
		if(unitClassInArray.isPrimitive()){
			return primitiveArray(o,clazz,unitClassInArray);
		}
		return notPrimitiveArray(o,clazz);
	}

	private static String primitiveArray(Object o,Class arrayClazz, Class unitClassInArray) {
		StringBuffer sb = new StringBuffer();
		sb.append(arrayClazz.getName());
		sb.append(FIELD_OPEN);
		for (int i = 0; i < Array.getLength(o); i++) {
			Object o2 = Array.get(o, i);
			sb.append(ToStringer.innnerGet(o2, unitClassInArray));
		}
		sb.append(FIELD_CLOSE);
		return sb.toString();
	}
	private static String notPrimitiveArray(Object o,Class arrayClazz) {
		StringBuffer sb = new StringBuffer();
		sb.append(arrayClazz.getName());
		sb.append(FIELD_OPEN);
		for (int i = 0; i < Array.getLength(o); i++) {
			Object o2 = Array.get(o, i);
			sb.append(ToStringer.innnerGet(o2, null));
		}
		sb.append(FIELD_CLOSE);
		return sb.toString();
	}
	
	public static String get(Object o) {
		return getStrick(o,null);
	}
	
	/**
	 * bJ[ł̓v~eBu^𐶂̂܂܈Ƃ͍ł邽
	 * Săbp[NXɕϊđ삳B
	 * ʂƂāAInteger^int^ToStringerɓnۂɍȂȂĂ܂B
	 * 邽߂Ɍ^𖾎IɎwł悤ɂB
	 * 
	 */
	private static Hashtable cash;
	public static String getStrick(Object o, Class clazz) {
		cash = new Hashtable();
		String s = innnerGet(o, clazz);
		return s;
	}
}
