package org.kikaineko.util;



public class IntArray {
	private int[] datas;

	private int addLength = 15;// 15

	private int length=0;
	
	public IntArray(){
		datas=new int[addLength];
	}
	public IntArray(int leng){
		datas=new int[leng];
	}
	private IntArray(int[] datas){
		this.datas=datas;
		this.length=datas.length;
	}

	private IntArray(int addLength,int length){
		this.addLength=addLength;
		this.length=length;
		this.datas=new int[length];
	}
	/**
	 * @return
	 */
	public int length() {
		return length;
	}

	/**
	 * ŏvalindexԂB
	 * 
	 * @param string
	 * @return
	 */
	public int indexOf(int value) {
		return indexOf(value, 0);
	}

	/**
	 * fromIndexȍ~̍ŏvalindexԂB
	 * 
	 * @param string
	 * @param fromIndex
	 * @return
	 */
	public int indexOf(int value, int fromIndex) {
		for (int i = fromIndex; i < length(); i++) {
			if (datas[i] == value)
				return i;
		}
		return -1;
	}

	/**
	 * iԖڂ̐lԂB
	 * 
	 * @param i
	 * @return
	 */
	public int get(int i) {
		return datas[i];
	}

	public void deleteThisVal(int value) {
		if (indexOf(value) == -1)
			return;
		int[] temp = new int[length];
		int index = 0;
		int tempLength = 0;
		for (int i = 0; i < length; i++) {
			if (datas[i] != value) {
				temp[index++] = datas[i];
				tempLength++;
			}
		}
		datas = temp;
		length = tempLength;
	}

	public boolean contains(int i) {
		return indexOf(i) != -1;
	}

	public void add(int i) {
		if(length()==datas.length){
			int[] temp = new int[length+addLength];
			System.arraycopy(datas, 0, temp, 0, datas.length);
			datas=temp;
		}
		datas[length++]=i;
	}

	public IntArray createCopy() {
		IntArray ia=new IntArray(this.addLength,this.length);
		System.arraycopy(this.datas, 0, ia.datas, 0, length);
		return ia;
	}

	public int getLast() {
		return datas[length()-1];
	}
	public int getFirst() {
		return datas[0];
	}
	public boolean isUniq(){
		int first=this.getFirst();
		for(int i=1;i<this.length();i++){
			if(first!=datas[i])
				return false;
		}
		return true;
	}
	public IntArray subArray(int from, int end) {
		int[] datas2 = new int[end - from];
		System.arraycopy(datas, from, datas2, 0, datas2.length);
		return new IntArray(datas2);
	}
	
	public String toString(){
		StringBuffer sb=new StringBuffer();
		for(int i=0;i<length();i++){
			sb.append(this.datas[i]);
			sb.append(",");
		}
		return sb.toString();
	}
}
