/***************************************************************************
*   Copyright (C) 2004 by Hideki Ikemoto , (c) 2004 by 421                *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "libkita/kita_misc.h"
#include "libkita/parsemisc.h"
#include "libkita/signalcollection.h"
#include "libkita/datmanager.h"
#include "libkita/board.h"
#include "kitawritetabwidget.h"
#include "kitawritedialog.h"

#include <kdebug.h>
#include <kstdaccel.h>
#include <kaction.h>
#include <klocale.h>
#include <kpopupmenu.h>

#include <qmessagebox.h>

/*--------------------------------------------------------------------------------*/


KitaWriteTabWidget::KitaWriteTabWidget( QWidget* parent, const char* name, WFlags f )
        : KitaTabWidgetBase( parent, name, f )
{
    setXMLFile( "kitawritetabwidgetui.rc" );
    setTabBar( new KitaWriteTabBar( this ) );

    connectSignals();
}


KitaWriteTabWidget::~KitaWriteTabWidget() {}


/* public slot */
void  KitaWriteTabWidget::slotShowWriteView( const KURL& url,
					     const QString& resStr,
					     const QString& mailAddr)
{
    KURL datURL = Kita::ParseMisc::parseURLonly( url );

    /* setup post info */
    int serverTime = Kita::DatManager::getServerTime( datURL );
    if ( !serverTime ) return;

    KURL bbscgiURL = KURL( Kita::DatManager::boardURL( datURL ), "../test/bbs.cgi" );
    bbscgiURL.setProtocol( "http" );

    Kita::PostInfo info;
    info.host = bbscgiURL.host();
    info.bbs = Kita::DatManager::boardID( datURL );
    info.key = Kita::DatManager::threadID( datURL );
    info.time = QString( "%1" ).arg( serverTime );
    info.body = resStr;
    info.mail = mailAddr;
    if ( ! info.check() ) return;
    
    // TODO: machiBBS kakiko support.
    if ( Kita::Board::isWritingSupported( datURL ) == false )
    {
        QMessageBox::warning( this, QString("<(_ _)>"),
                              i18n("Can't write to machi BBS in this version." ) );
        return;
    }

    /* view exists */
    KitaWriteDialog* view = findWriteView( datURL );
    if ( view ) {
	
	info = view->postInfo();
	if( info.body.length() ){
	    
	    if( QMessageBox::warning( this, "Kita",
				      i18n( "Do you want to clear the text?" ),
				      QMessageBox::Ok,
				      QMessageBox::Cancel | QMessageBox::Default ) == QMessageBox::Cancel ) return;
	}
	
	/* clear */
	info.body = resStr;
	view->clear( info );
        setCurrentPage( indexOf( view ) );
	return;
    }

    /* create new write view & add it to tab */
    QString threadName = Kita::DatManager::threadName( datURL );
    KitaWriteDialog* new_dlg = new KitaWriteDialog( this, "write dialog" );
    new_dlg->setup ( datURL );
    new_dlg->clear( info );
    connect( new_dlg, SIGNAL( closeCurrentTab() ), SLOT( slotCloseCurrentTab() ) );
    addTab( new_dlg, threadName );
    showPage( new_dlg );
}


/* close view which URL is url. */ /* public slot */
void KitaWriteTabWidget::slotCloseWriteTab( const KURL& url )
{
    if( count() == 0 ) return;
    
    KURL datURL = Kita::ParseMisc::parseURLonly( url );
    
    KitaWriteDialog* view = findWriteView( datURL );
    if ( view ) slotCloseTab( indexOf( view ) );
}


/* private */
void KitaWriteTabWidget::connectSignals()
{
    Kita::SignalCollection* signalCollection = Kita::SignalCollection::getInstance();

    connect( signalCollection, SIGNAL( activateThreadView( const KURL& ) ),
             this, SLOT( slotChangeWriteTab( const KURL& ) ) );
    connect( signalCollection, SIGNAL( closeWriteTab( const KURL& ) ),
             SLOT( slotCloseWriteTab( const KURL& )));
}


/* private */
KitaWriteDialog* KitaWriteTabWidget::findWriteView( const KURL& url )
{
    KURL datURL = Kita::ParseMisc::parseURLonly( url );

    int max = count();
    if( max == 0 ) return NULL;
    int i = 0;

    while( i < max ){
	KitaWriteDialog* view =  isWriteView( page ( i ) );
	if( view ){
	    if ( view->datURL() == datURL ) return view;
	}
	i++;
    }

    return NULL;
}


/* private */
KitaWriteDialog* KitaWriteTabWidget::isWriteView( QWidget* w )
{
    KitaWriteDialog* view = NULL;
    if( w ){
	if( w->isA( "KitaWriteDialog" ) ) view = static_cast< KitaWriteDialog* >( w );
    }

    return view;
}



/* when thread view is focused, this slot is called    */
/* See also KitaThreadView::setFocus.                  */ /* private slot */
void KitaWriteTabWidget::slotChangeWriteTab( const KURL& url )
{
    KitaWriteDialog* view;
    int max = count();
    if( max == 0 ) return;
    
    KURL datURL = Kita::ParseMisc::parseURLonly( url );

    /* disable all ok buttons. */
    int i = 0;
    while( i < max ){
	view = isWriteView( page( i ) );
	if( view ) view->slotEnableWriting( FALSE );
	i++;
    }

    /* show current url page. */
    view = findWriteView( datURL );
    if ( view ){
	static_cast< KitaDockWidgetBase* >( parentWidget() )->slotShowDock( FALSE, FALSE );
	if( currentPage() != view ) setCurrentPage( indexOf( view ) );
	view->slotEnableWriting( TRUE );
    }
}


/* protected */ /* virtual */
void KitaWriteTabWidget::deleteWidget( QWidget* w )
{
    KitaTabWidgetBase::deleteWidget( w );
    
    if ( count() == 0 ){
	static_cast< KitaDockWidgetBase* >( parentWidget() )->slotHideDock();
    }
}




/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/



KitaWriteTabBar::KitaWriteTabBar( QWidget* parent, const char* name ) : KitaTabBarBase( parent, name ){}

KitaWriteTabBar::~KitaWriteTabBar(){}



/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/
/*---------------------------------------------------------------------*/


/* Don't forget to call setup later ! */
KitaWriteDock::KitaWriteDock( KDockManager* dockManager,
		    const char* name,
		    const QPixmap &pixmap,
		    QWidget* parent,
		    const QString& strCaption,
		    const QString& strTabPageLabel,
		    WFlags f )
    :KitaDockWidgetBase( dockManager, name, pixmap, parent, strCaption, strTabPageLabel, f ),m_writeTab( 0 ){}


KitaWriteDock::~KitaWriteDock(){}


KitaWriteTabWidget* KitaWriteDock::setup()
{
    if( m_writeTab ) return NULL;
    m_writeTab = new KitaWriteTabWidget( this, "Write View" );
    setWidget( m_writeTab );

    Kita::SignalCollection* signalCollection = Kita::SignalCollection::getInstance();
    connect( signalCollection, SIGNAL( showWriteView( const KURL& , const QString&,const QString& ) ),
	     this, SLOT( slotShowWriteView( const KURL& , const QString&,const QString& ) ) );
    connect( signalCollection, SIGNAL( switchToWritedock() ),
	     SLOT( slotShowDock() ) );
    
    return m_writeTab;
}


void  KitaWriteDock::slotShowWriteView( const KURL& url,
					     const QString& resStr,
					     const QString& mailAddr)
{
    if( !m_writeTab ) return;
    
    slotShowDock();
    m_writeTab->slotShowWriteView( url, resStr, mailAddr );
}
