/***************************************************************************
 *   Copyright (C) 2004 by Kita Developers                                 *
 *   ikemo@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef KITAACCOUNT_H
#define KITAACCOUNT_H

#include <qobject.h>

namespace KIO
{
    class Job;
}

namespace Kita
{

    /**
    @author Hideki Ikemoto
    */
    class Account : public QObject
    {
        Q_OBJECT
        static Account* instance;

        KIO::Job* m_job;
        QCString m_data;
        QString m_sessionID;
        bool m_isLogged;

        Account();
        ~Account();
        void enter_loop();
        bool loginInternal( const QString& userID, const QString& password );
        static Account* getInstance();
    private slots:
        void slotReceiveData( KIO::Job* job, const QByteArray& data );
        void slotResult( KIO::Job* job );
    public:
        static const QString& getSessionID() { return getInstance()->m_sessionID; }
        static bool isLogged() { return getInstance()->m_isLogged; }
        static bool login( const QString& userID, const QString& password );
    };

}

#endif
