/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@wakaba.jp                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "kita_misc.h"

#include <kurl.h>
#include <qregexp.h>

QString Kita::datToBoard( const QString& datURL )
{
    KURL url( datURL );
    return KURL( url, "../" ).url();
}

QString Kita::datToThread( const QString& datURL )
{
    // http://<root>/<board>/dat/<datname>.dat
    KURL url( datURL );
    QString protocol = url.protocol();
    QString root = url.host();

    QStringList list = QStringList::split( ".", url.fileName() );
    if ( list.size() != 2 ) {
        return QString::null;
    }
    QString datName = list[ 0 ];

    url.cd( ".." );
    if ( url.fileName() != "dat" ) {
        return QString::null;
    }

    url.cd( ".." );
    QString board = url.fileName();

    url.cd( ".." );
    if ( url.path() != "/" ) {
        root += url.path();
    }

    KURL newURL = protocol + "://" + root;

    // FIXME: TOOOOOOOOOOOOOOOOOOOOOO ugly.
    QRegExp host_machibbs( ".*\\.machi\\.to" );
    if ( host_machibbs.search( root ) != -1 ) {
        newURL.addPath( "/bbs/read.pl" );
        newURL.addQueryItem( "BBS", board );
        newURL.addQueryItem( "KEY", datName );
    } else {
        newURL.addPath( QString( "/test/read.cgi/%2/%3/" )
                        .arg( board ).arg( datName ) );
    }

    return newURL.url();
}

QString Kita::threadToDat( const QString& threadURL )
{
    KURL url( threadURL );
    QString filename = url.fileName();
    QString protocol = url.protocol();
    QString host = url.host();

    url.cd( ".." );
    QString board = url.fileName();

    url.cd( ".." );
    if ( url.path() != "/test/read.cgi" ) {
        return QString::null;
    }

    KURL newURL;
    newURL.setProtocol( protocol );
    newURL.setHost( host );
    newURL.addPath( QString( "/%1/dat/%2.dat" )
                    .arg( board ).arg( filename ) );

    return newURL.url();
}

QString Kita::boardToSubject( const QString& boardURL )
{
    KURL url( boardURL );
    url.addPath( "subject.txt" );
    return url.url();
}

QString Kita::subjectToBoard( const QString& subjectURL )
{
    return KURL( subjectURL, "." ).url();
}

QString Kita::datToCache( const QString& datURL )
{
    // http://<root>/<board>/dat/<datname>.dat
    KURL url( datURL );
    QString root = url.host();
    QString filename = url.fileName();

    url.cd( ".." );
    if ( url.fileName() != "dat" ) {
        return QString::null;
    }

    url.cd( ".." );
    QString board = url.fileName();

    url.cd( ".." );
    if ( url.path() != "/" ) {
        root += url.path().replace( "/", "." );
    }

    return QString( "%1/%2/%3" ).arg( root ).arg( board ).arg( filename );
}

QString Kita::httpToK2ch( const QString& httpURL )
{
    KURL url( httpURL );
    url.setProtocol( "k2ch" );

    return url.url();
}

QString Kita::unescape( const QString& str )
{
    QString ret = str;
    return ret.replace( "&lt;", "<" ).replace( "&gt;", ">" ).replace( "&amp;", "&" );
}

int Kita::boardType( const QString& url )
{
    QRegExp url_machibbs( "http://.*\\.machi\\.to/.*" );
    QRegExp url_jbbs( "http://jbbs.shitaraba.com/.*" );
    if ( url_machibbs.search( url ) != -1 ) {
        return Board_MachiBBS;
    } else if ( url_jbbs.search( url ) != -1 ) {
        return Board_JBBS;
    } else {
        return Board_2ch;
    }
}

uint Kita::datToSince( const QString& datURL )
{
    return KURL( datURL ).fileName().section( '.', 0, 0 ).toInt();
}

/**
 * http://pc5.2ch.net/linux/dat/1089905503.dat
 * -> http://pc5.2ch.net/test/offlaw.cgi?bbs=linux&key=1089905503
 */
QString Kita::datToOfflaw( const QString& datURL )
{
    /* TODO: not tested. */
    KURL url( datURL );
    QString root = url.host();

    QStringList list = QStringList::split( ".", url.fileName() );
    if ( list.size() != 2 ) {
        return QString::null;
    }
    QString datName = list[ 0 ];

    url.cd( ".." );
    if ( url.fileName() != "dat" ) {
        return QString::null;
    }

    url.cd( ".." );
    QString board = url.fileName();

    return QString( "http://%1/test/offlaw.cgi?raw=0.0&bbs=%2&key=%3" ).arg( root ).arg( board ).arg( datName );
}

bool Kita::is2ch( const KURL& url )
{
    QRegExp url_2ch( "http://.*\\.2ch\\.net/.*" );
    QRegExp url_bbspink( "http://.*\\.bbspink\\.com/.*" );

    if ( url.isEmpty() ) return false;

    if ( url_2ch.search( url.prettyURL() ) != -1 || url_bbspink.search( url.prettyURL() ) != -1 ) {
        return true;
    }

    return false;
}

QString Kita::parse_machibbs_dat( const QString& datStr )
{
    QString ret;
    QStringList lines = QStringList::split( "\n", datStr );
    // pattern 1 (tokyo,kanagawa,...)
    QRegExp regexp( "<dt>(.*) .*<font color=\"#......\"><b> (.*) </b></font> .* (..../../..).* (..:..:..) ID:(.*)<br><dd>(.*)" );
    QRegExp regexp2( "<dt>(.*) .*<a href=\"mailto:(.*)\"><b> (.*) </B></a> .* (..../../..).* (..:..:..) ID:(.*)<br><dd>(.*)" );

    // pattern 2 (hokkaido,...)
    QRegExp regexp3( "<dt>(.*) .*<font color=\"#......\"><b> (.*) </b></font> .* (..../../..).* (..:..:..) ID:(.*)<font size=.>\\[ .*" );
    QRegExp regexp4( " \\]</font><br><dd>(.*)" );
    QRegExp regexp5( "<dt>(.*) .*<a href=\"mailto:(.*)\"><b> (.*) </B></a> .* (..../../..).* (..:..:..) ID:(.*)<font size=.>\\[ .*" );
    for ( QStringList::iterator it = lines.begin(); it != lines.end(); ++it ) {
        QString line = ( *it );
        if ( regexp.search( line ) != -1 ) {
            int num = regexp.cap( 1 ).toInt();
            QString name = regexp.cap( 2 );
            QString date = regexp.cap( 3 );
            QString time = regexp.cap( 4 );
            QString id = regexp.cap( 5 );
            QString message = regexp.cap( 6 );
            QString datStr = name + "<><>" + date + " " + time + " ID:" + id
                             + "<>" + message + "<>\n";
            ret += datStr;
        } else if ( regexp2.search( line ) != -1 ) {
            int num = regexp2.cap( 1 ).toInt();
            QString mail = regexp2.cap( 2 );
            QString name = regexp2.cap( 3 );
            QString date = regexp2.cap( 4 );
            QString time = regexp2.cap( 5 );
            QString id = regexp2.cap( 6 );
            QString message = regexp2.cap( 7 );
            QString datStr = name + "<>" + mail + "<>" + date + " " + time + " ID:" + id
                             + "<>" + message + "<>\n";
            ret += datStr;
        } else if ( regexp3.search( line ) != -1 ) {
            ++it;
            if ( it == lines.end() ) break;
            QString nextLine = ( *it );
            if ( regexp4.search( nextLine ) != -1 ) {
                int num = regexp3.cap( 1 ).toInt();
                QString name = regexp3.cap( 2 );
                QString date = regexp3.cap( 3 );
                QString time = regexp3.cap( 4 );
                QString id = regexp3.cap( 5 );
                QString message = regexp4.cap( 1 );
                QString datStr = name + "<><>" + date + " " + time + " ID:" + id
                                 + "<>" + message + "<>\n";
                ret += datStr;
            }
        } else if ( regexp5.search( line ) != -1 ) {
            ++it;
            if ( it == lines.end() ) break;
            QString nextLine = ( *it );
            if ( regexp4.search( nextLine ) != -1 ) {
                int num = regexp5.cap( 1 ).toInt();
                QString mail = regexp5.cap( 2 );
                QString name = regexp5.cap( 3 );
                QString date = regexp5.cap( 4 );
                QString time = regexp5.cap( 5 );
                QString id = regexp5.cap( 6 );
                QString message = regexp4.cap( 1 );
                QString datStr = name + "<>" + mail + "<>" + date + " " + time + " ID:" + id
                                 + "<>" + message + "<>\n";
                ret += datStr;
            }
        }
    }
    return ret;
}
