"""BBS Module"""

from __future__ import generators

BOARD_MENU_URL = "http://www.ff.iij4u.or.jp/~ch2/bbsmenu.html"
BOARD_MENU_HOST = "www.ff.iij4u.or.jp"
BOARD_MENU_PATH = "/~ch2/bbsmenu.html"
USER_AGENT = "Monazilla/1.00 (KittyWalk/dev)"

# HTTP status
HTTP_STATUS_OK = 200
HTTP_STATUS_NOT_MODIFIED = 304
HTTP_PARTIAL_CONTENT = 206

import re
import urllib2
import os.path
import string
from util import *
import urllib
from config import Config
import cookie
from xml.dom import minidom
import observer

CONFIG = Config()

class BBS(list):
    """BBS containing categoris->borads->threads tree."""

    def __init__(self, name="2ch"):
        list.__init__(self)
        self.name = name
        self.build()

    def __str__(self):
        return "<BBS %s>" % self.name

    def build(self):
        """f\z"""
        del self[:]
        filename = os.path.join("dat", "bbsmenu.xml")
        try:
            fin = open_necessary_file(filename,"r")
            bbsxml = minidom.parseString(fin.read())
            fin.close()
        except:
            return False

        for category_node in bbsxml.getElementsByTagName("category"):
            name = category_node.attributes["name"].value
            current_category = Category(name)
            for board_node in category_node.getElementsByTagName("board"):
                name = board_node.attributes["name"].value
                host = board_node.attributes["host"].value
                dir = board_node.attributes["dir"].value
                current_category.append(Board(host, dir, name))
            # JeS[̑傫 0 傫ΒǉB
            if len(current_category) > 0:
                self.append(current_category)

    def update(self):
        """Update board menu via Internet"""
        # Download board menu.
        fin = http_get(BOARD_MENU_HOST, BOARD_MENU_PATH)
        boardmenu = fin.read()
        fin.close()
        # Save
        fout = open_necessary_file(os.path.join("dat","bbsmenu.html"), "w")
        fout.write(boardmenu)
        fout.close()
        # XML ɕϊB
        bbsmenu2xml()


class Category(list):
    def __init__(self, name):
        self.name = name

    def __str__(self):
        return "<BBS Category %s>" % self.name


class Board(object):
    def __init__(self, host, dir, name):
        self._threads = []
        self.name = name
        self.host = host
        self.dir = dir
        self.subject_dir = os.path.join("dat", self.host, self.dir)
        self.subject_file = os.path.join("dat", self.host, self.dir,
                                          "subject.txt")
        self.record_file = os.path.join("dat", self.host, self.dir,
                                        "subject.rec")
        self.subject_url = "http://%s/%s/%s"%(self.host, self.dir,
                                              "subject.txt")

    def get_threads(self):
        if not self._threads:
            self._load()
        return self._threads

    def update(self):
        self._download()
        self._load()

    def _load(self):
        """Load thread list"""
        # Open file.
        filename = self.subject_file
        fin = open_necessary_file(filename, "r")
        # For each line of thread list, Read, parse, and store.
        self._threads = []
        for line in fin.readlines():
            line = unicode(line, "ms932", "replace")
            match = re.match(u"(.+)<>(.+)\((\d+)\)", line)
            if match:
                filename, thread_title, size = match.groups()
                thread_title = thread_title
                thread = Thread(self.host, self.dir, filename, thread_title,
                                size)
                self._threads.append(thread)
        # Close URL.
        fin.close()

    def _download(self):
        """Donwload thread list via Internet and save in local file."""
        # Retrieve thread list from 2ch.
        path = "/%s/subject.txt" % (self.dir)
        header = {"User-Agent": USER_AGENT,
                  "Accept-Encoding":"gzip",
                  "If-modified-since":self._last_modified()}
        res = http_get(self.host, path, header)
        # If 2ch sends subject.txt content, save it.
        if res.status == HTTP_STATUS_OK:
            # Write thread list on local file.
            fout = open_necessary_file(self.subject_file,"w")
            if res.getheader("Content-Encoding") == "gzip":
                data = gunzip(res.read())
            else:
                data = res.read()
            fout.write(data)
            fout.close()
            # Set last-modified field.
            self._last_modified(res.getheader("last-modified"))
        return res.status

    def _last_modified(self, val=None):
        """Save last-modified value if val is specified, or return 
        last-modified value otherwise.
        """
        if val:
            fout = open_necessary_file(self.record_file, "w")
            fout.write(val)
            fout.close()
        else:
            if os.path.exists(self.record_file):
                fin = open(self.record_file,"r")
                val = fin.readline().strip()
                fin.close()
            else:
                val = ""
            return val

class Thread(object):
    """Message thread -- a sequence of messages."""

    def __init__(self, host, dir, filename, title, remote_size=0):
        self.host = host
        self.title = title
        self.dir = dir
        self.filename = filename
        self.url_path = "/%s/dat/%s" % (dir, filename)
        self.dat_file = os.path.join("dat", self.host, dir,"dat", filename)
        self.record_filename = self.dat_file + ".rc"

        self.remote_size = int(remote_size)
        self.local_size = 0
        self.last_modified = ""
        self._load_record()

    def identity(self):
        return "%s/%s/%s" % (self.host, self.dir, self.filename)

    def messages(self):
        """݂ЂƂԂB"""
        # For each line, read, parse and store.
        fin = open_necessary_file(self.dat_file ,"r")
        index = 0
        for line in fin.xreadlines():
            line = unicode(line, "ms932","replace")
            match = re.match(u"(.*?)<>(.*?)<>(.*?)<>(.*)<>", line)
            if match:
                # Parse.
                name, email, time, text = match.groups()
                index += 1
                # Store.
                yield Message(name=name, email=email, time=time, text=text,
                              index=index)
        fin.close()
        # Information.
        self.local_size = index
        self._save_record()

    def download(self):
        """Download thread messages by accessing Internet."""
        path = self.url_path
        # If dat file exists, download only part of dat file.  Otherwise, 
        # download whole file.
        proxy = CONFIG.get("Proxy","Get")
        if os.path.exists(self.dat_file):
            size = os.stat(self.dat_file).st_size
            header = {"User-Agent": USER_AGENT,
                     "If-modified-since": self.last_modified,
                     "Range": "bytes=%d-" % size}
            res = http_get(self.host, path, header)
            # If partial content is sent back, append it to local file.
            if res.status == HTTP_PARTIAL_CONTENT:
                fout = open_necessary_file(self.dat_file,"ab")
                fout.write(res.read())
                fout.close()
        else:
            header = {"User-Agent": USER_AGENT,
                      "Accept-Encoding": "gzip"}
            res = http_get(self.host, path, header)
            if res.status == HTTP_STATUS_OK:
                self.last_modified = res.getheader("last-modified")
                dat = res.read()
                # gunzip if necessary.
                if res.getheader("Content-Encoding") == "gzip":
                    dat = gunzip(dat)
                # Write on local file.
                path = self.dat_file
                fout = open_necessary_file(path,"wb")
                fout.write(dat)
                fout.close()
        # Clean.
        self._save_record()
        return res.status

    def is_uptodate(self):
        """Retrun whether the local data of this thread is up to date."""
        if (self.local_size > 0) and (self.local_size < self.remote_size):
            return False
        else:
            return True

    def size(self):
        """X̃XԂ"""
        fin = open_necessary_file(self.dat_file, "r")
        self.local_size = len(fin.readlines())
        fin.close()
        # L^ۑƂB
        self._save_record()
        #
        return self.local_size

    def _load_record(self):
        filename = self.record_filename
        if not os.path.exists(filename):
            return
        file = open(filename, "r")
        for line in file.xreadlines():
            line = line.strip()
            key, val = line.split(":", 1)
            # The larger value of val or old, is the newer value.
            if key == "local_size" or key=="remote_size":
                val = int(val)
                old = getattr(self, key)
                if old > val: val = old
            setattr(self, key, val)
        file.close()

    def _save_record(self):
        filename = self.record_filename
        file = open_necessary_file(filename, "w")
        file.write("local_size:%d\n" % self.local_size)
        file.write("remote_size:%d\n" % self.remote_size)
        file.write("last_modified:%s\n" % self.last_modified)
        file.close()


class Message(dict):
    """Single message, ie. Kakiko"""
    _attributes = ["name", "email", "time", "text", "index"]
    _unnecessary_tag_re = re.compile("</?b>", re.I)

    def __init__(self, **kw):
        for key in self._attributes:
            self[key] = kw[key]
        # Remove extra tag from name filed.
        self["name"] = self._unnecessary_tag_re.sub("", self["name"])


import time
import socket


class Poster(observer.Observable):
    _success_re = re.compile(unicode("݂܂B","ms932"))
    _cookie_re =\
      re.compile(unicode("NbL[mF","ms932"))
    _error_re = re.compile(unicode("dqqnqF([^<]+)","ms932"))

    def __init__(self):
        observer.Observable.__init__(self)
        self._log = u""
        self._connection = None

    # goRua 0.15 B
    def post(self, thread, mail=u"", name=u"", message=u""):
        self._log = u""
        # `FbNB
        if message == None:
            return False
        # Unicode ́ASJIS GR[hꂽɕϊB
        if type(mail) == type(u""): mail = mail.encode("sjis","replace")
        if type(name) == type(u""): name = name.encode("sjis","replace")
        if type(message) == type(u""): message = message.encode("sjis","replace")

        # p[^B
        key = thread.filename.replace(".dat","")
        bbs = thread.dir
        #sectime = int(time.mktime(time.localtime())) - 100
        sectime = key
        host = thread.host
        params = urllib.urlencode({ "submit":"submit",
                                    "bbs":bbs,
                                    "key":key,
                                    "time":sectime,
                                    "FROM":name,
                                    "mail":mail,
                                    "MESSAGE":message})
        # HTTP wb_B
        referer = "http://%s/%s/index2.html" % (host, dir)
        headers = {"Content-type": "application/x-www-form-urlencoded",
                   "Accept": "text/plain",
                   "Referer": referer,
                   "User-Agent":USER_AGENT,
                   "Cookie":cookie.get(host)}
        
        # POST BNbL[G[̏ꍇ̂݁AĎsB
        proxy = CONFIG.get("Proxy","Post")
        path = "/test/bbs.cgi"
        for i in range(3):
            try:
                if proxy:
                    path = "http://%s%s" % (host, path)
                    host = proxy
                self._connection = httplib.HTTPConnection(host)
                self._connection.request("POST", path, params,headers)
                response = self._connection.getresponse()
                data = unicode(response.read(),"ms932","replace")
            except socket.error:
                self._log += u"FAILED"
                self.notify()
                return False
            self._log += data
            self.notify()

            # ݂łĂΐIANbL[nĂđMB
            # ̑̃G[ȂG[ŏIB
            if self._success_re.search(data):
                self._log += unicode("\n\n"
                                    "--------------\n"
                                    "݂܂\n"
                                    "--------------\n"
                                    "OK",
                                    "sjis")
                self.notify()
                return True
            elif self._cookie_re.search(data):
                cookie.set(host, response.msg.get("set-cookie"))
                continue
            else:
                self._log += unicode("\n\n"
                                    "--------------------\n"
                                    "߂܂ł\n"
                                    "--------------------\n"
                                    "FAILED",
                                    "sjis")
                self.notify()
                return False
        else:
            self._log += unicode("\n\n"
                                 "--------------------\n"
                                 "߂܂ł\n"
                                 "--------------------\n"
                                 "FAILED",
                                 "sjis")

    def cancel(self):
        if self._connection:
            self._connection.close()
        self._log += unicode("\n\n"
                             "------------------\n"
                             "LZ܂\n"
                             "------------------\n"
                             "END",
                             "sjis")

    def get_state(self):
        return self._log


#
# Utilities
#


def bbsmenu2xml():
    """Q˂邩擾{[hꗗAXML `ɕϊĕۑB"""
    start_category_re = re.compile(u"<BR><BR><B>(.*?)</B><BR>", re.I)
    end_category_re = re.compile(u"^\s*$")
    board_re = re.compile(u"<A HREF=http://(.*?)/(.*?)/>(.*?)</A>", re.I)
    fin = file(os.path.join("dat","bbsmenu.html"),"r")
    fout = file(os.path.join("dat","bbsmenu.xml"),"w")

    current_category = None
    fout.write("""<?xml version="1.0" encoding="UTF-8"?>\n""")
    fout.write("<bbs>\n")
    for line in fin.xreadlines():
        line = unicode(line, "ms932", "replace")
        start_category_match = start_category_re.match(line)
        end_category_match = end_category_re.match(line)
        board_match = board_re.match(line)
        if start_category_match:
            name = start_category_match.groups()[0]
            if name == unicode("`bg","ms932"): break
            out = u"""  <category name="%s">\n""" % name
            fout.write(out.encode("utf-8","ignore"))
            current_category = True
        elif end_category_match:
            if current_category:
                fout.write("  </category>\n")
                current_category = None
        elif board_match:
            if current_category:
                host, dir, name = board_match.groups()
                out = u"""    <board host="%s" dir="%s" name="%s"/>\n""" %\
                  (host, dir, name)
                fout.write(out.encode("utf-8","ignore"))
    fout.write(u"""</bbs>""")
    
    fin.close()
    fout.close()


# EOF
