"""Bookmark ie list of favorite threads"""

import os.path
import bbs
import sys

class Bookmark(list):
    def __init__(self, filename):
        self.filename = filename
        self.load()

    def load(self):
        """Load bookmark entris from local file and store in itself"""
        filename = self.filename
        # If file does not exist, create empty file.
        if not os.path.exists(filename):
            fout = open(filename,"w")
            fout.close()
        # Read and store.
        fin = open(self.filename,"r")
        for line in fin.readlines():
            line = unicode(line, "UTF-8","replace").strip()
            try:
                title, host, dir, filename = line.split(u"<>")
                if filename == "":
                    item = bbs.Board(host, dir, title)
                else:
                    item = bbs.Thread(host, dir, filename, title)
                self.append(item)
            except:
                print >>sys.stderr, "Error: cannot parse bookmark file"
        fin.close()

    def save(self):
        fout = open(self.filename, "w")
        for item in self:
            if isinstance(item, bbs.Thread):
                line = u"%(title)s<>%(host)s<>%(dir)s<>%(filename)s\n" %\
                  item.__dict__
                fout.write(line.encode("UTF-8","replace"))
            elif isinstance(item, bbs.Board):
                line = u"%(name)s<>%(host)s<>%(dir)s<>\n" %\
                  item.__dict__
                fout.write(line.encode("UTF-8","replace"))
            else:
                print type(item)
        fout.close()
# EOF
