"""Configuration"""

import os.path
import ConfigParser
import os
from util import *

DIR = ".kittywalk"
FILENAME = "config"

default_config = {
  "Font" : {
    "UI": "{MS UI Gothic} 10",
    "Entry": "{MS Gothic} 12",
    "Content": "{MS PGothic} 12",
    "Cite":"{MS PGothic} 10",
  },

  "Menu": {
    "Font": "{MS UI Gothic} 10"
  },
  
  "Window": {
    "Geometry": "640x480+0+0",
    "ScrollUnit":"4"
  },

  "Entry": {
    "Font":"{MS Gothic} 12",
  },

  "MessageView": {
    "Font":"{MS PGothic} 12",
    "ScrollUnit":"3"
   },

   "BoardMenu" : {
     "Font":"{MS PGothic} 10",
     "ScrollUnit":"3"
   },

   "Bookmark" : {
     "Font":"{MS PGothic} 9",
     "ScrollUnit":"3",
     "File": os.path.join(os.path.expanduser("~"), DIR, "bookmark"),
   },

   "ThreadMenu" : {
     "Font":"{MS PGothic} 10",
     "ScrollUnit":"3"
   },

   "StatusBar" : {
     "Font":"{MS PGothic} 10"
   },

   "Proxy" : {
     "Post":"",
     "Get":""
   },

   "Operation" : {
     "UseMouseWheel":"True"
   },

   "ThreadView" : {},

   "test" : {},

   "dolib": {
     "use": "0",
     "id": "",
     "password": ""
   }
}

CONFIG_OBJECT = None


class _Config(ConfigParser.ConfigParser):
    """Configuration file handler"""
    def __init__(self):
        ConfigParser.ConfigParser.__init__(self)
        # Determine config file path.
        home_dir = os.path.expanduser("~")
        dir = os.path.join(home_dir, DIR)
        self.filename = os.path.join(dir, FILENAME)
        if (not os.path.exists(dir)) or (not os.path.isdir(dir)):
            self.create_dir(dir)
        # Default.
        for section in default_config.keys():
            options = default_config[section]
            self.add_section(section)
            for key in options:
                ConfigParser.ConfigParser.set(self, section, key, options[key])
        # Read.
        self.read([self.filename])

    def get(self, section, option):
        try:
            val = ConfigParser.ConfigParser.get(self, section, option)
        except ConfigParser.NoOptionError:
            val = None
        if val=="0" or val=="1":
            val = int(val)
        return val

    def set(self, section, option, value):
        ConfigParser.ConfigParser.set(self,section,option,str(value))
        fout = open(self.filename, "w")
        self.write(fout)
        fout.close()

    def create_dir(self, dir):
        if not os.path.isdir(dir):
            os.rename(dir, "%s.bak"%dir)
        os.mkdir(dir)


def Config():
    """Return ConfigParser sub-object

    Only 1 instance of Config class is availabe as singleton.
    You don't need to save configuration on file, since _Conifg object's 
    destructor save the info.
    """
    global CONFIG_OBJECT
    if CONFIG_OBJECT:
        return CONFIG_OBJECT
    else:
        CONFIG_OBJECT = _Config()
        return CONFIG_OBJECT


def get(section, option):
    """Return option's value"""
    return Config().get(section, option)

def set(section, option, value):
    """Set option's value"""
    Config().set(section, option, value)

# EOF
