"""KittyTk -- Toolkit used in KittyWalk

Widgets defined here are subclasses of Pmw and Tk widgets.
"""

import Tkinter as Tk
import Pmw
from util import *


class TriPaneFrame(Tk.Frame):
    def __init__(self, parent=None, **kw):
        Tk.Frame.__init__(self, parent, kw)
        # Make left/right panes.
        panes = Pmw.PanedWidget(self,
                                orient=Tk.HORIZONTAL,
                                separatorrelief=Tk.FLAT,
                                separatorthickness=4,
                                handlesize=0)
        panes.add("left")
        panes.add("right")
        panes.pack(expand=Tk.YES, fill=Tk.BOTH, pady=2)
        left_pane = panes.pane("left")
        # Make top/buttom panes on the right.
        right_panes = Pmw.PanedWidget(panes.pane("right"),
                                      separatorrelief=Tk.FLAT,
                                      separatorthickness=4,
                                      handlesize=0)
        right_panes.add("top")
        right_panes.add("bottom")
        right_panes.pack(expand=Tk.YES, fill=Tk.BOTH)
        top_pane = right_panes.pane("top")
        bottom_pane = right_panes.pane("bottom")

        # Store.
        self.left = left_pane
        self.right_top = top_pane
        self.right_bottom = bottom_pane

        # Configurations.
        self.left.config(relief=Tk.SUNKEN, border=2)
        self.right_top.config(relief=Tk.SUNKEN)
        self.right_bottom.config(relief=Tk.SUNKEN)


class EntryField(Tk.Frame):
    def __init__(self, parent=None, label="", text="", entrywidth=None,
                 labelfont="Sans", entryfont="Fixed", **kw):
        Tk.Frame.__init__(self, parent, kw)
        # xB
        self._label = Tk.Label(self, font=labelfont, text=label)
        self._label.pack(side=Tk.LEFT)
        # ͗B
        self._entry = Tk.Entry(self, font=entryfont)
        self._entry.delete(0, Tk.END)
        self._entry.insert(0, text)
        self._entry.pack(side=Tk.RIGHT)
        if entrywidth:
            self._entry.config(width=entrywidth)
        # ҏWp|bvAbvj[B
        font = labelfont
        self._menu = PopupMenu(self._entry,
                               [(j("؂"), self._cut),
                                (j("Rs["), self._copy),
                                (j("\t"), self._paste)],
                               font=labelfont)
        pass

    def set(self, text):
        self._entry.delete(0, Tk.END)
        self._entry.insert(0, text)

    def get(self):
        return self._entry.get()

    def _popup_menu(self, event):
        self._menu.tk_popup(event.x_root, event.y_root)

    def _cut(self):
        self._menu.event_generate("<Control-x>")

    def _copy(self):
        self._menu.event_generate("<Control-c>")

    def _paste(self):
        self._menu.event_generate("<Control-v>")


class PopupMenu(Tk.Menu):
    """Popup menu widget.

    PopupMenu class inherits Tkinter.Menu specialized for popup menu 
    widget. A instance menu appears when you right-click.  Typical use 
    with Text widget is;
    ----
    import Tkinter
    text = Tkinter.Text()
    text.pack()
    p = PopupMenu(text, [("Copy", callback), ("Paste", callback)])
    Tk.mainloop()
    ----
    Right-click on the text widget and you will get a menu poped up.

    """
    
    def __init__(self, parent=None, spec=[], font="Helvetica 10"):
        """Create menu.

        spec must be a list of tuple such as (label, callback).  For 
        example, [("Cut", func1), ("Copy", func2), ("Paste", func3)].  
        label must be an ASCII / Unicode string.  Encoded string, eg 
        SJIS, will not work.
        """
        Tk.Menu.__init__(self, parent, tearoff=0)
        for label, command in spec:
            self.add_command(label=label, command=command, font=font)
            pass
        parent.bind("<3>", self.popup, "+")
        pass

    def popup(self, event):
        """Popup this menu."""
        self.tk_popup(event.x_root, event.y_root)
        pass

    pass


class ScrolledListBox(Pmw.ScrolledListBox):
    """Scrolled listbox widget with popup menu."""

    _rmenu_font = "Helvetica 10"

    def __init__(self, parent=None, rmenu_spec=[] ,**kw):
        Pmw.ScrolledListBox.__init__(self, parent, **kw)
        self._listbox = self.component("listbox")
        self._listbox.bind("<3>", self._select_under_mouse, "+")
        self._rmenu = self._build_rmenu(rmenu_spec)
        pass
    
    def _build_rmenu(self, rmenu_spec):
        return PopupMenu(self._listbox, rmenu_spec, self._rmenu_font)

    def _select_under_mouse(self, event):
        self._listbox.select_clear(0,Tk.END)
        self.select_set(self._listbox.nearest(event.y))
        pass
    
    pass


# gAƁB

class ToolBar(Tk.Frame):
    def __init__(self, parent=None):
        Tk.Frame.__init__(self, parent)
        self.config(relief=Tk.GROOVE, border=2)
        self._create_buttons()

    def pack(self, **kw):
        Tk.Frame.pack(self, kw)
        #self._pack_buttons()

    def _create_buttons(self):
        self._buttons = []
        import icon
        b = Button(self, image=icon.copy, command=lambda:self.do("copy"))
        b.pack(side=Tk.LEFT)
        self._buttons.append(b)


class Button(Tk.Button):
    def __init__(self, parent=None, **kw):
        Tk.Button.__init__(self, parent, kw)
        self.config(border=1, relief=Tk.FLAT)
        self.bind("<Enter>", self._rise)
        self.bind("<Leave>", self._flatten)

    def _rise(self, event):
        self.config(relief=Tk.RAISED)

    def _flatten(self, evetnt):
        self.config(relief=Tk.FLAT)


# EOF
