"""Provides Observer pattern components."""

class Observable(object):
    def __init__(self):
        self._observers = []

    def subscribe(self, observer):
        self._observers.append(observer)

    def unsubscribe(self, unsubscriber):
        while unsubscriber in self._observers:
            index = self._observers.index(unsubscriber)
            del self._observers[index]

    def notify(self):
        for subscriber in self._observers:
            subscriber.update(self)

    def attach(self, observer):
        self.subscribe(observer)

    def detach(self, observer):
        self.unsubscribe(observer)


class Observer(object):
    def update(self, subject):
        pass

    pass


# EOF
