"""Defines post dialog"""

import Tkinter as Tk
import config
import kittytk as ktk
import bbs
import observer
import font
from util import *

class PostDialog(Tk.Toplevel, observer.Observer):
    def __init__(self, parent, thread):
        """Constructor.

        This method stores the given thread and create widgets.
        """
        Tk.Toplevel.__init__(self)
        self.thread = thread
        self.make_widgets()
        self.focus_force()
        self.poster = bbs.Poster()
        self.transient(parent)
        self.withdraw()

    def make_widgets(self):
        entryfont = config.get("Font","Entry")
        labelfont = config.get("Font","UI")
        # Name entry.
        self.name_entry = ktk.EntryField(self,
                                         label = unicode("O","sjis"),
                                         entrywidth = 16,
                                         labelfont = labelfont,
                                         entryfont = entryfont)
        self.name_entry.pack(side=Tk.TOP, anchor=Tk.W)
        # Mail entry.
        self.mail_entry = ktk.EntryField(self,
                                         label=unicode("[","sjis"),
                                         entrywidth=16,
                                         labelfont=labelfont,
                                         entryfont=entryfont)
        self.mail_entry.pack(side=Tk.TOP, anchor=Tk.W)
        # Message area.
        self.message_text = Tk.Text(self,
                                    font=entryfont,
                                    width=64,
                                    height=8,
                                    state=Tk.NORMAL)
        # Popup menu.
        text = self.message_text
        rmenu = ktk.PopupMenu(text,
                              [(j("؂"),
                                lambda: text.event_generate("<Control-x>")),
                               (j("Rs["),
                                lambda: text.event_generate("<Control-c>")),
                               (j("\t"),
                                lambda: text.event_generate("<Control-v>")),
                               (j("I͈͂"),
                                self._emphasize_selection)],
                              font.ui)
        self.message_text._rmenu = rmenu

        self.message_text.pack(side=Tk.TOP, fill=Tk.BOTH, expand=Tk.YES)
        # Buttons.
        f = Tk.Frame(self)
        self.submit_button = Tk.Button(f,
                                       text=unicode("","sjis"),
                                       command=self.post,
                                       font=labelfont)
        self.submit_button.pack(side=Tk.LEFT)
        self.cancel_button = Tk.Button(f,
                                      text=unicode("LZ","sjis"),
                                      command=self.cancel,
                                      font=labelfont)
        self.cancel_button.pack(side=Tk.LEFT)
        f.pack(side=Tk.TOP, anchor=Tk.E)
        # Response text.
        self.response_text = Tk.Text(self,
                                     font=entryfont,
                                     width=64,
                                     height=0,
                                     wrap="char")
        self.response_text.pack(side=Tk.TOP, fill=Tk.BOTH, expand=Tk.YES)
        pass

    def open(self):
        """Open dialog window."""
        self.deiconify()
        pass

    def post(self):
        """POST.

        If message has been already entered, invoke post method.
        """
        if self.message_text.get("0.0", Tk.END):
            self.poster.attach(self)
            self.poster.post(self.thread,
                             mail=self.mail_entry.get(),
                             name=self.name_entry.get(),
                             message=self.message_text.get("0.0", Tk.END))
            pass
        pass

    def cancel(self):
        """Destroy dialog window."""
        self.poster.detach(self)
        self.destroy()
        pass

    def update(self, subject):
        state = subject.get_state()
        self.response_text.config(height=10)
        self.response_text.delete("0.0", Tk.END)
        self.response_text.insert("0.0", state)
        self.response_text.see(Tk.END)
        # Activate button.
        if state[-6:] == "FAILED":
            self.submit_button.config(state=Tk.NORMAL)
        elif state[-2:] == "OK":
            self.submit_button.config(command=self.destroy,
                                      text=unicode("","sjis"))
        pass

    def _emphasize_selection(self):
        try:
            text_box = self.message_text
            string = text_box.get(Tk.SEL_FIRST, Tk.SEL_LAST)
            text_box.delete(Tk.SEL_FIRST, Tk.SEL_LAST)
            text_box.insert(Tk.CURRENT, " ".join(string))
        except Tk.TclError:
            pass
        pass

    pass

# EOF
