"""Utilities"""

import os.path
import re
import os
import gzip
import StringIO
import httplib
import threading

#
# Boolean const
#
try:
    True, False
except NameError:
    True = (1==1)
    False = not True


def open_necessary_file(filename, mode):
    """Return file object.  If the file with filename does not exist, 
    create it and return the file object.
    """
    dirname = os.path.dirname(filename)
    # Create directory if not exists.
    if not os.path.exists(dirname):
        os.makedirs(dirname)
    # Create file if not exists.
    if not os.path.exists(filename):
        open(filename,"w").close()
    # Return file object.
    return open(filename, mode)


def gunzip(string):
    """Uncompress the given string."""
    fin = gzip.GzipFile(fileobj=StringIO.StringIO(string))
    return fin.read()

def http_get(host, path, header={}, proxy=""):
    """Perform HTTP's GET method and return response"""
    # vNVw肳Ă΁AڑzXgvNVɁAURL pXɐڑ
    # zXgURL ړB
    if proxy:
        path = "http://%s%s" % (host, path)
        host = proxy
    conn = httplib.HTTPConnection(host)
    conn.request("GET", path, "", header)
    return conn.getresponse()

def http_post(host, path, params, headers, proxy=""):
    """HTTP T[o POST AResponse IuWFNgԂB"""
    # vNVw肳Ă΁AڑzXgvNVɁAURL pXɐڑ
    # zXgURL ړB
    if proxy:
        path = "http://%s%s" % (host, path)
        host = proxy
    conn = httplib.HTTPConnection(host)
    conn.request("POST", path, params, headers)
    response = conn.getresponse()
    return response

HTTPException = httplib.HTTPException

#
# Time string.
#
import time
import re
months = ["dummy", "Jan", "Feb", "Mar", "Apr","May","Jun",
              "Jul","Aug","Sep","Oct","Nov","Dec"]
weeks = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"]
time_re = re.compile("""(?P<weekday>\w{3}),\s
                           (?P<day>\d{1,2})\s
                           (?P<month>\w{3})\s
                           (?P<year>\d{4})\s
                           (?P<hour>\d{2}):
                           (?P<minute>\d{2}):
                           (?P<second>\d{2})\s
                           (?P<zone>\w{3})""", re.X)
def scantime(httptime):
    """HTTP wb_̎ 1970-01-01 ̌oߕbɕϊĕԂB"""
    match = time_re.match(httptime)
    if match:
        year = int(match.group("year"))
        month = months.index(match.group("month"))
        day = int(match.group("day"))
        hour = int(match.group("hour"))
        minute = int(match.group("minute"))
        second = int(match.group("second"))
        weekday = weeks.index(match.group("weekday"))
        return int(time.mktime((year, month, day, hour, minute, second,
                                weekday, 0, 0)))
    else:
        return None

#
# Log
#
_logfile = open_necessary_file(os.path.expanduser("~/.kittywalk/log"),"w")
def log(text):
    """Write text on log file."""
    _logfile.write(text+"\n")
    _logfile.flush()


import thread
import threading
def run_thread(method, locked):
    locked = True
    t = threading.Thread(target=method)
    t.start()
    thread.start_new_thread(unlock_when_thread_die, (t,locked))

def unlock_when_thread_die(thread, locked):
    while thread.isAlive():
        time.sleep(0.1)
    locked = False

def j(string):
    return unicode(string, "sjis", "replace")

# EOF

