"""KittyWalk log recorder module"""

import sys
import time

import config


_debug_mode = False

def log(string):
    """Record string in log file"""
    message = "[%s] %s\n" % (time.asctime(), string)
    fout = file(config.LOGPATH, "a")
    fout.write(message)
    fout.close()
    if _debug_mode:
        sys.stderr.write(message)

def set_debug_mode():
    """Set logger to run in debug mode

    This make log() output on stderr too
    """
    global _debug_mode
    _debug_mode = True

def clear():
    file(config.LOGPATH,"w").close()

