from utils import *

class Message(object):
    """Message content

    This is a container for a message and all attributes are public.
    """

    def __init__(self, index, name="", mail="", time="", body=""):
        assert isinstance(index, int)
        assert isinstance(name, (str,unicode))
        assert isinstance(mail, (str,unicode))
        assert isinstance(time, (str,unicode))
        assert isinstance(body, (str,unicode))
        self.index = index
        self.name = j(name)
        self.mail = j(mail)
        self.time = j(time)
        self.body = j(body)

    def __eq__(self, other):
        return ((self.name==other.name) and
                (self.mail==other.mail) and
                (self.time==other.time) and
                (self.body==other.body))
