"""Configuration

This module defines some constants.

This module also provides get() and set() methods to access the
configuration file.  The content of configuration file is repr()
result of a dictionary.
"""

import sys
import os


KITTYWALKDIR = os.path.abspath(sys.path[0])
LOGPATH = os.path.join(KITTYWALKDIR, "log")
RCDIR = os.path.join(os.environ.get("HOME", KITTYWALKDIR), ".kittywalk")
CACHEDIR = os.path.join(RCDIR, "cache")
_config_file_path = os.path.join(RCDIR, "conf")


def get(key, default=None):
    """Return configuration value associated with key"""
    data = _read_data()
    return data.get(key, default)

def set(key, value):
    """Save value associated with key"""
    data = _read_data()
    data.update({key:value})
    _write_data(data)

def _read_data():
    """Return saved dictionary"""
    try:
        return eval(file(_config_file_path).read())
    except:
        return {}

def _write_data(data):
    """Wrtie data dictionary"""
    file(_config_file_path,"w").write(repr(data))

