"""Installer

This module provides very simple installation utilities, for the first 
boot.  You don't have to use this module explicitly, but you may.

"""

import sys
import os
import shutil

import config
import Logger


def is_required():
    """Return whether installation is required

    This function returns True if board list file is not found, False 
    otherwise.
    """
    return not os.path.exists(os.path.join(config.CACHEDIR,"boardtree.xml"))

def execute():
    Logger.log("Installation started.")
    execpath = os.path.abspath(sys.path[0])
    copytree(os.path.join(execpath, "default.kittywalk"),
             config.RCDIR)
    Logger.log("Installation finished.")

def copytree(src, dst):
    """Copy directory tree src to dst

    src and dst must be directory names.
    """
    if not os.path.exists(dst):
        os.mkdir(dst)
    for name in os.listdir(src):
        srcpath = os.path.join(src, name)
        dstpath = os.path.join(dst, name)
        if os.path.isfile(srcpath):
            shutil.copy2(srcpath, dstpath)
        elif os.path.isdir(srcpath):
            copytree(srcpath, dstpath)


if __name__ == "__main__":
    execute()

