"""Renderer"""

import sys
from bbs import Topic
from utils import *

class Renderer(object):
    def render(self, topic, start=0, end=None):

        """Render messages in given topic and return as a single string

        This method iterates over every message in topic to render it as 
        a HTML portion, concates all messages into a single string, adds 
        and return the 
        string.
        """
        assert isinstance(topic, Topic)
        if not end:
            end = topic.local_size()
        return "".join(self._header(topic) +
                       self._body(topic)[start:end] +
                       self._footer())

    def _header(self, topic):
        return  ["<html><head><title>%s</title></head><body><dl>"%topic.title()]

    def _body(self, topic):
        return [self._message_division(m) for m in topic.messages()]
    
    def _footer(self):
        return ["""</dl></body></html>"""]

    def _message_division(self, message):
        m = message
        body = _render_body(m.body)
        return """<dt><a name="%d">%d</a>: %s [%s] %s</dt><dd>%s<br/></dd>"""\
          % (m.index,
             m.index,
             m.name,
             m.mail,
             m.time,
             body)

import re
def _render_body(text):
    for func in [_strip_link, _space, _wide_space, _ref]:
        text = func(text)
    return text

def _strip_link(text):
    return re.sub(u"</?a\s*.*?>", u"", text)

def _space(text):
    return text.replace(u" ", u"&nbsp;")

def _wide_space(text):
    return text.replace(u("　"), "&#12288;")

def _ref(text):
    return re.sub(u"&gt;&gt;(?P<num>\d+)",
                  lambda m: u'<a href="#%s">%s</a>'%(m.group("num"),m.group()),
                  text)

if __name__ == "__main__":
    # Test
    r = Renderer()
    t = Topic("pc2.2ch.net", "tech", "1036811974")
    print r.render(t).encode("ms932","ignore")
