/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ======================================================================== */
/* [movabletext] */

/* @method void Class.%s(OutputStream w, String m) */

void knh_Class__s(Ctx *ctx, Class *o, OutputStream *w, String *m)
{
	knh_write__class(ctx, w, o->cid);
}

/* ------------------------------------------------------------------------ */
/* @method void Class.%k(OutputStream w, String m) */

void knh_Class__k(Ctx *ctx, Class *o, OutputStream *w, String *m)
{
	knh_write__type(ctx, w, o->type);
}

/* ------------------------------------------------------------------------ */
/* @method void Class.%dump(OutputStream w, String m) */

void knh_Class__dump(Ctx *ctx, Class *o, OutputStream *w, String *m)
{
	TODO_THROW(ctx);
}

/* ------------------------------------------------------------------------ */

static
char *knh_methodop_tochar(knh_methodn_t mn)
{
	switch(mn) {
	case METHODN_opNot: return "!x";
	case METHODN_opInstanceof: return "x instanceof T";
	case METHODN_opAs:  return "x as T";

	case METHODN_opHas:  return "y in? x";
	case METHODN_opIsa: return "x isa? y";
	case METHODN_opIs:  return "x is? y";
	case METHODN_opTo:  return "x to? y";

	case METHODN_opEq:  return "x == y";
	case METHODN_opNeq:  return "x != x";
	case METHODN_opLt:  return "x < y";
	case METHODN_opLte:  return "x <= y";
	case METHODN_opGt:  return "x > y";
	case METHODN_opGte:  return "x >= y";

	case METHODN_opLshift:  return "x << y";
	case METHODN_opRshift:  return "x >> y";

	case METHODN_opMod:  return "x mod y";

#ifdef METHODN_opAdd__2
	case METHODN_opAdd__2 :
#endif
	case METHODN_opAdd:  return "x + y";

#ifdef METHODN_opSub__2
	case METHODN_opSub__2 :
#endif
	case METHODN_opNeg: return "-x";

	case METHODN_opSub:  return "x - y";

#ifdef METHODN_opDiv__2
	case METHODN_opDiv__2 :
#endif
	case METHODN_opDiv:  return "x / y";

#ifdef METHODN_opMul__2
	case METHODN_opMul__2 :
#endif
	case METHODN_opMul:  return "x * y";

	case METHODN_opLor:  return "x & y";
	case METHODN_opLand:  return "x | y";
	case METHODN_opLnot:  return "~x";
	case METHODN_opXor:  return "x ^ y";
	case METHODN_opNext:  return "x++";
	case METHODN_opPrev:  return "x--";
	case METHODN_opItr:   return "x..";
	case METHODN_getSize: return "|x|";
	case METHODN_get: return "x[n]";
	case METHODN_set: return "x[n]=y";
	case METHODN_setAll: return "x[]=y";
	case METHODN_opSubsete: return "x[m..n]";
	case METHODN_opOffset: return "x[m..+n]";
	case METHODN_opSubset: return "x[m..<n]";
	}
	return NULL;
}

/* ------------------------------------------------------------------------ */

static
void knh_Class_NAME__man(Ctx *ctx, knh_class_t cid, OutputStream *w)
{
	knh_write__s(ctx, w, knh_message_text(KMSG_CLASS));
	knh_write_EOL(ctx, w);

	knh_write_TAB(ctx, w);
	knh_write(ctx, w, knh_String_tobytes(knh_tClass[cid].lname));
	knh_write_EOL(ctx, w);

	while(knh_tClass[cid].supcid != CLASS_Object) {
		cid = knh_tClass[cid].supcid;
		knh_write_TAB(ctx, w);
		knh_write(ctx, w, STEXT("extends "));
		knh_write(ctx, w, knh_String_tobytes(knh_tClass[cid].lname));
		knh_write_EOL(ctx, w);
	}
}

/* ------------------------------------------------------------------------ */

static
void knh_Method__man(Ctx *ctx, Method *o, OutputStream *w, knh_class_t cid)
{
	if(knh_Method_isAbstract(o)) {
		knh_write(ctx, w, STEXT("@abstract"));
		knh_putc(ctx, w, ' ');
	}

	if(knh_Method_rtype(o) == TYPE_void) {
		knh_write(ctx, w, knh_String_tobytes(TS_void));
	}else{
		knh_write__type(ctx, w, knh_pmztype_totype(ctx, knh_Method_rtype(o), cid));
	}
	knh_putc(ctx, w, ' ');

	if(knh_Method_isStatic(o)) {
		knh_write__s(ctx, w, CTXCLASSN(cid));
		knh_putc(ctx, w, '.');
	}
	knh_write__mn(ctx, w, DP(o)->mn);

	knh_putc(ctx, w, '(');
	size_t i;
	for(i = 0; i < knh_Method_psize(o); i++) {
		if(i > 0) {
			knh_write_delim(ctx, w);
		}
		knh_mfield_t mf = knh_Method_pfields(o, i);
		knh_write__type(ctx, w, knh_pmztype_totype(ctx, mf.type, cid));
		knh_putc(ctx, w, ' ');
		knh_write(ctx, w, B(FIELDN(mf.fn)));
	}
	if(knh_Method_isVarArgs(o)) {
		knh_write_delim(ctx, w);
		knh_write_dots(ctx, w);
	}
	knh_putc(ctx, w, ')');
}

/* ------------------------------------------------------------------------ */
/* @method void Class.%man(OutputStream w, String m) */

void knh_Class__man(Ctx *ctx, Class *o, OutputStream *w, String *m)
{
	knh_class_t cid = (o)->cid;
	knh_Class_NAME__man(ctx, cid, w);
	knh_tConst__man(ctx, cid, w);

	char bufmn[CLASSNAME_BUFSIZ];
	DEBUG_ASSERT_cid(cid);
	KNH_LOPEN(ctx, 0);
	DictMap *dm = new_DictMap0(ctx, 128);
	KNH_LPUSH(ctx, dm);
	size_t i = 0;
	while(1) {
		Array *a = DP(knh_tClass[cid].cstruct)->methods;
		for(i = 0; i < knh_Array_size(a); i++) {
			Method *mtd = (Method*)knh_Array_n(a, i);
			char *op = knh_methodop_tochar(DP(mtd)->mn);
			if(op == NULL) {
				knh_format_methodn(bufmn, sizeof(bufmn), DP(mtd)->mn);
				//DBG2_P("mn='%s'", bufmn);
				knh_bytes_t name = B(bufmn);
				if(IS_NULL(knh_DictMap_get__b( dm, name))) {
					knh_DictMap_set(ctx, dm, new_String(ctx, name, NULL), UP(mtd));
				}
			}
			else {
				knh_bytes_t name = B(op);
				if(IS_NULL(knh_DictMap_get__b( dm, name))) {
					knh_DictMap_set(ctx, dm, new_String__T(ctx, op), UP(mtd));
				}
			}
		}
		if(cid == CLASS_Object) break;
		cid = knh_tClass[cid].supcid;
	}

	int cnt = 0;
	cid = (o)->cid;

	int hasCaption = 0;
	int isBOL = 1;
	for(i = 0; i < knh_DictMap_size(dm); i++) {
		Method *mtd = (Method*)knh_DictMap_valueAt(dm, i);
		if(IS_Method(mtd)) {
			char *op = knh_methodop_tochar(DP(mtd)->mn);
			if(op == NULL) continue;
			knh_DictMap_removeAt(ctx, dm, i);
			if(DP(mtd)->cid == CLASS_Object && cid != CLASS_Object) continue;
			if(hasCaption == 0) {
				knh_write__s(ctx, w, knh_message_text(KMSG_OPERATOR));
				knh_write_EOL(ctx, w);
				hasCaption = 1;
			}
			if(isBOL == 1) {
				knh_write_TAB(ctx, w);
				isBOL = 0;
			}
			knh_snprintf(bufmn, sizeof(bufmn), "%10s  ", op);
			knh_write__s(ctx, w, bufmn);
			if(cnt % 5 == 4) {
				knh_write_EOL(ctx, w);
				isBOL = 1;
			}
			cnt++;
		}
	}
	if(isBOL != 1) {
		knh_write_EOL(ctx, w);
	}

	hasCaption = 0;
	isBOL = 1;
	knh_DictMap_sort(dm);

	for(i = 0; i < knh_DictMap_size(dm); i++) {
		Method *mtd = (Method*)knh_DictMap_valueAt(dm, i);
		if(IS_Method(mtd)) {
			if(METHODN_IS_MOVTEXT(DP(mtd)->mn)) continue;
			if(DP(mtd)->cid == CLASS_Object && cid != CLASS_Object) continue;
//			if(DP(mtd)->cid != knh_tClass[cid].bcid) continue;
			if(hasCaption == 0) {
				knh_write__s(ctx, w, knh_message_text(KMSG_METHOD));
				knh_write_EOL(ctx, w);
				hasCaption = 1;
			}
			knh_write_TAB(ctx, w);
			knh_Method__man(ctx, mtd, w, cid);
			knh_write_EOL(ctx, w);
			knh_DictMap_removeAt(ctx, dm, i);
		}
	}

	hasCaption = 0;
	cnt = 8;
	for(i = 0; i < knh_DictMap_size(dm); i++) {
		Method *mtd = (Method*)knh_DictMap_valueAt(dm, i);
		if(IS_Method(mtd)) {
			if(!METHODN_IS_MOVTEXT(DP(mtd)->mn)) continue;
			if(DP(mtd)->cid == CLASS_Object && cid != CLASS_Object) continue;
			if(hasCaption == 0) {
				knh_write__s(ctx, w, knh_message_text(KMSG_FORMATTER));
				knh_write_EOL(ctx, w);
				knh_write_TAB(ctx, w);
				hasCaption = 1;
			}
			knh_bytes_t k = knh_String_tobytes(knh_DictMap_keyAt(dm, i));
			if(cnt + k.len > 72) {
				knh_write_EOL(ctx, w);
				knh_write_TAB(ctx, w);
				cnt = 8;
			}
			knh_write(ctx, w, k); knh_putc(ctx, w, ' ');
			cnt += (k.len + 1);
		}
	}
	knh_write_EOL(ctx, w);

	knh_ClassMap__man(ctx, knh_tClass[cid].cmap, w, cid);
	KNH_LCLOSE(ctx);
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
