/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

#ifdef KNH_USING_MATH
#include<math.h>
#endif

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method[CONST] Float! Float.opAdd(Float! v) */

METHOD knh__Float_opAdd(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, ARG_float(sfp[0]) + ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Float! Float.opNeg() */

METHOD knh__Float_opNeg(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, -(ARG_float(sfp[0])));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Float! Float.opSub(Float! n) */

METHOD knh__Float_opSub(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, ARG_float(sfp[0]) - ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Float! Float.opMul(Float! n) */

METHOD knh__Float_opMul(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, ARG_float(sfp[0]) * ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Float! Float.opDiv(Float! n) */

METHOD knh__Float_opDiv(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, ARG_float(sfp[0]) / ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST|NULLBASE] Boolean! Float.opEq(Float value) */

METHOD knh__Float_opEq(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_float(sfp[0]) == ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST|NULLBASE] Boolean! Float.opNeq(Float value) */

METHOD knh__Float_opNeq(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_float(sfp[0]) != ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Boolean! Float.opLt(Float! value) */

METHOD knh__Float_opLt(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_float(sfp[0]) < ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Boolean! Float.opLte(Float! value) */

METHOD knh__Float_opLte(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_float(sfp[0]) <= ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Boolean! Float.opGt(Float! value) */

METHOD knh__Float_opGt(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_float(sfp[0]) > ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Boolean! Float.opGte(Float! value) */

METHOD knh__Float_opGte(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_float(sfp[0]) >= ARG_float(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Float! Float.opNext() */

METHOD knh__Float_opNext(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, (ARG_float(sfp[0]))+1.0);
}

/* ------------------------------------------------------------------------ */

/* @method[CONST] Float! Float.opPrev() */

METHOD knh__Float_opPrev(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, (ARG_float(sfp[0]))-1.0);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Float Float.random()  */

METHOD knh__Float_random(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, knh_float_rand());
}

/* ------------------------------------------------------------------------ */
/* @method[NULLBASE|CONST] Int! Float.getSize() */

METHOD knh__Float_getSize(Ctx *ctx, knh_sfp_t *sfp)
{
	if(IS_NULL(sfp[0].o)) {
		KNH_RETURN_Int(ctx, sfp, 0);
	}
	else {
		knh_uinteger_t n = (knh_uinteger_t)ARG_float(sfp[0]);
		KNH_RETURN_Int(ctx, sfp, n);
	}
}

/* ======================================================================== */
/* [mapping] */

/* @map[CONST] String Float @Final */

Float* knh_String_Float(Ctx *ctx, String *s, Mapper *mpr)
{
	return new_FloatX__b(ctx, DP(mpr)->tcid, knh_String_tobytes(s));
}

/* ------------------------------------------------------------------------ */
/* @map Float String! @Const @Final */

String* knh_Float_String(Ctx *ctx, Float *o, Mapper *mpr)
{
	char buf[BUFSIZ_FLOAT];
	knh_format_Float(buf, sizeof(buf), o);
	return new_String(ctx, B(buf), NULL);
}

/* ------------------------------------------------------------------------ */
/* @map Int Float! @Const @Final */

Float* knh_Int_Float(Ctx *ctx, Int *o, Mapper *mpr)
{
	return new_FloatX(ctx, DP(mpr)->tcid, (knh_float_t)(o)->value);
}

/* ------------------------------------------------------------------------ */
/* @map Float Int! @Const @Final */

Int* knh_Float_Int(Ctx *ctx, Float *o, Mapper *mpr)
{
	return new_IntX(ctx, DP(mpr)->tcid, (knh_integer_t)(o)->value);
}

/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void Float.%s(OutputStream w, String m) */

void knh_Float__s(Ctx *ctx, Float *o, OutputStream *w, String *m)
{
	knh_write__ffmt(ctx, w, KNH_FLOAT_FMT, o->value);
}

/* ------------------------------------------------------------------------ */
/* @method void Float.%d(OutputStream w, String m) */

void knh_Float__d(Ctx *ctx, Float *o, OutputStream *w, String *m)
{
	if(IS_String(m)) {
		char fmt[40];
		knh_format_newFMT(fmt, sizeof(fmt), knh_String_tobytes(m), 0, KNH_INTEGER_FMT);
		//DBG_P("fmt='%s'", fmt);
		knh_write_integerfmt(ctx, w, fmt, (o)->value);
	}
	else {
		knh_write_integerfmt(ctx, w, KNH_INTEGER_FMT, (o)->value);
	}
}

/* ------------------------------------------------------------------------ */
/* @method void Float.%f(OutputStream w, String m) */

void knh_Float__f(Ctx *ctx, Float *o, OutputStream *w, String *m)
{
	if(IS_String(m)) {
		char fmt[40];
		knh_format_newFMT(fmt, sizeof(fmt), knh_String_tobytes(m), 1, KNH_FLOAT_FMT);
		//DBG_P("fmt='%s'", fmt);
		knh_write__ffmt(ctx, w, fmt, (knh_float_t)(o)->value);
	}
	else {
		knh_write__ffmt(ctx, w, KNH_FLOAT_FMT, (knh_float_t)(o)->value);
	}
}

/* ------------------------------------------------------------------------ */
/* @method void Float.%k(OutputStream w, String m) */

void knh_Float__k(Ctx *ctx, Float *o, OutputStream *w, String *m)
{
	FloatUnit *u = (FloatUnit*)knh_tClass[o->h.cid].cspec;
	KNH_ASSERT(IS_FloatUnit(u));
	knh_write__ffmt(ctx, w, DP(u)->FMT, o->value);
}

/* ------------------------------------------------------------------------ */
/* @method void Float.%bits(OutputStream w, String m) */

void knh_Float__bits(Ctx *ctx, Float *o, OutputStream *w, String *m)
{
	if(sizeof(knh_float_t) == 8) {
		union {
			knh_uint64_t l;
			knh_float_t f;
		} u;
		u.f = o->value;;
		knh_write_bits(ctx, w, u.l, sizeof(knh_float_t) * 8);
	}
	else if (sizeof(knh_float_t) == 4){
		union {
			knh_int_t l;
			knh_float_t f;
		} u;
		u.f = o->value;;
		knh_write_bits(ctx, w, u.l, sizeof(knh_float_t) * 8);
	}
}

/* ------------------------------------------------------------------------ */
/* @method void Float.%dump(OutputStream w, String m) */

void knh_Float__dump(Ctx *ctx, Float *o, OutputStream *w, String *m)
{
	FloatUnit *u = (FloatUnit*)knh_tClass[o->h.cid].cspec;
	KNH_ASSERT(IS_FloatUnit(u));
	knh_write__ffmt(ctx, w, DP(u)->FMT, o->value);
	knh_bytes_t tag = knh_String_tobytes(DP(u)->spec.tag);
	if(tag.len > 0) {
		knh_putc(ctx, w, '[');
		knh_write(ctx, w, tag);
		knh_putc(ctx, w, ']');
	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
