/* ************************************************************************ */

#include<konoha.h>
#include<libmemcached/memcached.h>
#include<string.h>

#if (KONOHA_BUILDID <= 771)
#define knh_IntData_t knh_IntConstData_t
#define knh_loadIntConst knh_loadIntConstData
#endif


#ifdef __cplusplus
extern "C" {
#endif

#define MAX_STR 12

/* ======================================================================== */

static void knh_memcached_gfree(Ctx *ctx, knh_Glue_t *g)
{
	memcached_free((memcached_st*)g->ptr);
}

/* ------------------------------------------------------------------------ */
/* @method This! Memcached.new() */

METHOD Memcached_new(Ctx *ctx, knh_sfp_t *sfp)
{
  char* addr = String_to_(sfp[1]);
  int port = 11211;
  if(!IS_NULL(sfp[2].o)){
    port = p_int(sfp[2]);
  }
  memcached_return rc;
  memcached_st* memc = memcached_create(NULL);
  memcached_server_st* servers = memcached_server_list_append(NULL, addr, port, &rc);
  if(rc != MEMCACHED_SUCCESS){
    //to do exception handling
    KNH_THROW__T(ctx, memcached_strerror(memc, rc));
    //
  }
  else{
    rc = memcached_server_push(memc, servers);
  }
  if(rc != MEMCACHED_SUCCESS){
    //to do exception handling
    KNH_THROW__T(ctx, memcached_strerror(memc, rc));
    //
  }
  else{
    memcached_server_list_free(servers);
    memcached_behavior_set(memc, MEMCACHED_BEHAVIOR_KETAMA_WEIGHTED, 1);
    knh_Glue_init(ctx, sfp[0].glue, memc, knh_memcached_gfree);
    KNH_RETURN(ctx, sfp, sfp[0].o);
  }
}

/* ------------------------------------------------------------------------ */
/* @method boolean Memcached.set(String key, String val) */

METHOD Memcached_setValue(Ctx *ctx, knh_sfp_t *sfp)
{
	memcached_st* memc = (memcached_st*)p_cptr(sfp[0]);
	char* key = String_to_(sfp[1]);
	char* val = String_to_(sfp[2]);
	memcached_return rc;
	rc = memcached_set(memc, key, strlen(key), val, strlen(val), (time_t)600, (uint32_t)0);
	if(rc != MEMCACHED_SUCCESS && rc != MEMCACHED_BUFFERED){
	  
	  //to do exception handling
	  //KNH_RETURN_Boolean(ctx, sfp, 0);
	  KNH_THROW__T(ctx, memcached_strerror(memc, rc));
	}
	else{
	  KNH_RETURN_Boolean(ctx, sfp, 1);
	}
}

/* ------------------------------------------------------------------------ */
/* @method String Memcached.get(String key) */

METHOD Memcached_getValue(Ctx *ctx, knh_sfp_t *sfp)
{
  memcached_st* memc = (memcached_st*)p_cptr(sfp[0]);
  char* key = String_to_(sfp[1]);
  char* val;
  size_t val_length;
  memcached_return rc;
  uint32_t flags;
  val = memcached_get(memc, key, strlen(key), &val_length, &flags, &rc);
  if(rc != MEMCACHED_SUCCESS){
    //to do exception handling
    //KNH_RETURN_Boolean(ctx, sfp, 0);
    //printf("%d 1",rc);
    KNH_THROW__T(ctx, memcached_strerror(memc, rc));
    //val = "";
  }
  else{
    KNH_RETURN(ctx, sfp, new_String(ctx,B(val),NULL));
    //printf("%d -1",rc);
  }  
}

/* ------------------------------------------------------------------------ */
/* @method boolean Memcached.addValue(String key, String val) */

METHOD Memcached_addValue(Ctx *ctx, knh_sfp_t *sfp)
{
  memcached_st* memc = (memcached_st*)p_cptr(sfp[0]);
  char* key = String_to_(sfp[1]);
  char* val = String_to_(sfp[2]);
  memcached_return rc;
  rc = memcached_add(memc, key, strlen(key), val, strlen(val), (time_t)600, (uint32_t)0);
  if(rc != MEMCACHED_SUCCESS && rc != MEMCACHED_STORED && rc != MEMCACHED_NOTSTORED){
    //to do exception handling
    //KNH_RETURN_Boolean(ctx, sfp, 0);
    KNH_THROW__T(ctx, memcached_strerror(memc, rc));
  }
  else if(rc == MEMCACHED_SUCCESS){
    KNH_RETURN_Boolean(ctx, sfp, 1);
  }
  else{
    printf("%s\n",memcached_strerror(memc, rc));
    KNH_RETURN_Boolean(ctx, sfp, 0);
  }
}

/* ------------------------------------------------------------------------ */
/* @method boolean Memcached.delete(String key) */
METHOD Memcached_delete(Ctx *ctx, knh_sfp_t *sfp)
{
  memcached_st* memc = (memcached_st*)p_cptr(sfp[0]);
  char* key = String_to_(sfp[1]);
  memcached_return rc;
  rc = memcached_delete(memc, key, strlen(key), (time_t)0);
  if(rc != MEMCACHED_SUCCESS && rc != MEMCACHED_BUFFERED){
    //to do exception handling
    //KNH_RETURN_Boolean(ctx, sfp, 0);
    //printf("%d 1",rc);
    KNH_THROW__T(ctx, memcached_strerror(memc, rc));
    //val = "";
  }
  else{
    KNH_RETURN_Boolean(ctx, sfp, 1);
    //printf("%d -1",rc);
  }  
}


/* ------------------------------------------------------------------------ */
/* @method boolean Memcached.addServer(String addr, Int? port) */
METHOD Memcached_addServer(Ctx *ctx, knh_sfp_t *sfp)
{
  memcached_st* memc = (memcached_st*)p_cptr(sfp[0]);
  char* addr = String_to_(sfp[1]);
  int port = 11211;
  if(!IS_NULL(sfp[2].o)){
    port = p_int(sfp[2]);
  }
  memcached_return rc;
  memcached_server_st* servers = memcached_server_list_append(NULL, addr, port, &rc);
  if(rc != MEMCACHED_SUCCESS){
    //to do exception handling
    KNH_THROW__T(ctx, memcached_strerror(memc, rc));
    //
  }
  else{
    rc = memcached_server_push(memc, servers);
  }
  if(rc != MEMCACHED_SUCCESS){
    //to do exception handling
    KNH_THROW__T(ctx, memcached_strerror(memc, rc));
    //
  }
  else{
    memcached_server_list_free(servers);
    KNH_RETURN_Boolean(ctx, sfp, 1);
  }
}



/* ======================================================================== */
/* [ConstData] */

static
knh_IntData_t IntConstData[] = {
	{"Memcached.DEFAULT_PORT", MEMCACHED_DEFAULT_PORT},
	{"Memcached.MAX_KEY", MEMCACHED_MAX_KEY},
	{"Memcached.MAX_BUFFER", MEMCACHED_MAX_BUFFER},
	{"Memcached.MAX_HOST_SORT_LENGTH", MEMCACHED_MAX_HOST_SORT_LENGTH},
	{"Memcached.POINTS_PER_SERVER", MEMCACHED_POINTS_PER_SERVER},
	{"Memcached.POINTS_PER_SERVER_KETAMA", MEMCACHED_POINTS_PER_SERVER_KETAMA},
	{"Memcached.CONTINUUM_SIZE", MEMCACHED_CONTINUUM_SIZE},
	{"Memcached.STRIDE", MEMCACHED_STRIDE},
	{"Memcached.DEFAULT_TIMEOUT", MEMCACHED_DEFAULT_TIMEOUT},
	{"Memcached.CONTINUUM_ADDITION", MEMCACHED_CONTINUUM_ADDITION},
	{"Memcached.PREFIX_KEY_MAX_SIZE", MEMCACHED_PREFIX_KEY_MAX_SIZE},
	{"Memcached.EXPIRATION_NOT_ADD", MEMCACHED_EXPIRATION_NOT_ADD},
	
	{"Memcached.VERSION_STRING_LENGTH", MEMCACHED_CONTINUUM_SIZE},
	{"Memcached.SUCCESS", MEMCACHED_SUCCESS},
	{"Memcached.FAILURE", MEMCACHED_FAILURE},
	{"Memcached.HOST_LOOKUP_FAILURE", MEMCACHED_HOST_LOOKUP_FAILURE},
	{"Memcached.CONNECTION_FAILURE", MEMCACHED_CONNECTION_FAILURE},
	{"Memcached.CONNECTION_BIND_FAILURE", MEMCACHED_CONNECTION_BIND_FAILURE},
	{"Memcached.WRITE_FAILURE", MEMCACHED_WRITE_FAILURE},
	{"Memcached.READ_FAILURE", MEMCACHED_READ_FAILURE},
	{"Memcached.UNKNOWN_READ_FAILURE", MEMCACHED_UNKNOWN_READ_FAILURE},
	{"Memcached.PROTOCOL_ERROR", MEMCACHED_PROTOCOL_ERROR},
	{"Memcached.CLIENT_ERROR", MEMCACHED_CLIENT_ERROR},
	{"Memcached.SERVER_ERROR", MEMCACHED_SERVER_ERROR},
	{"Memcached.CONNECTION_SOCKET_CREATE_FAILURE", MEMCACHED_CONNECTION_SOCKET_CREATE_FAILURE},
	{"Memcached.DATA_EXISTS", MEMCACHED_DATA_EXISTS},
	{"Memcached.DATA_DOES_NOT_EXIST", MEMCACHED_DATA_DOES_NOT_EXIST},
	{"Memcached.NOTSTORED", MEMCACHED_NOTSTORED},
	{"Memcached.STORED", MEMCACHED_STORED},
	{"Memcached.NOTFOUND", MEMCACHED_NOTFOUND},
	{"Memcached.MEMORY_ALLOCATION_FAILURE", MEMCACHED_MEMORY_ALLOCATION_FAILURE},
	{"Memcached.PARTIAL_READ", MEMCACHED_PARTIAL_READ},
	{"Memcached.SOME_ERRORS", MEMCACHED_SOME_ERRORS},
	{"Memcached.NO_SERVERS", MEMCACHED_NO_SERVERS},
	{"Memcached.END", MEMCACHED_END},
	{"Memcached.DELETED", MEMCACHED_DELETED},
	{"Memcached.VALUE", MEMCACHED_VALUE},
	{"Memcached.STAT", MEMCACHED_STAT},
	{"Memcached.ITEM", MEMCACHED_ITEM},
	{"Memcached.ERRNO", MEMCACHED_ERRNO},
	{"Memcached.FAIL_UNIX_SOCKET", MEMCACHED_FAIL_UNIX_SOCKET},
	{"Memcached.NOT_SUPPORTED", MEMCACHED_NOT_SUPPORTED},
	{"Memcached.NO_KEY_PROVIDED", MEMCACHED_NO_KEY_PROVIDED},
	{"Memcached.FETCH_NOTFINISHED", MEMCACHED_FETCH_NOTFINISHED},
	{"Memcached.TIMEOUT", MEMCACHED_TIMEOUT},
	{"Memcached.BUFFERED", MEMCACHED_BUFFERED},
	{"Memcached.BAD_KEY_PROVIDED", MEMCACHED_BAD_KEY_PROVIDED},
	{"Memcached.INVALID_HOST_PROTOCOL", MEMCACHED_INVALID_HOST_PROTOCOL},
	{"Memcached.SERVER_MARKED_DEAD", MEMCACHED_SERVER_MARKED_DEAD},
	{"Memcached.UNKNOWN_STAT_KEY", MEMCACHED_UNKNOWN_STAT_KEY},
	//{"Memcached.E2BIG", MEMCACHED_E2BIG},
	//{"Memcached.INVALID_ARGUMENTS", MEMCACHED_INVALID_ARGUMENTS},
	//{"Memcached.KEY_TOO_BIG", MEMCACHED_KEY_TOO_BIG},
	//{"Memcached.AUTH_PROBLEM", MEMCACHED_AUTH_PROBLEM},
	//{"Memcached.AUTH_FAILURE", MEMCACHED_AUTH_FAILURE},
	//{"Memcached.AUTH_CONTINUE", MEMCACHED_AUTH_CONTINUE},
	{"Memcached.MAXIMUM_RETURN", MEMCACHED_MAXIMUM_RETURN},

	/*
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	{"Memcached.", MEMCACHED_},
	*/

	//...
	{NULL}  // end of const data
};

/* ------------------------------------------------------------------------ */

KNH_EXPORTS(int) init(Ctx *ctx)
{
	KNH_NOTICE(ctx, "loading libmemcached..");
	knh_loadIntConstData(ctx, IntConstData);

	return 1;
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

