#include "common.h"
#include "buffsize.h"
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include "ipc.h"

/***************************************************************
 *
 * Declaration
 *
 ***************************************************************/
extern void sendQuery(const char query[], const int sockfd);
extern TYPE_OF_ANSWER recvTypeOfAnswer(const int sockfd);
extern ANSWER recvAnswer(const int sockfd);
extern void printResultForRelation(ANSWER answer);
extern void printResultForSchema(const int sockfd);
extern void printResultOfOperation(const TYPE_OF_ANSWER typeOfAnswer);
extern int connectKraftByClient(void);
extern int connectKraftBySensor(void);
extern void sendExitAndCloseSockfd(const int sockfd);

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static void
getResultOfAdhocQuery(const int sockfd)
{
  TYPE_OF_ANSWER typeOfAnswer;
  ANSWER answer;

  typeOfAnswer = recvTypeOfAnswer(sockfd);
  switch (typeOfAnswer) {

  case ANSWER_RELATION:    
    answer = recvAnswer(sockfd);
    printResultForRelation(answer); 
    break;

  case ANSWER_SHOW_MONITOR: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_WINDOW: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_SCHEMA:  
    printResultForSchema(sockfd);   
    break;

  default:
    printResultOfOperation(typeOfAnswer);            
    break;
  }
}

static void
issueAppend(const int nbQuery)
{
  int kraftfd, i;
  char query[QUERY_BUFFSIZE];

  kraftfd = connectKraftBySensor();
  for (i = 0; i < nbQuery; i++) {
    bzero(query, QUERY_BUFFSIZE);
    sprintf(query, "append into monitor_table.s values (%d) where id = 0", rand() % 100);
    //S(query);
    sendQuery(query, kraftfd);
    getResultOfAdhocQuery(kraftfd);
    usleep(100 * 1000);
  }
  sendExitAndCloseSockfd(kraftfd);

  exit(0);
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int 
main(const int argc, char *argv[])
{
  int nbQuery;

  if (argc != 2) {
    printf("Usage: program nbquery\n");
    exit(1);
  }
  nbQuery = atoi(argv[1]);
  issueAppend(nbQuery);
    
  return 0;
}
