#include "common.h"
#include "buffsize.h"
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include "ipc.h"

typedef enum {INSERT, APPEND} TYPE;

/***************************************************************
 *
 * Declaration
 *
 ***************************************************************/
extern void sendQuery(const char query[], const int sockfd);
extern TYPE_OF_ANSWER recvTypeOfAnswer(const int sockfd);
extern ANSWER recvAnswer(const int sockfd);
extern void printResultForRelation(ANSWER answer);
extern void printResultForSchema(const int sockfd);
extern void printResultOfOperation(const TYPE_OF_ANSWER typeOfAnswer);
extern int connectKraftByClient(void);
extern int connectKraftBySensor(void);
extern void sendExitAndCloseSockfd(const int sockfd);

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static void
getResultOfAdhocQuery(const int sockfd)
{
  TYPE_OF_ANSWER typeOfAnswer;
  ANSWER answer;

  typeOfAnswer = recvTypeOfAnswer(sockfd);
  switch (typeOfAnswer) {

  case ANSWER_RELATION:    
    answer = recvAnswer(sockfd);
    printResultForRelation(answer); 
    break;

  case ANSWER_SHOW_MONITOR: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_WINDOW: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_SCHEMA:  
    printResultForSchema(sockfd);   
    break;

  default:
    printResultOfOperation(typeOfAnswer);            
    break;
  }
}

static void
issueAppend(const int id, const int nbq, const int sza, const char table[])
{
  int kraftfd, i, j;
  int v;
  char query[QUERY_BUFFSIZE];
  char buff[BUFSIZ];
  struct timeval t;

  kraftfd = connectKraftBySensor();
  for (i = 0; i < nbq; i ++) {
    bzero(query, QUERY_BUFFSIZE);
    sprintf(query, "append into %s.sensor values (", table);
    for (j = 0; j < sza; j++) {
      gettimeofday(&t, NULL);
      v = (int)(t.tv_usec % 100);
      bzero(buff, BUFSIZ);
      sprintf(buff, "%d", v);
      strcat(query, buff);
      if (j != sza - 1)
        strcat(query, ", ");
    }
    strcat(query, ") where id = ");

    bzero(buff, BUFSIZ);
    sprintf(buff, "%d", id);
    strcat(query, buff);

		S(query);
    sendQuery(query, kraftfd);
    getResultOfAdhocQuery(kraftfd);
		sleep(1);
  }
  sendExitAndCloseSockfd(kraftfd);

  exit(0);
}

static void
exeAppend(const int nbq, const int nbc, const int sza, const char table[])
{
  int i, pid;
  
  for (i = 0; i < nbc; i ++) 
    if ((pid = fork()) == 0) 
      issueAppend(i, nbq, sza, table);
}

static void
printUsage(void)
{
  printf("Usage:\n");
  printf("\tprogram #Query #Clients\n");
  exit(1);
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int 
main(const int argc, char *argv[])
{
  int nbc; /* # clients */
  int nbq; /* # queries */
	const int szmote = 4;
	const int szu3d = 3;

  if (argc != 3)
    printUsage();

  nbq = atoi(argv[1]);
	nbc = atoi(argv[2]);

	exeAppend(nbq, nbc, szmote, "mote");
	//exeAppend(nbq, nbc, szu3d, "u3d");
    
  return 0;
}
