#include "port.h"
#include "host.h"
#include "common.h" 
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include <gtk/gtk.h>

/****************************************************************
 *
 * Prototype
 *
 ***************************************************************/
extern int connectCli(int port, char hostname[]);
extern void releaseAnswer(ANSWER answer);
extern void initForGtk(void);
extern GtkWidget *makeGraph(SENSOR headSensor, ATTR_TYPE attrType);
/****************************************************************
 *
 * Global variable
 *
 ***************************************************************/
int Sockfd;
GtkWidget *entry;
GtkWidget *result;
GtkWidget *Table;

/***************************************************************
 *
 * Function
 *
 ***************************************************************/
static void 
sendQuery(char query[], const int sockfd)
{
  int ack;

  Send(sockfd, query, BUFSIZ, 0);
  Recv(sockfd, &ack, sizeof(int), 0);
}

static BOOLEAN
recvTypeOfAnswer(const int sockfd)
{
  int ack;
  TYPE_OF_ANSWER typeOfAnswer;
  
  Recv(sockfd, &typeOfAnswer, sizeof(TYPE_OF_ANSWER), 0);
  Send(sockfd, &ack, sizeof(int), 0);

  return typeOfAnswer;
}

static void
writeLine(const int numOfAttr)
{
  int attrid;
  int iter;
  char writeBuffer[BUFSIZ];
  
  bzero(writeBuffer, BUFSIZ);
  strcat(writeBuffer, "+");
  for (attrid = 0; attrid < numOfAttr; attrid ++) {
    strcat(writeBuffer, "-");
    for (iter = 0; iter < 8; iter ++) {
      strcat(writeBuffer, "-");
    }
    strcat(writeBuffer, "-+");
  }
  strcat(writeBuffer, "\n");
  gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));
}

static void
printAttribute(const ANSWER answer)
{
  int attrid;
  char writeBuffer[BUFSIZ];
  
  writeLine(answer.numOfAttr);
  bzero(writeBuffer, BUFSIZ);
  strcat(writeBuffer, "| ");
  gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer)); 
  for (attrid = 0; attrid < answer.numOfAttr; attrid ++) {
    bzero(writeBuffer, BUFSIZ);
    sprintf(writeBuffer, "%11s | ", answer.attr[attrid].attrName);
    gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));
  }
  bzero(writeBuffer, BUFSIZ);
  sprintf(writeBuffer, "\n");
  gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));

  writeLine(answer.numOfAttr);
}  

static void
printSensor(const SENSOR headSensor, const ATTR_TYPE attrType)
{
  char writeBuffer[BUFSIZ];
  SENSOR *pSensor;

  pSensor = headSensor.next;
  while(pSensor != NULL) {
    bzero(writeBuffer, BUFSIZ);
    /*
     * printf("{");
     * printf("{%ld, ", pSensor->timedObjInSensor.arrival.tv_sec);
     * printf("%ld}", pSensor->timedObjInSensor.arrival.tv_usec);
     */
    switch(attrType) {
    case SENSOR_INT:    sprintf(writeBuffer, "{%d}", pSensor->timedObjInSensor.objInSensor.intData);    break;
    case SENSOR_DOUBLE: sprintf(writeBuffer, "{%f}", pSensor->timedObjInSensor.objInSensor.doubleData); break;
    default: break;
    }
    /*
     *  printf("}");
     */
    gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));    
    pSensor = pSensor->next;
  }
}

static void
makeWindowForPrintResultForRelation(const ANSWER answer, const int numOfTuple)
{
  int tupleid;
  int attrid;
  char writeBuffer[BUFSIZ];
  TUPLE *pTuple;
  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *label;
  GtkWidget *text;
  GtkWidget *graph;

  /* Base table */
  Table = gtk_table_new(answer.numOfAttr, (numOfTuple + 1), TRUE);
  gtk_container_border_width (GTK_CONTAINER(Table), 1);

  /* Make attribute */
  tupleid = 0;
  for (attrid = 0; attrid < answer.numOfAttr; attrid ++) {
    button = gtk_button_new_with_label(answer.attr[attrid].attrName);
    gtk_container_border_width(GTK_CONTAINER(button), 1);
    gtk_table_attach_defaults(GTK_TABLE(Table), button, attrid, attrid+1, tupleid, tupleid+1);
    gtk_widget_show(button); 
  }
  tupleid ++;

  /* Make data */
  pTuple = answer.headTuple.next;
  while (pTuple != NULL) {
    for (attrid = 0; attrid < answer.numOfAttr; attrid ++) {
      bzero(writeBuffer, BUFSIZ);
      switch(answer.attr[attrid].attrType) {
      case INT:    
	sprintf(writeBuffer, "%d", pTuple->objInTuple[attrid].intData);    
	text = gtk_text_new(NULL, NULL);
	gtk_text_insert((GtkText *)text, NULL, NULL, NULL, writeBuffer, -1);
	gtk_table_attach_defaults(GTK_TABLE(Table), text, attrid, attrid+1, tupleid, tupleid+1);
	gtk_widget_show(text); 
	break;
      case DOUBLE: 
	sprintf(writeBuffer, "%f", pTuple->objInTuple[attrid].doubleData); 
	label = gtk_label_new(writeBuffer);
	gtk_table_attach_defaults(GTK_TABLE(Table), label, attrid, attrid+1, tupleid, tupleid+1);
	gtk_widget_show(label); 
	break;
      case TEXT:   
	sprintf(writeBuffer, "%s", pTuple->objInTuple[attrid].textData);   
	label = gtk_label_new(writeBuffer);
	gtk_table_attach_defaults(GTK_TABLE(Table), label, attrid, attrid+1, tupleid, tupleid+1);
	gtk_widget_show(label); 
	break;
      case SENSOR_DOUBLE:  
	printSensor(pTuple->objInTuple[attrid].headSensor, SENSOR_DOUBLE); 
	graph = makeGraph(pTuple->objInTuple[attrid].headSensor, SENSOR_DOUBLE);
	gtk_table_attach_defaults(GTK_TABLE(Table), graph, attrid, attrid+1, tupleid, tupleid+1);
	break;
      case SENSOR_INT:     
	printSensor(pTuple->objInTuple[attrid].headSensor, SENSOR_INT);    
	graph = makeGraph(pTuple->objInTuple[attrid].headSensor, SENSOR_INT);
	gtk_table_attach_defaults(GTK_TABLE(Table), graph, attrid, attrid+1, tupleid, tupleid+1);
	break;
      default:
        printf(writeBuffer, "No such type!\n");
        exit(1);
        break;
      }
    }
    pTuple = pTuple->next;
    tupleid ++;
  }

  /* Window */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  /* gtk_widget_set_usize(GTK_WIDGET(window), 500, 500); */
  gtk_window_set_title(GTK_WINDOW(window), "Result of Query");  
  gtk_container_border_width(GTK_CONTAINER (window), 1);

  /* Show */
  gtk_widget_show(Table); 
  gtk_container_add(GTK_CONTAINER(window), Table);
  gtk_widget_show(window); 
}


static void
printResultForRelation(const int sockfd)
{
  int ack;
  int attrid;
  int numid;
  int numOfSensorAttr;
  int numOfSensor;
  int numOfTuple;
  int sensorid;
  int tupleid;
  char writeBuffer[BUFSIZ];
  ANSWER answer;
  TUPLE *pTuple;
  SENSOR *pSensor;

  bzero(&answer, sizeof(ANSWER));

  Recv(sockfd, &answer.numOfAttr, sizeof(int), 0);
  Send(sockfd, &ack, sizeof(int), 0);

  answer.attr = Calloc(answer.numOfAttr, sizeof(ATTR));
  Recv(sockfd, answer.attr, (sizeof(ATTR) * answer.numOfAttr), 0);
  Send(sockfd, &ack, sizeof(int), 0);

  Recv(sockfd, &numOfTuple, sizeof(int), 0);
  Send(sockfd, &ack, sizeof(int), 0);

  pTuple = &answer.headTuple;
  for (tupleid = 0; tupleid < numOfTuple; tupleid ++) {
    pTuple->next = Calloc(1, sizeof(TUPLE));
    pTuple->next->prev = pTuple;
    pTuple = pTuple->next;
    pTuple->objInTuple = Calloc(answer.numOfAttr, sizeof(OBJ_IN_TUPLE));
    Recv(sockfd, pTuple->objInTuple, answer.numOfAttr * sizeof(OBJ_IN_TUPLE), 0);
    Send(sockfd, &ack, sizeof(int), 0);
    Recv(sockfd, &numOfSensorAttr, sizeof(int), 0);
    Send(sockfd, &ack, sizeof(int), 0);
    for (numid = 0; numid < numOfSensorAttr; numid ++) {
      Recv(sockfd, &attrid, sizeof(int), 0);
      Send(sockfd, &ack, sizeof(int), 0);
      Recv(sockfd, &numOfSensor, sizeof(int), 0);
      Send(sockfd, &ack, sizeof(int), 0);
      pSensor = &pTuple->objInTuple[attrid].headSensor;
      for (sensorid = 0; sensorid < numOfSensor; sensorid ++) {
        pSensor->next = Calloc(1, sizeof(SENSOR));
        pSensor->next->prev = pSensor;
        pSensor = pSensor->next;
        Recv(sockfd, &pSensor->timedObjInSensor, sizeof(TIMED_OBJ_IN_SENSOR), 0);
        Send(sockfd, &ack, sizeof(int), 0);
      }
    }
  }

  printAttribute(answer);
  pTuple = answer.headTuple.next;
  while (pTuple != NULL) {
    bzero(writeBuffer, BUFSIZ);
    sprintf(writeBuffer, "| ");
    gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));
    for (attrid = 0; attrid < answer.numOfAttr; attrid ++) {
      bzero(writeBuffer, BUFSIZ);
      switch(answer.attr[attrid].attrType) {
      case INT:    
	sprintf(writeBuffer, "%11d | ", pTuple->objInTuple[attrid].intData);    
	gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));
	break;
      case DOUBLE: 
	sprintf(writeBuffer, "%11f | ", pTuple->objInTuple[attrid].doubleData); 
	gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));
	break;
      case TEXT:   
	sprintf(writeBuffer, "%11s | ", pTuple->objInTuple[attrid].textData);   
	gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));
	break;
      case SENSOR_DOUBLE:  
	printSensor(pTuple->objInTuple[attrid].headSensor, SENSOR_DOUBLE); 
	break;
      case SENSOR_INT:     
	printSensor(pTuple->objInTuple[attrid].headSensor, SENSOR_INT);    
	break;
      default:
        sprintf(writeBuffer, "No such type!\n");
	gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));
        exit(1);
        break;
      }
    }
    bzero(writeBuffer, BUFSIZ);
    sprintf(writeBuffer, "\n");
    gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));

    pTuple = pTuple->next;
  }
  writeLine(answer.numOfAttr);

  makeWindowForPrintResultForRelation(answer, numOfTuple);
  releaseAnswer(answer);
}  

/*
 * --- Closing down the window
 */
static void 
destroy_window (void)
{
  gtk_main_quit ();
}

static void
makeWindowForPrintOperationSuccess(const char *operation)
{
  GtkWidget *window;
  GtkWidget *label;

#ifdef DEBUG
  printf("test dayon\n");
#endif

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Result of operation");  
  gtk_container_border_width (GTK_CONTAINER (window), 0);
  gtk_widget_set_usize(GTK_WIDGET(window), 100, 100);
  label = gtk_label_new(operation);  
  gtk_container_add (GTK_CONTAINER (window), label);
  gtk_widget_show(label); 
  gtk_widget_show(window); 

}

static void
printOperationSuccess(const TYPE_OF_ANSWER typeOfAnswer)
{
  switch(typeOfAnswer) {
  case ANSWER_CREATE: makeWindowForPrintOperationSuccess("CREATE"); break;
  case ANSWER_DROP:   makeWindowForPrintOperationSuccess("DROP");   break;
  case ANSWER_APPEND: makeWindowForPrintOperationSuccess("APPEND"); break;
  case ANSWER_INSERT: makeWindowForPrintOperationSuccess("INSERT"); break;
  case ANSWER_DELETE: makeWindowForPrintOperationSuccess("DELETE"); break;
  case ANSWER_UPDATE: makeWindowForPrintOperationSuccess("UPDATE"); break;
  default:
    printf("Unacceptable state\n"); 
    exit(1); 
    break;
  }
}

static void
printResultForSchema(const int sockfd)
{
  int ack;
  char schemaInfo[BUFSIZ];
  char writeBuffer[BUFSIZ];
  BOOLEAN finish;

  bzero(writeBuffer, BUFSIZ);
  sprintf(writeBuffer, "--------------------\n");
  gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));

  while (1) {
    Recv(sockfd, &finish, sizeof(BOOLEAN), 0);
    Send(sockfd, &ack, sizeof(int), 0);
    if (finish == TRUE) {
#ifdef DEBUG
      printf("finish == TRUE\n");
#endif
      break;
    }
#ifdef DEBUG
    printf("finish == FALSE\n");
#endif
    bzero(schemaInfo, BUFSIZ);
    Recv(sockfd, schemaInfo, BUFSIZ, 0);
    bzero(writeBuffer, BUFSIZ);
    sprintf(writeBuffer, "%s\n", schemaInfo);
    gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));
    Send(sockfd, &ack, sizeof(int), 0);
  }
  bzero(writeBuffer, BUFSIZ);
  sprintf(writeBuffer, "--------------------\n");
  gtk_text_insert(GTK_TEXT(result), 0, 0, 0, writeBuffer, strlen(writeBuffer));
}

static void 
clearResultWindow(void)
{
  char *resultBuffer;

  resultBuffer = gtk_editable_get_chars(GTK_EDITABLE(result), (gint)0, (gint)-1);
  gtk_text_backward_delete((GtkText *)result, strlen(resultBuffer));
  g_free(resultBuffer);  
}

static void 
button_event(void)
{
  char *pQuery;
  char query[BUFSIZ];
  TYPE_OF_ANSWER typeOfAnswer;

  pQuery = gtk_entry_get_text((GtkEntry *)entry);
  bzero(query, BUFSIZ);
  strcpy(query, pQuery);
#ifdef DEBUG
  printf("query: [%s]\n", query);
#endif
  g_free(pQuery);  

  sendQuery(query, Sockfd);
  typeOfAnswer = recvTypeOfAnswer(Sockfd);
  clearResultWindow(); 
  switch(typeOfAnswer) {
  case ANSWER_RELATION: printResultForRelation(Sockfd); break;
  case ANSWER_SCHEMA:   printResultForSchema(Sockfd);   break;
  default: printOperationSuccess(typeOfAnswer);         break;
  }

}

static int
initClient(void)
{
  int sockfd;

  sockfd = connectCli(DB_PORT, DB_HOST);

  return sockfd;
}


/*
 * CreateEditable
 *
 */
static void 
CreateEditable(GtkWidget *container)
{
  entry = gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(entry), "");
  gtk_container_add(GTK_CONTAINER(container), entry);
  gtk_widget_show(entry);
}

static void 
CreateShowResult(GtkWidget *container, GtkWidget *table)
{
  GtkWidget *vscroll;

  result = gtk_text_new(NULL, NULL);
  gtk_text_set_editable(GTK_TEXT(result), FALSE);

  vscroll = gtk_vscrollbar_new(GTK_TEXT(result)->vadj);
  gtk_table_attach(GTK_TABLE(table), vscroll, 3, 4, 1, 4, GTK_FILL, GTK_EXPAND|GTK_SHRINK|GTK_FILL, 0, 0);
  gtk_container_add(GTK_CONTAINER (container), result);
  gtk_widget_show(result);
  gtk_widget_show(vscroll);
}

/*
 * main
 *
 * Program begins here
 */
int
main(void)
{
  GtkWidget *window;
  GtkWidget *readQuery;
  GtkWidget *showResult;
  GtkWidget *button;  
  GtkWidget *table;

  Sockfd = initClient();      

  /* --- Start up GTK --- */
  gtk_init(NULL, NULL);
  
  /* --- Create the top level window --- */
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  
  gtk_window_set_title (GTK_WINDOW (window), "Artemis Client");
  gtk_container_border_width (GTK_CONTAINER (window), 0);

  /* table */
  table = gtk_table_new(4, 4, TRUE);
  
  /* --- Listen for the destroy of the window --- */
  gtk_signal_connect (GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(destroy_window), NULL);

  /* --- Set the window title and size --- */
  /* gtk_widget_set_usize(GTK_WIDGET(window), 300, 200); */
  
  /* --- Create a new vertical box for storing widgets --- */
  readQuery = gtk_vbox_new(FALSE, 1);
  button = gtk_button_new_with_label ("Query");  
  showResult = gtk_vbox_new(FALSE, 1);
  gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC (button_event), "clicked");

  /* --- border width is 1 --- */
  gtk_container_border_width(GTK_CONTAINER(readQuery), 1);
  gtk_container_border_width(GTK_CONTAINER(button), 1);
  gtk_container_border_width(GTK_CONTAINER(showResult), 1);
  
  gtk_table_attach_defaults(GTK_TABLE(table), readQuery, 0, 3, 0, 1);
  gtk_table_attach_defaults(GTK_TABLE(table), button, 3, 4, 0, 1);
  gtk_table_attach_defaults(GTK_TABLE(table), showResult, 0, 3, 1, 4);

  /* --- Make the vertical box visible --- */
  gtk_widget_show(readQuery);
  gtk_widget_show(button); 
  gtk_widget_show(showResult);
  
  /* --- Show the top level window --- */
  gtk_container_add(GTK_CONTAINER(window), table);
  gtk_widget_show(table);
  gtk_widget_show(window);
  
  /* --- Create editable window --- */
  CreateEditable(readQuery);
  CreateShowResult(showResult, table);

  /* --- Loop and process messages --- */
  gtk_main();
    
  return(0);
}

