#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netdb.h>
#include <signal.h>
#include <readline/readline.h>
#include <readline/history.h>
#include "port.h"
#include "host.h"
#include "common.h" 
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include "buffsize.h"
#include "sensorImageSize.h"
#include "slotsize.h"
#include "ipc.h"

/****************************************************************
 *
 * Prototype
 *
 ***************************************************************/
extern int connectCli(int port, char hostname[]);
extern void releaseAnswerForClient(ANSWER answer);
extern ANSWER recvAnswer(const int sockfd);
extern void printResultForRelation(ANSWER answer);
extern void printResultForSchema(const int sockfd);
extern void sendback(const int sockfd, void *ptr, const int size, const int flag);
extern void sendQuery(const char query[], const int sockfd);
extern TYPE_OF_ANSWER recvTypeOfAnswer(const int sockfd);

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static BOOLEAN
checkExit(char query[])
{
  int i;
  BOOLEAN fin = FALSE;

  for (i = 0; isspace(query[i]); ) i++;
  if ((query[i] == 'e' && strcmp(&query[i], "exit") == 0) || 
      (query[i] == 'q' && strcmp(&query[i], "quit") == 0) || 
      (query[i] == '\\' && strcmp(&query[i], "\\q") == 0)) 
    fin = TRUE;

  return fin;
}

static BOOLEAN
readOperation(char query[], FILE *fpin)
{
  char *rlquery;

  bzero(query, QUERY_BUFFSIZE);
  if (fpin == NULL) {
    rlquery = readline("> ");
    add_history(rlquery);
    sprintf(query, "%s", rlquery);
    free(rlquery);
  }
  else { /* Read query from file */
    if (fgets(query, QUERY_BUFFSIZE, fpin) != NULL) {
      if (query[strlen(query)-1] == '\n') 
        query[strlen(query)-1] = '\0';
    }
    else /* No more commands */
      return TRUE;
  }

  return checkExit(query);
}

static void
sendExitAndCloseSockfd(const int sockfd)
{
  char query[QUERY_BUFFSIZE];

  bzero(query, QUERY_BUFFSIZE);
  strncpy(query, "exit", strlen("exit"));
  sendback(sockfd, query, QUERY_BUFFSIZE, 0);
  if (close(sockfd) == -1) ERR;
}

static BOOLEAN
isThisRunMonitor(const char query[])
{
  int qid;
  BOOLEAN thisIsRunMonitor = FALSE;

  for (qid = 0; qid < (int)(QUERY_BUFFSIZE - strlen("run")); qid ++) {
    if (strncmp(&query[qid], "run", strlen("run")) == 0) {
      thisIsRunMonitor = TRUE;
      break;
    }
  }

  return thisIsRunMonitor;
}

static void
errorAtRunMonitor(TYPE_OF_ANSWER typeOfAnswer)
{
  printf("The type is unacceptable here: %d", typeOfAnswer);
  ERR;
}

static void
execRunMonitor(const int sockfd)
{
  TYPE_OF_ANSWER typeOfAnswer;
  ANSWER answer;

  do {
    typeOfAnswer = recvTypeOfAnswer(sockfd);
    switch(typeOfAnswer) {
    case ANSWER_RELATION: 
      answer = recvAnswer(sockfd);
      printResultForRelation(answer); 
      break;
    case ANSWER_FINISH_MONITOR_RUN:       
      printf("MONITOR FINISHES\n"); 
      break;
    default: errorAtRunMonitor(typeOfAnswer);
      break;
    }
  } while (typeOfAnswer != ANSWER_FINISH_MONITOR_RUN);
}

static void
getResultOfAdhocQuery(const int sockfd)
{
  TYPE_OF_ANSWER typeOfAnswer;
  ANSWER answer;

  typeOfAnswer = recvTypeOfAnswer(sockfd);
  switch (typeOfAnswer) {

  case ANSWER_RELATION:    
    answer = recvAnswer(sockfd);
    printResultForRelation(answer); 
    break;

  case ANSWER_SHOW_MONITOR: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_WINDOW: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_SCHEMA:  
    printResultForSchema(sockfd);   
    break;

  default:
    printResultOfOperation(typeOfAnswer);            
    break;
  }
}

static void
execQueryLoop(FILE *fpin)
{
  int sockfd;
  char query[QUERY_BUFFSIZE];
  BOOLEAN exitLoop;

  sockfd = connectCli(DBMS_CLIENT_PORT, DBMS_HOST);
  while ((exitLoop = readOperation(query, fpin)) == FALSE) {
    sendQuery(query, sockfd);
    switch (isThisRunMonitor(query)) {
    case TRUE:  
      execRunMonitor(sockfd);        
      break;
    case FALSE: 
      getResultOfAdhocQuery(sockfd); 
      break;
    }
  }
  sendExitAndCloseSockfd(sockfd);
}

static FILE *
getFilePointer(char file[])
{
  FILE *fpin;

  if ((fpin = fopen(file, "r")) == NULL) ERR;
 
  return fpin;
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int
main(int argc, char *argv[])
{
  FILE *fpin;

  if (argc == 1) {
    execQueryLoop(NULL);
  }
  else {
    fpin = getFilePointer(argv[1]);
    execQueryLoop(fpin);
    if (fclose(fpin) != 0) ERR;
  }

  return 0;
}
