#include "common.h"
#include "buffsize.h"
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include "ipc.h"

typedef enum {INSERT, APPEND} TYPE;

/***************************************************************
 *
 * Declaration
 *
 ***************************************************************/
extern void sendQuery(const char query[], const int sockfd);
extern TYPE_OF_ANSWER recvTypeOfAnswer(const int sockfd);
extern ANSWER recvAnswer(const int sockfd);
extern void printResultForRelation(ANSWER answer);
extern void printResultForSchema(const int sockfd);
extern void printResultOfOperation(const TYPE_OF_ANSWER typeOfAnswer);
extern int connectKraftByClient(void);
extern int connectKraftBySensor(void);
extern void sendExitAndCloseSockfd(const int sockfd);

/***************************************************************
 *
 * Global Variables
 *
 ***************************************************************/
char *BgnAry;
char *EndAry;
int Nbq;
int Sza;
static int Start = 0;
struct timeval Begin, End;

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static void
getResultOfAdhocQuery(const int sockfd)
{
  TYPE_OF_ANSWER typeOfAnswer;
  ANSWER answer;

  typeOfAnswer = recvTypeOfAnswer(sockfd);
  switch (typeOfAnswer) {

  case ANSWER_RELATION:    
    answer = recvAnswer(sockfd);
    printResultForRelation(answer); 
    break;

  case ANSWER_SHOW_MONITOR: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_WINDOW: 
    printResultForSchema(sockfd);   
    break;

  case ANSWER_SHOW_SCHEMA:  
    printResultForSchema(sockfd);   
    break;

  default:
    printResultOfOperation(typeOfAnswer);            
    break;
  }
}

static void *
issueAppend(void *arg)
{
	int id = (int)arg;
  int kraftfd;
	int i;
  char query[QUERY_BUFFSIZE];

  kraftfd = connectKraftBySensor();

	bzero(query, QUERY_BUFFSIZE);
	sprintf(query, "append into r1.0 values (1,1,1,1) where id = %d", id);

	BgnAry[id] = 1;
	while (Start != 1) {
		usleep(10);
	}
  for (i = 0; i < Nbq; i ++) {
    sendQuery(query, kraftfd);
    getResultOfAdhocQuery(kraftfd);
  }
  sendExitAndCloseSockfd(kraftfd);
	EndAry[id] = 1;

	return NULL;
}

static void
invoke_thread(int i)
{
	pthread_t thread;

	pthread_create(&thread, NULL, issueAppend, (void *)i);
	pthread_detach(thread);
}

static void
exeAppend(const int nbq, const int nbc, const int sza)
{
  int i;

	if ((BgnAry = calloc(nbc, sizeof(char))) == NULL) ERR;  
	if ((EndAry = calloc(nbc, sizeof(char))) == NULL) ERR;

	Nbq = nbq;
	Sza = sza;
  for (i = 0; i < nbc; i ++) 
		invoke_thread(i);

  while (1) {
		for (i = 0; i < nbc; i++)
			if (BgnAry[i] == 0) break;

		if (i == nbc) 
			break;

    usleep(10);
  }

	Start = 1;
	gettimeofday(&Begin, NULL);
  while (1) {
		for (i = 0; i < nbc; i++)
			if (EndAry[i] == 0) break;

		if (i == nbc) 
			break;

    usleep(10);
  }
	gettimeofday(&End, NULL);
	free(BgnAry);
	free(EndAry);

	printf("%ld\n", (End.tv_sec - Begin.tv_sec) * 1000 * 1000 + (End.tv_usec - Begin.tv_usec));
}

static void
issueInsert(const int nbq)
{
  int sockfd, i;
  char query[QUERY_BUFFSIZE];

  sockfd = connectKraftByClient();
  for (i = 0; i < nbq; i ++) {
    bzero(query, QUERY_BUFFSIZE);
    sprintf(query, "insert into r1 values (%d, null)", i);
    sendQuery(query, sockfd);
    getResultOfAdhocQuery(sockfd);
  }
  sendExitAndCloseSockfd(sockfd);
}

static void
exeInsert(const int nbq)
{
  issueInsert(nbq);
}

static TYPE
getType(char c)
{
  if (c == 'i') 
    return INSERT;
  else if (c == 'a') 
    return APPEND;

  ERR;
}

static void
printUsage(void)
{
  printf("Usage:\n");
  printf("\tINSERT: program i #Query\n");
  printf("\tAPPEND: program a #Query #Clients #Array\n");
  exit(1);
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int 
main(const int argc, char *argv[])
{
  int nbc; /* # clients */
  int nbq; /* # queries */
  int sza; /* size of array */

  TYPE type;

  if (argc < 3 || argc > 6)
    printUsage();

  type = getType(argv[1][0]);
  nbq = atoi(argv[2]);
  
  switch(type) {
  case INSERT:
    exeInsert(nbq);
    break;
  case APPEND:
    nbc = atoi(argv[3]);
    sza = atoi(argv[4]);
    exeAppend(nbq, nbc, sza);
    break;
  }
    
  return 0;
}
