#ifndef _FUNCTION_
#define _FUNCTION_
#include "function.h"
#endif

#ifndef _BUFFSIZE_H
#define _BUFFSIZE_H
#include "buffsize.h"
#endif

#ifndef _WINDOW_H
#define _WINDOW_H
#include "window.h"
#endif

typedef enum {LESS, LESS_EQUAL, GREATER, GREATER_EQUAL, EQUAL, NOT_EQUAL} OPERAND;
typedef enum {BINARY, SIMSEQ} TYPE_OF_CONDITION;
typedef enum {TIME_RANGE, VALUE_RANGE} TYPE_OF_RANGE;
typedef enum {AND, OR} ANDOR;
typedef enum {EUCLID, WARPING, LCSS} METRIC;
typedef enum {ASC_ORDER_TYPE, DESC_ORDER_TYPE, NO_ORDER_TYPE} ORDER_TYPE;
typedef enum {SIMSEQ_EXTERNAL_NUMBER_INTEGER, SIMSEQ_EXTERNAL_NUMBER_FLOAT} SIMSEQ_EXTERNAL_NUMBER_TYPE;
typedef enum {SIMSEQ_LATEST_NUMBER_INTEGER, SIMSEQ_LATEST_NUMBER_FLOAT} SIMSEQ_LATEST_NUMBER_TYPE;
typedef enum {SIMSEQ_LATEST_UNIT_ITEM, SIMSEQ_LATEST_UNIT_SEC, SIMSEQ_LATEST_UNIT_MILISEC} SIMSEQ_LATEST_UNIT_TYPE;
typedef enum {PAST, BOTH, FUTURE} DIRECTION_OF_VIEW_FOR_RANGE_CODITION;
typedef struct _SELECT_ATTR {
  struct _SELECT_ATTR *next;
  BOOLEAN err;
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
	/* 
	 * For Function Computation 
	 */
  FUNCTION f;
  int said; /* ID of Sensor Array for window funcs */
	/* 
	 * For window computation 
	 */
	WINDOW_TYPE w;  /* Sliding or not */	
	int nt;         /* Number of tuples */
	int ns;         /* Number of skips */
	/* 
	 * For distance function
	 */
  int s_said;          /* ID of Sensor Array for distance funcs */
  char s_sn[BUFFSIZE]; /* Sensor Schema Name    */
  char s_an[BUFFSIZE]; /* Sensor Attribute Name */
} SELECT_ATTR;
typedef struct _BIN_CND {
  /* Attribute Information */
  int aid;
  char leftText[BUFFSIZE];  /* Attribute Name */
  /* Condition Information */
  char rightText[BUFFSIZE]; /* Condition of Selection */
  /* others */
  OPERAND operand;
  int said; /* Sensor Array ID */
} BIN_CND;
typedef struct _SIM_CND {
  char sn[BUFFSIZE]; /* Schema Name */
  char an[BUFFSIZE]; /* Attribute Name */
  char wn[BUFFSIZE]; /* Window Name */
  METRIC mt;
  OPERAND op;
  double th; /* Threshold */
  int said;  /* ID of sensor array, e.g. s[3] -> "3" */
} SIM_CND;
typedef union _SIM_BIN_CND {
  SIM_CND sim;
  BIN_CND binary;
} SIM_BIN_CND;
typedef struct _CONDITION {
  BOOLEAN err;
  ANDOR andor;
  TYPE_OF_CONDITION typeOfCondition;
  SIM_BIN_CND u;
  struct _CONDITION *next;  
} CONDITION;
typedef struct _FROM_SCHEMA {
  BOOLEAN err;
  char schemaName[BUFFSIZE];
  int offset;
  struct _FROM_SCHEMA *next;
} FROM_SCHEMA;
typedef struct _SCHEMA_LIST {
  SCHEMA *pSchema;
  struct _SCHEMA_LIST *next;
} SCHEMA_LIST;
typedef struct _CONDITION_LIST {
  CONDITION headCondition;
  struct _CONDITION_LIST *next;
} CONDITION_LIST;
typedef struct _TUPLE_LIST {
  TUPLE *pTuple;
  struct _TUPLE_LIST *next;
} TUPLE_LIST;
typedef struct _ORDER_INFO {
  BOOLEAN err;
  ORDER_TYPE orderType;
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
} ORDER_INFO;
typedef struct _ANSWER {
  int numOfSensorSegmentAttr;
  int numOfAnswerTuple;
  int numOfAttr;
  int byteOfTuple;
  ATTR *attr;
  TUPLE headTuple;
  TUPLE_LIST headAndorTupleList;
  PARSE_MSG parseMsg;
} ANSWER;
