#include "common.h"
#include "libWrapper.h"

extern int 
connectCli(const int port, const char hostname[])
{
  int sockfd;
  int optval = 1;
  struct hostent *ent;
  struct sockaddr_in addr;

  bzero((char *)&addr, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  if ((ent = gethostbyname(hostname)) == NULL) ERR;
  bcopy(ent->h_addr, (char *)&addr.sin_addr, ent->h_length);
  if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) ERR;
  if (setsockopt(sockfd, IPPROTO_TCP, TCP_NODELAY, &optval, sizeof(optval)) == -1) ERR;
  if (connect(sockfd, (struct sockaddr *)&addr, sizeof(struct sockaddr_in)) == -1) ERR;

  return sockfd;
}
