#include "common.h"
#include "transInfo.h"
#include "libWrapper.h"
#include "buffsize.h"
#include "sensorImageSize.h"
#include "slotsize.h"
#include <ctype.h>
#include "printTime.h"
#include "dataDir.h"

/********************
 *
 * Declaration
 *
 ********************/
extern void lockEntirePage(void);
extern void unlockEntirePage(void);
extern void logInsert(PERSISTENT_OBJ *persistP);
extern void pin(DBPAGE *buffPageP, char mode);
extern void unpin(DBPAGE *buffPageP);
extern void releaseThisSchema(SCHEMA *schemaP);
extern int getCurPageSize(DBPAGE *pageP);
extern int getAttridForUpdateOrAppend(const char attrName[], const SCHEMA *pSchema);
extern PERSISTENT_OBJ *allocPrstApndObj(const char schemaName[], const char attrName[], SDOBJ obj, const PAGEINFO pi);
extern SCHEMA *getSchema(const char schemaName[]);
extern DBPAGE *getEndPage(SCHEMA *schemaP, int attrid, int tupleid);
extern DBPAGE *getNewPage(SCHEMA *schemaP, int attrid, int tupleid);


/********************
 *
 * Global variable
 *
 ********************/
extern SCHEMA HeadSchema;
extern pthread_rwlock_t LockBuffPage;

/********************
 *
 * Private function
 *
 ********************/
extern int
getAttrid(const char attrName[], const SCHEMA *pSchema)
{
  int attrid;
  
  for (attrid = 0; attrid < pSchema->numOfAttr; attrid++) {
    if (strncmp(attrName, pSchema->attr[attrid].attrName, strlen(attrName)) == 0) 
      return attrid;
  }

  return -1;
}

static int
getSchemaNameForAppend(const char query[], char schemaName[])
{
  int left;
  int right;
  int qid;

  qid = 0;
  while ((qid < QUERY_BUFFSIZE) && (strncmp(&query[qid], "append", strlen("append")) != 0)) {qid++;}
  if (qid == QUERY_BUFFSIZE) {
    ERR;
  }
  else {
    qid += strlen("append");
  }

  while ((qid < QUERY_BUFFSIZE) && (strncmp(&query[qid], "into", strlen("into")) != 0)) { qid++;}
  if (qid == QUERY_BUFFSIZE) {
    ERR;
  }
  else {
    qid += strlen("into");
  }

  while ((query[qid] == ' ') && (qid < QUERY_BUFFSIZE)) {qid++;} left = qid;
  while ((query[qid] != '.') && (qid < QUERY_BUFFSIZE)) {qid++;} right = qid;
  bzero(schemaName, BUFFSIZE);
  strncpy(schemaName, &query[left], right-left);
  qid += strlen("."); 

  return qid;
}

static int
getSensorNameForAppend(const char query[], char sensorName[], const int givenQid)
{
  int qid;
  int left;
  int right;

  qid = givenQid + 1;
  left = givenQid;
  while (query[qid] != ' ') {qid++;}  right = qid;
  strncpy(sensorName, &query[left], right-left);
  while (query[qid] == ' ') {qid++;}

  return qid;
}

static int
parseInGetTimedObjInSensorForAppend(char buff[], const int givenQid, const char query[])
{
  int left;
  int right;
  int qid = givenQid;
  
  while ((qid < QUERY_BUFFSIZE) && (query[qid] == ' ')) 
    qid++;
  left = qid;
  while ((qid < QUERY_BUFFSIZE) && ((query[qid] != ' ') && (query[qid] != ',') && (query[qid] != ')')))
    qid++;
  right = qid;
  qid++; /* Next to ',' */
  bzero(buff, BUFFSIZE);
  strncpy(buff, &query[left], right-left);

  return qid;
}

static int 
skipValuesInGetTimedObjInSensorForAppend(const int givenQid, const char query[])
{
  int qid = givenQid;

  while ((qid < QUERY_BUFFSIZE) && (strncmp(&query[qid], "values", strlen("values")) != 0)) 
    qid++;

  qid += strlen("values");

  while ((qid < QUERY_BUFFSIZE) && (query[qid] != '(')) 
    qid++; 
  qid++; /* '(' */

  return qid;
}

static void
getSensorObj(const char query[], int qid, double *v, int szsa)
{
  int i;
  char buff[BUFFSIZE];

  qid = skipValuesInGetTimedObjInSensorForAppend(qid, query);
  for (i = 0; i < szsa; i++) {
    qid = parseInGetTimedObjInSensorForAppend(buff, qid, query);
    v[i] = atof(buff);
  }
}     

#ifdef TIME
static void
diff(struct timeval end, struct timeval begin)
{
  printf("%ld\n", (end.tv_sec - begin.tv_sec)*1000*1000 + (end.tv_usec - begin.tv_usec));
}
#endif

static void
execAppend(SCHEMA *schemaP, SDOBJ obj, const int aid, const int tid)
{
  int offset;
  char *p; /* for memcpy dst address */

  /* 
   * Get Buffer  
   * Here we get the lock of dbpage (i.e. pin)
   */
  lockEntirePage();
  if (schemaP->attr[aid].p[tid].endP == NULL) 
    schemaP->attr[aid].p[tid].endP = getEndPage(schemaP, aid, tid); /* Page has a lock */
  else 
    pin(schemaP->attr[aid].p[tid].endP, 'w');

  if ((schemaP->attr[aid].p[tid].endP->pi.numOfObj + 1) * schemaP->attr[aid].p[tid].endP->pi.sizOfObj > (int)(PAGESIZE - sizeof(PAGEINFO))) {
    offset = schemaP->attr[aid].p[tid].endP->pi.offset + PAGESIZE;
    unpin(schemaP->attr[aid].p[tid].endP);
    schemaP->attr[aid].p[tid].endP = getNewPage(schemaP, aid, tid); /* Page has a lock */
    schemaP->attr[aid].p[tid].endP->pi.offset = offset;
  }
  unlockEntirePage();

  /* Modify Buffer */
  assert(schemaP->attr[aid].p[tid].endP != NULL);
  p = &schemaP->attr[aid].p[tid].endP->data[getCurPageSize(schemaP->attr[aid].p[tid].endP)];
  memcpy(p, &obj, sizeof(SDOBJ));
  memcpy(p + sizeof(SDOBJ), obj.v, sizeof(double) * obj.szsa);
  schemaP->attr[aid].p[tid].endP->pi.numOfObj++; /* Increment */

  /* Unlock Buffer */
  unpin(schemaP->attr[aid].p[tid].endP); /* Release lock which was obtained in buffMgr */
}

static int
getTupleidInAppend(const char query[])
{
  int qid, tupleid;
  int leftid = 0;
  int rightid = 0;
  char tupleidNumberBuff[BUFFSIZE];

  for (qid = 0; qid < QUERY_BUFFSIZE; qid++) {
    if (strncmp(&query[qid], "id", strlen("id")) == 0) {
      break;
    }
  }
  for (; qid < QUERY_BUFFSIZE; qid++) {
    if (strncmp(&query[qid], "=", strlen("=")) == 0) {
      break;
    }
  }
  for (; qid < QUERY_BUFFSIZE; qid++) {
    if (isdigit(query[qid])) {
      leftid = qid;
      break;
    }
  }
  for (; qid < QUERY_BUFFSIZE; qid++) {
    if (!isdigit(query[qid])) {
      rightid = qid;
      break;
    }
  }
  
  bzero(tupleidNumberBuff, BUFFSIZE);
  strncpy(tupleidNumberBuff, &query[leftid], rightid-leftid);
  tupleid = atoi(tupleidNumberBuff);

  return tupleid;
}

/****************************************************************
 *
 * Public function
 *
 ***************************************************************/
extern PARSE_MSG
append(const char query[])
{
  int aid, qid;
  int tid; /* Tuple id */
  char schemaName[BUFFSIZE], sensorName[BUFFSIZE];
  SDOBJ sdobj;
  SCHEMA *schemaP;
#ifdef TIME
  struct timeval begin, end;
#endif

  bzero(schemaName, BUFFSIZE);
  bzero(sensorName, BUFFSIZE);

  qid = getSchemaNameForAppend(query, schemaName);
  if ((schemaP = getSchema(schemaName)) == NULL)
    return TABLE_NOT_EXIST;
  qid = getSensorNameForAppend(query, sensorName, qid);
  if ((aid = getAttrid(sensorName, schemaP)) == -1)
    return ATTR_NOT_EXIST;

  if ((tid = getTupleidInAppend(query)) > schemaP->numOfObj)
    return TUPLE_NOT_EXIST;

  sdobj.szsa = schemaP->attr[aid].szsa;
  if ((sdobj.v = calloc(sdobj.szsa, sizeof(double))) == NULL) ERR;
  getSensorObj(query, qid, sdobj.v, sdobj.szsa);
  if (gettimeofday(&sdobj.t, NULL) == -1) ERR;

#ifdef TIME
  gettimeofday(&begin, NULL);
#endif

  execAppend(schemaP, sdobj, aid, tid);
#ifdef TIME
  gettimeofday(&end, NULL);
  diff(end, begin);
#endif
  
  return PARSE_OK;
}
