/*
 * EQUAL means a symbol '='
 */
#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _EXTERN_H
#include "extern.h"
#define _EXTERN_H
#endif


/*
 * Functions
 */
static ANSWER
exeor(ANSWER answer, const CONDITION *cndP)
{
  int attrid;
  int byteOffset;
  int intData;
  double doubleData;
  TUPLE *pAnswerTuple;
  ATTR_TYPE attrType;
  TUPLE_LIST *pAndorTupleList;
  SENSOR_SEGMENT *ssp;
  SENSOR *sp, *tmp;

  pAndorTupleList = &answer.headAndorTupleList;
  while (pAndorTupleList->next != NULL) 
    pAndorTupleList = pAndorTupleList->next;

  for (byteOffset = 0, attrid = 0; attrid < cndP->u.binary.aid; attrid++) 
    byteOffset += answer.attr[attrid].sizOfAttr;

  attrType = answer.attr[cndP->u.binary.aid].attrType;
  for (pAnswerTuple = answer.headTuple.next; pAnswerTuple != NULL; pAnswerTuple = pAnswerTuple->next) {
    switch (attrType) {
    case INT:    
      memcpy(&intData, pAnswerTuple->obj + byteOffset, sizeof(int));       
      if (intData == atoi(cndP->u.binary.rightText)) {
        pAnswerTuple->selected = TRUE;
        if ((pAndorTupleList->next = calloc(1, sizeof(TUPLE_LIST))) == NULL) ERR;
        pAndorTupleList = pAndorTupleList->next;
        pAndorTupleList->pTuple = pAnswerTuple;
      }
      break;

    case DOUBLE: 
      memcpy(&doubleData, pAnswerTuple->obj + byteOffset, sizeof(double)); 

      if (doubleData == atof(cndP->u.binary.rightText)) {
        pAnswerTuple->selected = TRUE;
        if ((pAndorTupleList->next = calloc(1, sizeof(TUPLE_LIST))) == NULL) ERR;
        pAndorTupleList = pAndorTupleList->next;
        pAndorTupleList->pTuple = pAnswerTuple;
      }
      break;

    case SENSOR_SEGMENT_DOUBLE: 
      pAnswerTuple->selected = TRUE;
      ssp = (SENSOR_SEGMENT *)(pAnswerTuple->obj + byteOffset);
      for (sp = &ssp->next->headSensor; sp->next != NULL;) {
        if (sp->next->sdobj.v[cndP->u.binary.said] != atof(cndP->u.binary.rightText)) {
          tmp = sp->next;
          sp->next = sp->next->next;
          free(tmp);
        }
        else {
          sp = sp->next;
        }
      }
      break;

      default: 
      ERR;
      break;
    }
  }

  return answer;
}

static ANSWER
exeand(ANSWER answer, const CONDITION *cndP)
{
  int attrid;
  int byteOffset;
  int intData;
  double doubleData;
  ATTR_TYPE attrType;
  TUPLE_LIST *pMarkAndorTupleList;
  SENSOR_SEGMENT *ssp;
  SENSOR *sp, *tmp;

  attrType = answer.attr[cndP->u.binary.aid].attrType;
  for (pMarkAndorTupleList = answer.headAndorTupleList.next;
       pMarkAndorTupleList != NULL;
       pMarkAndorTupleList = pMarkAndorTupleList->next) {
    if (pMarkAndorTupleList->pTuple->selected == TRUE) {
      if (pMarkAndorTupleList->pTuple->certified == FALSE) {
        for (byteOffset = 0, attrid = 0; attrid < cndP->u.binary.aid; attrid++) {
          byteOffset += answer.attr[attrid].sizOfAttr;
        }
        switch (attrType) {
        case INT:    
          memcpy(&intData, pMarkAndorTupleList->pTuple->obj + byteOffset, sizeof(int)); 
          if (intData != atoi(cndP->u.binary.rightText))
            pMarkAndorTupleList->pTuple->selected = FALSE;
          break;

        case DOUBLE: 
          memcpy(&doubleData, pMarkAndorTupleList->pTuple->obj + byteOffset, sizeof(double)); 
          if (doubleData != atof(cndP->u.binary.rightText))
            pMarkAndorTupleList->pTuple->selected = FALSE;
          break;

        case SENSOR_SEGMENT_DOUBLE: 
          ssp = (SENSOR_SEGMENT *)(pMarkAndorTupleList->pTuple->obj + byteOffset);
          for (sp = &ssp->next->headSensor; sp->next != NULL;) {
            if (sp->next->sdobj.v[cndP->u.binary.said] != atof(cndP->u.binary.rightText)) {
              tmp = sp->next;
              sp->next = sp->next->next;
              free(tmp);
            }
            else {
              sp = sp->next;
            }
          }
          break;

        default: 
          ERR;
          break;
        }
      }
    }
  }

  return answer;
}

extern ANSWER
execSelectionCaseEqual(const CONDITION *cndP, ANSWER answer)
{
  TUPLE_LIST *trash;

  if (cndP->andor == OR) {
    while (answer.headAndorTupleList.next != NULL) {
      trash = answer.headAndorTupleList.next;
      if (trash->pTuple->selected == TRUE) {
        trash->pTuple->certified = TRUE;
      }
      answer.headAndorTupleList.next = answer.headAndorTupleList.next->next;
      free(trash);
    }
  }

  switch (cndP->andor) {
  case OR:  
    answer = exeor(answer, cndP);  
    break;
  case AND: 
    answer = exeand(answer, cndP); 
    break;
  }

  return answer;
}
