#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include <ctype.h>
#include "dataDir.h"
#include "windowDir.h"

#ifndef _WINDOW_H
#define _WINDOW_H
#include "window.h"
#endif

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _TRANS_INFO_H
#define _TRANS_INFO_H
#include "transInfo.h"
#endif

#ifndef _LOG_INFO_H
#define _LOG_INFO_H
#include "logInfo.h"
#endif

/****************************************************************
 *
 * Gloval variable
 *
 ***************************************************************/
extern SCHEMA HeadSchema;
extern METAW HeadMetaw;

/****************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static int
skipCreate(const char buff[])
{
  int o; /* offset */

  /* Skip create */
  for (o = 0; o < BUFFSIZE; o++) {
    if ((buff[o] == 'c') && (strncmp(&buff[o], "create", strlen("create")) == 0)) { 
      o += strlen("create");
      break;
    }
  }

  /* Skip window */
  for (; o < BUFFSIZE; o++) {
    if ((buff[o] == 'w') && (strncmp(&buff[o], "window", strlen("window")) == 0)) { 
      o += strlen("window");
      break;
    }
  }

  while (isspace(buff[o])) o++;

  return o;
}

/* 
 * EXAMPLE:
 * 
 * create window testdayon {0:0:0.0, 1:0:1.0, 3:0:3.0} 
 *                          sec:usec:val
 */
static int
cntNbVal(int o, char query[])
{
  int num = 0;

  for (; query[o] != '}' && o < BUFFSIZE; )
    if (query[o++] == ',') 
      num++;

  if (o == BUFFSIZE) 
    return -1;
  else
    return ++num; /* ++ means '}' */
}

static void
getvt(WINDOW *w, char query[])
{
  int i, j;
  int o; /* offset */
  char buff[BUFFSIZE];

  for (o = 0; query[o] != '{'; o++) ;  /* {0:0:0.0, 1:0:1.0, 3:0:3.0} */
  o++; /* skip '{' */

  for (i = 0; i < w->num; i++) {
    /* tv_sec */
    bzero(buff, BUFFSIZE);
    while (isspace(query[o])) o++;
    for (j = 0; query[o] != ':'; ) 
      buff[j++] = query[o++];
    w->p[i].t.tv_sec = atol(buff);
    o++; /* skip ':' */

    /* tv_usec */
    bzero(buff, BUFFSIZE);
    while (isspace(query[o])) o++;
    for (j = 0; query[o] != ':'; ) 
      buff[j++] = query[o++];
    w->p[i].t.tv_usec = atol(buff);
    o++; /* skip ':' */

    /* value */
    bzero(buff, BUFFSIZE);
    while (isspace(query[o])) o++;
    for (j = 0; query[o] != ',' && query[o] != '}'; ) 
      buff[j++] = query[o++];
    w->p[i].v = atof(buff);
    o++; /* skip ',' */
  }
}

static void
storeWindow2Disk(WINDOW *w)
{
  int fd;
  char file[BUFFSIZE];
	char *hdp;

  bzero(file, BUFFSIZE);
	hdp = getenv("HOME");
  sprintf(file, "%s/%s/%s", hdp, WINDOW_DIR, w->name);
  if ((fd = open(file, O_CREAT|O_WRONLY, 0644)) == -1) ERR;
  if (write(fd, &w->num, sizeof(int)) == -1) ERR;
  if (write(fd, w->p, w->num * sizeof(VT)) == -1) ERR;
  if (close(fd) == -1) ERR;
}

static void
storeWindow2Memory(WINDOW *w)
{
  METAW *p;

  for (p = &HeadMetaw; p->next != NULL; p = p->next) ;
  if ((p->next = calloc(1, sizeof(METAW))) == NULL) ERR;
  p->next->w = w;
}

static WINDOW *
getWinInfo(char query[])
{
  int o; /* offset */
  int i;
  char *p;
  WINDOW *w;

  /* Init */
  if ((w = calloc(1, sizeof(WINDOW))) == NULL) ERR;

  /* Getting name */
  o = skipCreate(query);
  for (p = &query[o], i = 0; *p != ' '; ) 
    w->name[i++] = *p++;
  o += i;

  /* Count the number of objects */
  if ((w->num = cntNbVal(o, query)) == -1) {
    free(w);
    return NULL;
  }

  /* Allocate area for objects */
  if ((w->p = calloc(w->num, sizeof(VT))) == NULL) ERR;

  /* Acquire values */
  getvt(w, query);

  /* Store Window Information on Disk */
  storeWindow2Disk(w);

  /* Store Window Information on Memory */
  storeWindow2Memory(w);

  return w;
}

PARSE_MSG
execCreateWindow(char query[])
{
  WINDOW *w;

  w = getWinInfo(query);
  if (w == NULL) 
    return CANNOT_CREATE_WINDOW;

  return PARSE_OK;
}

/****************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern PARSE_MSG
createWindow(char query[])
{
  PARSE_MSG pmsg;

  pmsg = execCreateWindow(query);

  return pmsg;
}
