#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include "dataDir.h"
#include "schemaDir.h"
#include <ctype.h>

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _LOCK_MODE_H
#define _LOCK_MODE_H
#include "lockMode.h"
#endif

#ifndef _TRANS_INFO_H
#define _TRANS_INFO_H
#include "transInfo.h"
#endif

/****************************************************************
 *
 * Declarations
 *
 ****************************************************************/
extern void logInsert(PERSISTENT_OBJ *persistP);
extern FROM_SCHEMA getFromSchema(const char query[]);
extern PERSISTENT_OBJ *allocPrstDlteObj(const char schemaName[], const int tplid);

/****************************************************************
 *
 * Global variables
 *
 ****************************************************************/
extern SCHEMA *getSchema(const char schemaName[]);
extern SCHEMA HeadSchema;

/****************************************************************
 *
 * Functions
 *
 ****************************************************************/

static int
getDeleteTplid(const char query[])
{
  int l, r; /* left & right of number string */
  int i;
  char numbuf[BUFFSIZE];

  for (i = 0; i < QUERY_BUFFSIZE; i++) {
    if ((query[i] == 'i') && (strncmp(&query[i], "id", strlen("id")) == 0)) {
      i += strlen("id");
      break;
    }
  }
  assert(i != QUERY_BUFFSIZE);

  for (; isspace(query[i]); i++) ;
  for (; i < QUERY_BUFFSIZE; i++) {
    if (query[i] == '=') {
      i += strlen("=");
      break;
    }
  }
  assert(i != QUERY_BUFFSIZE);

  for (; isspace(query[i]); i++) ;
  l = i;

  for (; isdigit(query[i]); i++) ;
  r = i;

  bzero(numbuf, BUFFSIZE);
  strncpy(numbuf, &query[l], r - l);

  return atoi(numbuf);
}

/****************************************************************
 *
 * Public
 *
 ****************************************************************/
extern void
initGarbageOfSchema(SCHEMA *schemaP)
{
  int fd;
  int n;
  char file[BUFFSIZE];
	char *hdp;

  bzero(file, BUFFSIZE);
	hdp = getenv("HOME");
  sprintf(file, "%s/%s/%s/garbage", hdp, DATA_DIR, schemaP->schemaName);
  if ((fd = open(file, O_RDONLY)) == -1) ERR;
  if ((n = lseek(fd, 0, SEEK_END)) == -1) ERR;
  else if (n == 0) {
    if (close(fd) == -1) ERR;
    return;
  }
  if ((schemaP->garbageP = calloc(n, sizeof(char))) == NULL) ERR;
  if (lseek(fd, 0, SEEK_SET)) ERR;
  if (read(fd, schemaP->garbageP, n) == -1) ERR;
  if (close(fd) == -1) ERR;
}

extern void
execDelete(const int tplid, SCHEMA *schemaP)
{
	int i;
  int fd, maxGarbage;
  char val = 1;
  char file[BUFFSIZE];

  /*
	 *
   * DISK:     "X byte on garbage file" means that tuple X is garbage
	 *
   */
  bzero(file, BUFFSIZE);
  sprintf(file, "%s/%s/%s/garbage", getenv("HOME"), DATA_DIR, schemaP->schemaName);
  if ((fd = open(file, O_CREAT|O_WRONLY, 0644)) == -1) ERR;
  if (lseek(fd, tplid * sizeof(char), SEEK_SET) == -1) ERR;
  if (write(fd, &val, sizeof(char)) == -1) ERR;
  if ((maxGarbage = lseek(fd, 0, SEEK_END)) == -1) ERR;
  if (close(fd) == -1) ERR;
	/*
	 * Disk with sensor 
	 */
  bzero(file, BUFFSIZE);
  sprintf(file, "rm -fr %s/%s/%s/sensor", getenv("HOME"), DATA_DIR, schemaP->schemaName);
	system(file);

  /*
	 *
   * MEMORY:   "garbageP[X] == 1" means that tuple X is garbage
	 *
   */
  if (maxGarbage == 0) {
    assert(tplid != 0);
    if ((schemaP->garbageP = calloc(schemaP->numOfObj, sizeof(char))) == NULL) ERR;
  }
  else if (schemaP->garbageP == NULL) {
    if ((schemaP->garbageP = calloc(maxGarbage, sizeof(char))) == NULL) ERR;
  }
  else if (maxGarbage < tplid) {
    schemaP->garbageP = realloc(schemaP->garbageP, tplid * sizeof(char));
  }
  schemaP->garbageP[tplid] = 1; 	/* Dirty flag */

	/* Access Path */
	for (i = 0; i < schemaP->numOfAttr; i++) {
		if (schemaP->attr[i].attrType == SENSOR_SEGMENT_DOUBLE) {
			N;
			schemaP->attr[i].p = NULL;
		}
	}

	
}

extern PARSE_MSG
deleteFrom(const char query[])
{
  int tid;
  SCHEMA *schemaP;
  FROM_SCHEMA head;

  head = getFromSchema(query);
  assert(head.next != NULL);

  if ((schemaP = getSchema(head.next->schemaName)) == NULL) 
    return TABLE_NOT_EXIST;
    
  if (pthread_rwlock_wrlock(&schemaP->rwlock) != 0) ERR;
  if ((tid = getDeleteTplid(query)) >= schemaP->numOfObj)
    return TUPLE_NOT_EXIST;

  execDelete(tid, schemaP);
  if (pthread_rwlock_unlock(&schemaP->rwlock) != 0) ERR;

  return PARSE_OK;
}
