#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif


/****************************************************************
 *
 * Functions
 *
 ***************************************************************/
static ANSWER
exeor(ANSWER answer, const CONDITION *cndP)
{
  int attrid;
  int bo;
  int iv;
  double dv;
  TUPLE *pAnswerTuple;
  ATTR_TYPE attrType;
  TUPLE_LIST *pAndorTupleList;
  SENSOR_SEGMENT *ssp;
  SENSOR *sp, *tmp;

  pAndorTupleList = &answer.headAndorTupleList;
  while (pAndorTupleList->next != NULL) 
    pAndorTupleList = pAndorTupleList->next;

  for (bo = 0, attrid = 0; attrid < cndP->u.binary.aid; attrid++) 
    bo += answer.attr[attrid].sizOfAttr;

  attrType = answer.attr[cndP->u.binary.aid].attrType;
  for (pAnswerTuple = answer.headTuple.next; pAnswerTuple != NULL; pAnswerTuple = pAnswerTuple->next) {
    switch (attrType) {
    case INT:    
      memcpy(&iv, pAnswerTuple->obj + bo, sizeof(int));       
      if ((cndP->u.binary.operand == EQUAL && iv == atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == NOT_EQUAL && iv != atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == LESS && iv < atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == LESS_EQUAL && iv <= atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == GREATER && iv > atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == GREATER_EQUAL && iv >= atoi(cndP->u.binary.rightText))) {
        pAnswerTuple->selected = TRUE;
        if ((pAndorTupleList->next = calloc(1, sizeof(TUPLE_LIST))) == NULL) ERR;
        pAndorTupleList = pAndorTupleList->next;
        pAndorTupleList->pTuple = pAnswerTuple;
      }
      break;

    case DOUBLE: 
      memcpy(&dv, pAnswerTuple->obj + bo, sizeof(double)); 
      if ((cndP->u.binary.operand == EQUAL && dv == atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == NOT_EQUAL && dv != atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == LESS && dv < atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == LESS_EQUAL && dv <= atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == GREATER && dv > atoi(cndP->u.binary.rightText)) ||
          (cndP->u.binary.operand == GREATER_EQUAL && dv >= atoi(cndP->u.binary.rightText))) {
        pAnswerTuple->selected = TRUE;
        if ((pAndorTupleList->next = calloc(1, sizeof(TUPLE_LIST))) == NULL) ERR;
        pAndorTupleList = pAndorTupleList->next;
        pAndorTupleList->pTuple = pAnswerTuple;
      }
      break;

    case SENSOR_SEGMENT_DOUBLE: 
      pAnswerTuple->selected = TRUE;
      ssp = (SENSOR_SEGMENT *)(pAnswerTuple->obj + bo);
      for (sp = &ssp->next->headSensor; sp->next != NULL;) {
        if (sp->next->sdobj.v[cndP->u.binary.said] != atof(cndP->u.binary.rightText)) {
          tmp = sp->next;
          sp->next = sp->next->next;
          free(tmp);
        }
        else {
          sp = sp->next;
        }
      }
      break;

    case TEXT:
      /* No implementation */
      break;

      default: 
      ERR;
      break;
    }
  }

  return answer;
}

static ANSWER
exeand(ANSWER answer, const CONDITION *cndP)
{
  int attrid;
  int bo;    /* Byte Offset */
  int iv;    /* Interger Value */
  double dv; /* Double Value */
  ATTR_TYPE attrType;
  TUPLE_LIST *pMarkAndorTupleList;
  SENSOR_SEGMENT *ssp;
  SENSOR *sp, *tmp;

  attrType = answer.attr[cndP->u.binary.aid].attrType;
  for (pMarkAndorTupleList = answer.headAndorTupleList.next;
       pMarkAndorTupleList != NULL;
       pMarkAndorTupleList = pMarkAndorTupleList->next) {
    if (pMarkAndorTupleList->pTuple->selected == TRUE) {
      if (pMarkAndorTupleList->pTuple->certified == FALSE) {
        for (bo = 0, attrid = 0; attrid < cndP->u.binary.aid; attrid++) {
          bo += answer.attr[attrid].sizOfAttr;
        }
        switch (attrType) {
        case INT:    
          memcpy(&iv, pMarkAndorTupleList->pTuple->obj + bo, sizeof(int)); 
          if ((cndP->u.binary.operand == EQUAL && iv != atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == NOT_EQUAL && iv == atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == LESS && iv >= atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == LESS_EQUAL && iv > atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == GREATER && iv <= atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == GREATER_EQUAL && iv < atoi(cndP->u.binary.rightText))) {
            pMarkAndorTupleList->pTuple->selected = FALSE;
          }
          break;

        case DOUBLE: 
          memcpy(&dv, pMarkAndorTupleList->pTuple->obj + bo, sizeof(double)); 
          if ((cndP->u.binary.operand == EQUAL && dv != atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == NOT_EQUAL && dv == atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == LESS && dv >= atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == LESS_EQUAL && dv > atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == GREATER && dv <= atoi(cndP->u.binary.rightText)) ||
              (cndP->u.binary.operand == GREATER_EQUAL && dv < atoi(cndP->u.binary.rightText))) {
            pMarkAndorTupleList->pTuple->selected = FALSE;
          }
          break;

        case SENSOR_SEGMENT_DOUBLE: 
          ssp = (SENSOR_SEGMENT *)(pMarkAndorTupleList->pTuple->obj + bo);
          for (sp = &ssp->next->headSensor; sp->next != NULL;) {
            if (sp->next->sdobj.v[cndP->u.binary.said] != atof(cndP->u.binary.rightText)) {
              tmp = sp->next;
              sp->next = sp->next->next;
              free(tmp);
            }
            else {
              sp = sp->next;
            }
          }
          break;

        default: 
          ERR;
          break;
        }
      }
    }
  }

  return answer;
}

extern ANSWER
execSelection(const CONDITION *cndP, ANSWER answer)
{
  TUPLE_LIST *trash;

  if (cndP->andor == OR) {
    while (answer.headAndorTupleList.next != NULL) {
      trash = answer.headAndorTupleList.next;
      if (trash->pTuple->selected == TRUE) {
        trash->pTuple->certified = TRUE;
      }
      answer.headAndorTupleList.next = answer.headAndorTupleList.next->next;
      free(trash);
    }
  }

  switch (cndP->andor) {
  case OR:  
    answer = exeor(answer, cndP);  
    break;
  case AND: 
    answer = exeand(answer, cndP); 
    break;
  }

  return answer;
}
