#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#define DELAY (30) /* 10 seconds */
#define MEGA (1000 * 1000) 
#include "buffsize.h"

static long long
getGap(long long numOfCli, long long period)
{
  long long gap;

  gap = (long long)period / (long long)numOfCli;

  return gap;
}

static long long
getLlFrom(void)
{
  struct timeval now;
  long long llFrom;

  gettimeofday(&now, NULL);
  llFrom = (long long)(now.tv_sec + DELAY) * (long long)MEGA;

  return llFrom;
}

static void
invokeMonitor(const int id, const long long gap, long long llFrom)
{
  char filename[BUFFSIZE];
  char command[BUFFSIZE];
  FILE *fp;
  
  llFrom += gap * (long long)id;
  bzero(filename, BUFFSIZE);
  sprintf(filename, "/tmp/%d", id);
  fp = fopen(filename, "w");
  fprintf(fp, "run m during 10s from %lld\n", llFrom);
  fprintf(fp, "exit");
  fclose(fp);

  bzero(command, BUFFSIZE);
  sprintf(command, "./kclient %s", filename);
  system(command);
  exit(0);
}

extern int 
main(int argc, char *argv[])
{
  long numOfCli;
  long period;
  long long idcli;
  long long llNumOfCli;
  long long llFrom;
  long long gap;
  long long llPeriod;
  pid_t pid;

  if (argc != 3) {
    printf("Usage: program period(ms) numOfClients \n");
  }
  else {
    period = atol(argv[1]);
    numOfCli = atol(argv[2]);
    llNumOfCli = (long long)numOfCli;    
    llPeriod = (long long)period * 1000;
  }
  
  gap = getGap(llNumOfCli, llPeriod);
  llFrom = getLlFrom();

  for (idcli = 0; idcli < llNumOfCli; idcli ++) {
    pid = fork();
    if (pid == 0) {
      invokeMonitor(idcli, gap, llFrom);
    }
  }
  
  return 0;
}
