#include "common.h"
#include "libWrapper.h"

#ifndef _EXTERN_H
#include "extern.h"
#define _EXTERN_H
#endif

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

/****************************************************************
 *
 * Public function
 *
 ****************************************************************/
extern ANSWER
latestInExecSelection(const CONDITION *pCondition, ANSWER answer)
{
  int attrid;
  int byteOffset;
  TUPLE *pAnswerTuple;
  SENSOR_SEGMENT *pSensorSegment;
  SENSOR_SEGMENT *pNewSensorSegment;

  for (pAnswerTuple = answer.headTuple.next;
       pAnswerTuple != NULL;
       pAnswerTuple = pAnswerTuple->next) {
    pAnswerTuple->selected = TRUE;
    for (byteOffset = 0, attrid = 0; 
         attrid < pCondition->u.latest.attrid; 
         byteOffset += answer.attr[attrid].sizOfAttr, attrid ++) 
      ;
    
    switch (answer.attr[attrid].attrType) {
    case SENSOR_SEGMENT_DOUBLE: 
      pSensorSegment = (SENSOR_SEGMENT *)(pAnswerTuple->obj + byteOffset);
      if ((pNewSensorSegment = calloc(1, sizeof(SENSOR_SEGMENT))) == NULL) ERR;
      if ((pNewSensorSegment->headSensor.next = calloc(1, sizeof(SENSOR))) == NULL) ERR;
      if (pthread_rwlock_wrlock(&pAnswerTuple->rwlock) != 0) ERR;
      memcpy(pNewSensorSegment->headSensor.next, pSensorSegment->next->pLastSensor, sizeof(SENSOR));      
      pNewSensorSegment->pLastSensor = pNewSensorSegment->headSensor.next;
      if (pthread_rwlock_unlock(&pAnswerTuple->rwlock) != 0) ERR;
      pSensorSegment->next = pNewSensorSegment;
      break;
    default: 
      ERR;
      break;
    }
  }

  return answer;
}
