#include "common.h"
#include <stdarg.h>
#include <dirent.h>
#ifndef CTRL
#include <sys/ioctl.h>
#endif /* CTRL */
#ifndef BUFFSIZE
#include "buffsize.h"
#endif 
#include <errno.h>

/***************************************************************
 *
 * Gloval Varible
 *
 ***************************************************************/
pthread_mutex_t LkDiffLog;

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern void
diff(struct timeval end, struct timeval begin, int nb)
{
  printf("%d: %ld\n", nb, (end.tv_sec - begin.tv_sec)*1000*1000 + (end.tv_usec - begin.tv_usec));
}

extern void
difflog(struct timeval end, struct timeval begin, int tid)
{
  FILE *fp;
  char filename[BUFFSIZE];

  bzero(filename, BUFFSIZE);
  sprintf(filename, "/tmp/log/%d", tid);
  if ((fp = fopen(filename, "a")) == NULL) ERR;
  fprintf(fp, "%ld\n", (end.tv_sec - begin.tv_sec) * 1000000 + (end.tv_usec - begin.tv_usec));
  fclose(fp);
}

extern void
sendback(const int sockfd, const void *ptr, const int size, const int flag)
{
  int ack;

  if (send(sockfd, ptr, size, flag) == -1) ERR;
  if (recv(sockfd, &ack, sizeof(int), 0) == -1) ERR;
}

extern void
recvback(const int sockfd, void *ptr, const int size, const int flag)
{
  int ack;

  if (recv(sockfd, ptr, size, flag) == -1) ERR;
  if (send(sockfd, &ack, sizeof(int), 0) == -1) ERR;
}
