#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

/****************************************************************
 *
 * Function
 *
 ***************************************************************/
extern void
rdlockSchemaList(const SCHEMA_LIST headSchemaList)
{
  SCHEMA_LIST *pSchemaList;

  for (pSchemaList = headSchemaList.next;
       pSchemaList != NULL;
       pSchemaList = pSchemaList->next) {
    if (pthread_rwlock_rdlock(&(pSchemaList->pSchema->rwlock)) != 0) {ERR;}
  }
}

extern void
wrlockSchemaList(const SCHEMA_LIST headSchemaList)
{
  SCHEMA_LIST *pSchemaList;

  for (pSchemaList = headSchemaList.next;
       pSchemaList != NULL;
       pSchemaList = pSchemaList->next) {
    if (pthread_rwlock_wrlock(&(pSchemaList->pSchema->rwlock)) != 0) {ERR;}
  }
}

extern void
unlockSchemaList(SCHEMA_LIST headSchemaList)
{
  SCHEMA_LIST *pSchemaList;

  for (pSchemaList = headSchemaList.next;
       pSchemaList != NULL;
       pSchemaList = pSchemaList->next) {
    if (pthread_rwlock_unlock(&(pSchemaList->pSchema->rwlock)) != 0) {ERR;}
  }
  
  while (headSchemaList.next != NULL) {
    pSchemaList = headSchemaList.next;
    headSchemaList.next = headSchemaList.next->next;
    free(pSchemaList);
  }
}

/*
extern void
rdlockAnswerTuple(const TUPLE headTuple)
{
  TUPLE *pTuple;


  for (pTuple = headTuple.next;
       pTuple != NULL;
       pTuple = pTuple->next) {
    if (pthread_rwlock_rdlock(&(pTuple->targetTuple->rwlock)) != 0) {ERR;}
  }
}

extern void
wrlockAnswerTuple(const TUPLE headTuple)
{
  TUPLE *pTuple;

  for (pTuple = headTuple.next;
       pTuple != NULL;
       pTuple = pTuple->next) {
    if (pthread_rwlock_wrlock(&(pTuple->targetTuple->rwlock)) != 0) {ERR;}
  }
}

extern void
unlockAnswerTuple(const TUPLE headTuple)
{
  TUPLE *pTuple;

  for (pTuple = headTuple.next;
       pTuple != NULL;
       pTuple = pTuple->next) {
    if (pthread_rwlock_unlock(&(pTuple->targetTuple->rwlock)) != 0) {ERR;}
  }

}
*/
