#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

extern void *kalloc(const int numOfObj, const int sizOfObj);

/*******************************************************
 *
 * Private Function
 *
 *******************************************************/
static void
releaseTupleList(TUPLE_LIST *headP)
{
  TUPLE_LIST *p;

  while (headP->next != NULL) {
    p = headP->next;
    headP->next = headP->next->next;
    free(p);
  }
}

static void
releaseSensorForServer(SENSOR *headP)
{
  SENSOR *p;

  while (headP->next != NULL) {
    p = headP->next;
    headP->next = headP->next->next;
    free(p);
  }
}

static void
releaseSensorSegmentForServer(SENSOR_SEGMENT *headP)
{
  SENSOR_SEGMENT *p;

  while (headP->next != NULL) {
    p = headP->next;
    headP->next = headP->next->next;
    releaseSensorForServer(&p->headSensor);
    free(p);
  }
}

/*******************************************************
 *
 * Public Function
 *
 *******************************************************/
extern void
releaseBaseTupleForServer(TUPLE headTuple, const ATTR attr[], const int numOfAttr)
{
  int attrid;
  int byteOffset;
  TUPLE *trash;
  SENSOR_SEGMENT *pSensorSegment;

  while (headTuple.next != NULL) {
    trash = headTuple.next;
    headTuple.next = headTuple.next->next;
    for (byteOffset = 0, attrid = 0; 
         attrid < numOfAttr; 
         byteOffset += attr[attrid].sizOfAttr, attrid ++) {
      switch (attr[attrid].attrType) {
      case SENSOR_SEGMENT_DOUBLE:
        pSensorSegment = (SENSOR_SEGMENT *)(trash->obj + byteOffset);
        releaseSensorSegmentForServer(pSensorSegment);
        break;
      default: 
        break;
      }
    }
    free(trash->obj);
    free(trash);
  }
}

extern void
releaseTempTuple(TUPLE headTuple)
{
  TUPLE *trash;

  while (headTuple.next != NULL) {
    trash = headTuple.next;
    headTuple.next = headTuple.next->next;
    free(trash->obj);
    free(trash);
  }
}

extern void
releaseAnswerForServer(ANSWER answer)
{
  releaseTupleList(&(answer.headAndorTupleList));
  releaseBaseTupleForServer(answer.headTuple, answer.attr, answer.numOfAttr);
  free(answer.attr);
}
