#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include "mega.h"
#include <ctype.h>

/*
 * #include </usr/src/lib/libpthread/thread/kraft_sched.h>
 * #include </usr/src/lib/libpthread/thread/kraft_extern.h>
 */
#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _MONITOR_INFO_H
#define _MONITOR_INFO_H
#include "monitorInfo.h"
#endif

#define STALE_LOGDIR "/tmp/STALE_LOG_DIR/"
#define GAP_LOGDIR "/tmp/GAP_LOG_DIR/"

/****************************************************************
 *
 * Declarations
 *
 ***************************************************************/
extern int thisIsNumber(const char c);
extern void sendMessage(const int acptfd, TYPE_OF_ANSWER typeOfAnswer);
extern void sendAnswerListToClient(int acptfd, ANSWER answer);
extern void releaseAnswerForServer(ANSWER answer);
extern ANSWER selectFrom(const char query[]);

/****************************************************************
 *
 * Global variable 
 *
 ***************************************************************/
static MONITOR_RUN HeadMonitorRun;
static MONITOR_RUN *TailMonitorRunP;

static pthread_mutex_t MutexForMonitorRun;
static pthread_mutex_t MutexForCountStaleLog;
static pthread_mutex_t MutexForCountBudgetLog;
static pthread_mutex_t MutexForCountGap;

static int CountGap;
static int CountStaleLog;
static int CountBudgetLog;

/****************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static void
registerNewMonitorQuery(const char monitorName[], const struct timeval period, const char queryContent[])
{
  int fd;
  char fileName[BUFFSIZE];
	char *hdp;
  MONITOR_QUERY monitorQuery;
  const long long LLMEGA = 1000 * 1000;

  bzero(fileName, BUFFSIZE);
	hdp = getenv("HOME");
  sprintf(fileName, "%s/%s/%s", hdp, MONITOR_DIR_NAME, monitorName);
  bzero(&monitorQuery, sizeof(MONITOR_QUERY));
  strcpy(monitorQuery.monitorName, monitorName);
  monitorQuery.period = period;
  monitorQuery.llp = (((long long)period.tv_sec) * LLMEGA + ((long long)period.tv_usec));
  strcpy(monitorQuery.query, queryContent);
  if ((fd = open(fileName, O_WRONLY|O_CREAT|O_TRUNC, 0644)) == -1) ERR;
  if (write(fd, &monitorQuery, sizeof(MONITOR_QUERY)) == -1) ERR;
  if (close(fd) == -1) ERR;
}  

static int
getDuration(int qid, const char query[], struct timeval *duration)
{
  int l, r;
  int fracSearchid;
  int numberInteger;
  int numberFraction;  
  char measure[BUFFSIZE];
  char numberBuff[BUFFSIZE];

  for (;query[qid] == ' '; qid++) ;
  l = qid;
  for (;((query[qid] != ' ') && (thisIsNumber(query[qid]))); qid++) ; 
  r = qid;

  for (fracSearchid = l; fracSearchid < r; fracSearchid++) {
    if (query[fracSearchid] ==  '.') {
      bzero(numberBuff, BUFFSIZE);
      strncpy(numberBuff, &query[l], fracSearchid- l);
      numberInteger = atoi(numberBuff);

      bzero(numberBuff, BUFFSIZE);
      strncpy(numberBuff, &query[fracSearchid+1], r);
      numberFraction = atoi(numberBuff);
      break;
    }
  }
  if (fracSearchid == r) {
    bzero(numberBuff, BUFFSIZE);
    strncpy(numberBuff, &query[l], r - l);
    numberInteger = atoi(numberBuff);
    numberFraction = 0;
  }

  for (;query[qid] == ' '; qid++) ; 
  l  = qid;  
  for (;((query[qid] != ' ') && (query[qid] != '\n') && (query[qid] != '\0')); qid++) ; 
  r = qid;
  bzero(measure, BUFFSIZE);  
  strncpy(measure, &query[l], r - l);
  if (strncmp(measure, "s", strlen("s")) == 0) {
    duration->tv_sec = ((long)numberInteger);
    duration->tv_usec = ((long)(numberFraction * (1000 * 1000 / 10)));
  }
  else if (strncmp(measure, "ms", strlen("ms")) == 0) {
    duration->tv_sec = 0;
    duration->tv_usec = ((long)(numberInteger * 1000)) + numberFraction * (1000 / 10);
  }
  else {
    ERR;
  }

  return qid;
}

static int
getMonitorNameForCreate(const char query[], char monitorName[])
{
  int qid;
  int left;
  int right;

  for (qid = 0;
       qid < QUERY_BUFFSIZE;
       qid++) {
    if ((query[qid] == 'c') && (strncmp(&query[qid], "create", strlen("create")) == 0)) {
      qid += strlen("create");
      break;
    }
  }

  for (qid = 0;
       qid < QUERY_BUFFSIZE;
       qid++) {
    if ((query[qid] == 'm') && (strncmp(&query[qid], "monitor", strlen("monitor")) == 0)) {
      qid += strlen("monitor");
      break;
    }
  }

  for (;query[qid] == ' '; qid++) ; left  = qid;
  for (;query[qid] != ' '; qid++) ; right = qid;
  bzero(monitorName, BUFFSIZE);
  strncpy(monitorName, &query[left], right-left);
  
  for (; qid < QUERY_BUFFSIZE; qid++) {
    if ((query[qid] == 'p') && (strncmp(&query[qid], "period", strlen("period")) == 0)) {
      qid += strlen("period");
      break;
    }
  }

  return qid;
}

static void
getQueryContent(int qid, const char query[], char queryContent[])
{
  int left;
  int right;

  for (;qid < QUERY_BUFFSIZE; qid++) {
    if ((query[qid] == 'a') && (strncmp(&query[qid], "as", strlen("as")) == 0)) {
      qid += strlen("as");
      break;
    }
  }
  if (qid == QUERY_BUFFSIZE) {
    printf("You must specify <as> before monitoring query\n");
    printf("e.g: create monitor M period X ms as select * from S where latest S.S");
  }

  for (;query[qid] == ' '; qid++) ; left  = qid;
  for (;((query[qid] != '\n') && (query[qid] != '\0')); qid++) ; right = qid;
  if (right - left >= BUFFSIZE) {
    printf("monitor query is too long at getQuetyContent: %d\n", right-left);
    exit(1);
  }
  bzero(queryContent, BUFFSIZE);  
  strncpy(queryContent, &query[left], right-left);
}

static void
execCreateMonitor(const char query[])
{
  int qid;
  char monitorName[BUFFSIZE];
  char queryContent[BUFFSIZE];
  struct timeval period;

  qid = getMonitorNameForCreate(query, monitorName);
  qid = getDuration(qid, query, &period);
  L(period.tv_sec);
  L(period.tv_usec);
  getQueryContent(qid, query, queryContent);
  registerNewMonitorQuery(monitorName, period, queryContent);
}

static void
initLock(void)
{
  if (pthread_mutex_init(&MutexForMonitorRun, NULL) != 0) ERR;
}

static void
initRunMonitor(void)
{
  bzero(&HeadMonitorRun, sizeof(MONITOR_RUN));
  TailMonitorRunP = &HeadMonitorRun;
}

static int
getMonitorNameForRun(const char query[], char monitorName[])
{
  int qid;
  int left;
  int right;

  for (qid = 0; qid < QUERY_BUFFSIZE; qid++) {
    if ((query[qid] == 'r') && (strncmp(&query[qid], "run", strlen("run")) == 0)) {
      qid += strlen("run");
      break;
    }
  }
  for (;query[qid] == ' '; qid++) ; left  = qid;
  for (;query[qid] != ' '; qid++) ; right = qid;
  bzero(monitorName, BUFFSIZE);
  strncpy(monitorName, &query[left], right-left);

  for (; qid < QUERY_BUFFSIZE; qid++) {
    if ((query[qid] == 'd') && (strncmp(&query[qid], "duration", strlen("duration")) == 0)) {
      qid += strlen("duration");
      break;
    }
    if ((query[qid] == 'd') && (strncmp(&query[qid], "during", strlen("during")) == 0)) {
      qid += strlen("during");
      break;
    }
  }

  return qid;
}

static MONITOR_QUERY
getMonitorQuery(const char monitorName[])
{
  int fd;
  char fileName[BUFFSIZE];
  MONITOR_QUERY monitorQuery;

  bzero(fileName, BUFFSIZE);
  sprintf(fileName, "%s/%s/%s", getenv("HOME"), MONITOR_DIR_NAME, monitorName);
  if ((fd = open(fileName, O_RDONLY)) == -1) ERR;
  if (read(fd, &monitorQuery, sizeof(MONITOR_QUERY)) == -1) ERR;
  if (close(fd) == -1) ERR;

  return monitorQuery;
}

static MONITOR_RUN *
getMonitorRun(const int clientfd, const char query[])
{
  int qid;
  MONITOR_RUN *mrP;

  if ((mrP = calloc(1, sizeof(MONITOR_RUN))) == NULL) ERR;
  mrP->clientfd = clientfd;

  qid = getMonitorNameForRun(query, mrP->mq.monitorName);
  qid = getDuration(qid, query, &mrP->duration);
  mrP->lld = (long long)(mrP->duration.tv_sec * 1000 * 1000 + mrP->duration.tv_usec);
  
  mrP->mq = getMonitorQuery(mrP->mq.monitorName);
  mrP->nbrun = mrP->lld / mrP->mq.llp;
  //bzero(&(monitorRunP->headAnswerListObj), sizeof(ANSWER_LIST_OBJ));
  //monitorRunP->tailAnswerListObjP = &(monitorRunP->headAnswerListObj);

  return mrP;
}

static void
invokeMyMonitorRun(MONITOR_RUN *newMonitorRunP)
{
  if (pthread_mutex_lock(&MutexForMonitorRun) != 0) ERR;
  TailMonitorRunP->next = newMonitorRunP;
  TailMonitorRunP = TailMonitorRunP->next;
  if (pthread_mutex_unlock(&MutexForMonitorRun) != 0) ERR;
}

static void
revokeMyMonitorRun(MONITOR_RUN *myMonitorRunP)
{
  MONITOR_RUN *monitorRunP;

  if (pthread_mutex_lock(&MutexForMonitorRun) != 0) ERR;
  if (myMonitorRunP->next == NULL) {
    for (monitorRunP = &HeadMonitorRun;
         monitorRunP->next != myMonitorRunP;
         monitorRunP = monitorRunP->next) ;
    monitorRunP->next = NULL;
    TailMonitorRunP = monitorRunP;
  }
  else {
    for (monitorRunP = &HeadMonitorRun;
         monitorRunP->next != NULL;
         monitorRunP = monitorRunP->next) {
      if (myMonitorRunP == monitorRunP->next) {
        monitorRunP->next = monitorRunP->next->next;
        break;
      }
    }
  }
  if (pthread_mutex_unlock(&MutexForMonitorRun) != 0) ERR;
  sendMessage(myMonitorRunP->clientfd, ANSWER_FINISH_MONITOR_RUN);
  free(myMonitorRunP);
}

static void
execAnswerSend(MONITOR_RUN *monitorRunP, ANSWER answer)
{
  sendMessage(monitorRunP->clientfd, ANSWER_RELATION);
  sendAnswerListToClient(monitorRunP->clientfd, answer); 
  releaseAnswerForServer(answer);  
}

static void
onceExecMonitorRun(MONITOR_RUN *monitorRunP)
{
  ANSWER answer;

  answer = selectFrom(monitorRunP->mq.query); 
  execAnswerSend(monitorRunP, answer);
}

static void
waitPeriod(MONITOR_RUN *mrP)
{
  usleep(mrP->mq.llp);
}

static void
execMonitorRun(MONITOR_RUN *mrP)
{
  for (; mrP->nbrun > 0; mrP->nbrun--) {
    waitPeriod(mrP);
    onceExecMonitorRun(mrP);
  }
  revokeMyMonitorRun(mrP);
}

static void
initForMeasurement(void)
{
  char comm[BUFFSIZE];

  CountStaleLog = 0;
  CountGap = 0;
  CountBudgetLog = 0;
  if (pthread_mutex_init(&MutexForCountStaleLog, NULL) != 0) ERR;
  if (pthread_mutex_init(&MutexForCountBudgetLog, NULL) != 0) ERR;
  if (pthread_mutex_init(&MutexForCountGap, NULL) != 0) ERR;
  
  bzero(comm, BUFFSIZE);
  sprintf(comm, "rm -fr  /tmp/STALE_LOG_DIR");
  system(comm);
  bzero(comm, BUFFSIZE);
  sprintf(comm, "mkdir -p /tmp/STALE_LOG_DIR");
  system(comm);

  bzero(comm, BUFFSIZE);
  sprintf(comm, "rm -fr  /tmp/BUDGET_LOG_DIR");
  system(comm);
  bzero(comm, BUFFSIZE);
  sprintf(comm, "mkdir -p  /tmp/BUDGET_LOG_DIR");
  system(comm);
}

/****************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern void
initMonitorMgr(void)
{
  initLock();
  initRunMonitor();
#ifdef MEASUREMENT
  initForMeasurement();
#endif
}

extern PARSE_MSG
createMonitor(const char query[])
{
  PARSE_MSG parseMsg = PARSE_OK;

  execCreateMonitor(query);
  return parseMsg;
}

extern void
runMonitor(const int clientfd, const char query[])
{
  MONITOR_RUN *monitorRunP;
  
  N;
  //execCopyRelease(__LINE__, __func__);

  monitorRunP = getMonitorRun(clientfd, query);
  N;
  monitorRunP->pthreadid = pthread_self();
  N;
  invokeMyMonitorRun(monitorRunP);
  //execCopyRelease(__LINE__, __func__);
  N;
  execMonitorRun(monitorRunP);
}

#ifdef USE_ERTF
extern void
execCopyRelease(const int line, const char func[])
{
  pthread_mutex_lock(&MutexForQueueList);
  if ((TailQueueListP->next = calloc(1, sizeof(QUEUE_LIST))) == NULL) ERR;
  TailQueueListP = TailQueueListP->next;
  TailQueueListP->line = line;
  strcpy(TailQueueListP->func, func);
	pthread_copy_release_kraft(TailQueueListP->ary, TailQueueListP->flag, TailQueueListP->cs, TailQueueListP->policy);
  pthread_mutex_unlock(&MutexForQueueList);
}
#endif
