#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#include "buffsize.h"

/****************************************************************
 *
 * Declarations
 *
 ***************************************************************/
extern PARSE_MSG createWindow(char buff[QUERY_BUFFSIZE]);
extern PARSE_MSG createTable(char buff[QUERY_BUFFSIZE]);
extern PARSE_MSG append(const char query[]);
extern PARSE_MSG insert(const char query[]);
extern PARSE_MSG deleteFrom(const char query[]);
extern PARSE_MSG dropTable(const char buff[]);
extern ANSWER selectFrom(const char query[]);
extern PARSE_MSG createMonitor(const char query[]);
extern void sendAnswerListToClient(int acptfd, ANSWER answer);
extern void releaseAnswerForServer(ANSWER answer);
extern void sendSchema(const int acptfd, const char query[]);
extern void sendMonitor(const int acptfd, const char query[]);
extern void sendWindow(const int acptfd, const char query[]);
extern void runMonitor(const int clientfd, const char query[]);

/****************************************************************
 *
 * Gloval variable
 *
 ***************************************************************/
extern SCHEMA HeadSchema;

/****************************************************************
 *
 * Function
 *
 ***************************************************************/
extern void
sendMessage(const int acptfd, TYPE_OF_ANSWER typeOfAnswer)
{
  if (send(acptfd, &typeOfAnswer, sizeof(TYPE_OF_ANSWER), 0) == -1) ERR;
}

static TYPE_OF_OPERATION
getTypeOfOperation(const char query[])
{
  int offset;
  TYPE_OF_OPERATION typeOfOperation = OPERATE_UNACCEPTABLE;

  for (offset = 0; offset < QUERY_BUFFSIZE; offset ++) {
		if (offset == QUERY_BUFFSIZE) 
			return typeOfOperation;
    if (query[offset] != ' ') {
      break;
    }
  }

  if ((query[offset] == 'c') && (strncmp(&query[offset], "create", strlen("create")) == 0)) { 
    offset += strlen("create");
    for (; offset < QUERY_BUFFSIZE; offset ++) {
      if (query[offset] != ' ') {
        break;
      }
    }
    if (offset == QUERY_BUFFSIZE) {
      return typeOfOperation;
    }
    if ((query[offset] == 't') && (strncmp(&query[offset], "table", strlen("table")) == 0)) { 
      typeOfOperation = OPERATE_CREATE_TABLE;      
    }
    else if ((query[offset] == 'i') && (strncmp(&query[offset], "index", strlen("index")) == 0)) { 
      typeOfOperation = OPERATE_CREATE_INDEX;      
    }
    else if ((query[offset] == 'm') && (strncmp(&query[offset], "monitor", strlen("monitor")) == 0)) { 
      typeOfOperation = OPERATE_CREATE_MONITOR;      
    }
    else if ((query[offset] == 'w') && (strncmp(&query[offset], "window", strlen("window")) == 0)) { 
      typeOfOperation = OPERATE_CREATE_WINDOW;
    }
  }
  else if ((query[offset] == 'r') && (strncmp(&query[offset], "run", strlen("run")) == 0)) { 
    typeOfOperation = OPERATE_RUN_MONITOR;      
  }
  else if ((query[offset] == 'c') && (strncmp(&query[offset], "commit", strlen("commit")) == 0)) { 
    typeOfOperation = OPERATE_COMMIT;      
  }
  else if ((query[offset] == 'i') && (strncmp(&query[offset], "insert", strlen("insert")) == 0)) { 
    typeOfOperation = OPERATE_INSERT;      
  }
  else if ((query[offset] == 'a') && (strncmp(&query[offset], "append", strlen("append")) == 0)) { 
    typeOfOperation = OPERATE_APPEND;      
  }
  else if ((query[offset] == 's') && (strncmp(&query[offset], "select", strlen("select")) == 0)) { 
    typeOfOperation = OPERATE_SELECT;      
  }
  else if ((query[offset] == 'd') && (strncmp(&query[offset], "delete", strlen("delete")) == 0)) { 
    typeOfOperation = OPERATE_DELETE;      
  }
  else if ((query[offset] == 'd') && (strncmp(&query[offset], "drop", strlen("drop")) == 0)) { 
    for (; offset < QUERY_BUFFSIZE; offset ++) {
      if (query[offset] != ' ') {
        break;
      }
    }
    if (offset == QUERY_BUFFSIZE) {
      return typeOfOperation;
    }

    if ((query[offset] == 't') && (strncmp(&query[offset], "table", strlen("table")) == 0)) { 
      typeOfOperation = OPERATE_DROP_TABLE;      
    }
    else if ((query[offset] == 'i') && (strncmp(&query[offset], "index", strlen("index")) == 0)) { 
      typeOfOperation = OPERATE_DROP_INDEX;      
    }
  }
  else if ((query[offset] == '\\') && (strncmp(&query[offset], "\\d", strlen("\\d")) == 0)) { 
    typeOfOperation = OPERATE_SHOW_SCHEMA; 
  }
  else if ((query[offset] == '\\') && (strncmp(&query[offset], "\\m", strlen("\\m")) == 0)) { 
    typeOfOperation = OPERATE_SHOW_MONITOR; 
  }
  else if ((query[offset] == '\\') && (strncmp(&query[offset], "\\w", strlen("\\w")) == 0)) { 
    typeOfOperation = OPERATE_SHOW_WINDOW; 
  }

  return typeOfOperation;
}

extern void
atomicExecuteParser(char query[], const int clifd)
{
  ANSWER answer;

  //execCopyRelease(__LINE__, __func__);
  switch (getTypeOfOperation(query)) {
  case OPERATE_APPEND:      
    switch (append(query)) {

    case PARSE_OK: 
      sendMessage(clifd, ANSWER_APPEND);      
      break;

    case AGG4TUPLE_NOT_IMPLEMENTED:
      sendMessage(clifd, ANSWER_AGG4TUPLE_NOT_IMPLEMENTED);
      break;

    case ATTR_NOT_EXIST: 
      sendMessage(clifd, ANSWER_ATTR_NOT_EXIST);        
      break;

    case TABLE_NOT_EXIST: 
      sendMessage(clifd, ANSWER_TABLE_NOT_EXIST);        
      break;

    case TUPLE_NOT_EXIST: 
      sendMessage(clifd, ANSWER_TUPLE_NOT_EXIST);        
      break;

    default:
      ERR;
      break;

    }
    break;

  case OPERATE_SELECT:      
    answer = selectFrom(query); 
    switch (answer.parseMsg) {
    case PARSE_OK:
      sendMessage(clifd, ANSWER_RELATION);
      sendAnswerListToClient(clifd, answer); 
      releaseAnswerForServer(answer);  
      break;

		case FUNCTION_WRONG:
      sendMessage(clifd, ANSWER_FUNCTION_WRONG); 
      break;

    case WRONG_ATTRIBUTE:
      sendMessage(clifd, ANSWER_WRONG_ATTRIBUTE); 
      break;

    case TABLE_NOT_EXIST:  
      sendMessage(clifd, ANSWER_TABLE_NOT_EXIST); 
      break;

    case WRONG_ORDER:
      sendMessage(clifd, ANSWER_WRONG_ORDER); 
      break;

    case WRONG_SCHEMA:
      sendMessage(clifd, ANSWER_WRONG_SCHEMA); 
      break;

    case WRONG_SENSOR_ID:
      sendMessage(clifd, ANSWER_WRONG_SENSOR_ID); 
      break;

    case WRONG_WHERE_CLAUSE:
      sendMessage(clifd, ANSWER_WRONG_WHERE_CLAUSE); 
      break;

    default:
      ERR;
      break;
    }
    break;

  case OPERATE_DELETE:      

    switch (deleteFrom(query)) {

    case PARSE_OK: 
      sendMessage(clifd, ANSWER_DELETE);      
      break;

    case TABLE_NOT_EXIST:
      sendMessage(clifd, ANSWER_TABLE_NOT_EXIST);      
      break;

    case TUPLE_NOT_EXIST:
      sendMessage(clifd, ANSWER_TUPLE_NOT_EXIST);      
      break;

    default:
      ERR;
      break;
    }   
    break;

  case OPERATE_CREATE_MONITOR:      

    switch (createMonitor(query)) {


    case PARSE_OK: 
      sendMessage(clifd, ANSWER_CREATE_MONITOR); 
      break;

    default:
      sendMessage(clifd, ANSWER_PARSE_ERROR);    
      break;
    }
    break;

  case OPERATE_CREATE_WINDOW:      

    switch (createWindow(query)) {

    case WINDOW_EXIST:  
      sendMessage(clifd, ANSWER_WINDOW_EXIST);  
      break;

    case PARSE_OK: 
      sendMessage(clifd, ANSWER_CREATE_WINDOW); 
      break;

    case CANNOT_CREATE_WINDOW: 
      sendMessage(clifd, ANSWER_CANNOT_CREATE_WINDOW); 
      break;

    default:
      ERR;
      break;
    }
    break;

  case OPERATE_CREATE_TABLE:      

    switch (createTable(query)) {

    case TABLE_EXIST:  
      sendMessage(clifd, ANSWER_TABLE_EXIST);  
      break;

    case PARSE_OK: 
      sendMessage(clifd, ANSWER_CREATE_TABLE); 
      break;

    default:
      ERR;
      break;
    }
    break;

  case OPERATE_INSERT:      

    switch (insert(query)) {

    case INSERT_FAILED: 
      sendMessage(clifd, ANSWER_INSERT_FAILED);
      break;

    case PARSE_OK: 
      sendMessage(clifd, ANSWER_INSERT);      
      break;

    case TABLE_NOT_EXIST: 
      sendMessage(clifd, ANSWER_TABLE_NOT_EXIST);        
      break;

    case TUPLE_ID_MUST_BE_ZERO:
      sendMessage(clifd, ANSWER_TUPLE_ID_MUST_BE_ZERO);
      break;

    case TUPLE_ID_WRONG:
      sendMessage(clifd, ANSWER_TUPLE_ID_WRONG);
      break;

    default:
      ERR;
      break;
    }   
    break;

  case OPERATE_SHOW_SCHEMA: 
    sendMessage(clifd, ANSWER_SHOW_SCHEMA); 
    sendSchema(clifd, query);  
    break;

  case OPERATE_SHOW_MONITOR: 
    sendMessage(clifd, ANSWER_SHOW_MONITOR); 
    sendMonitor(clifd, query);  
    break;

  case OPERATE_SHOW_WINDOW: 
    sendMessage(clifd, ANSWER_SHOW_MONITOR); 
    sendWindow(clifd, query);  
    break;

  case OPERATE_RUN_MONITOR:
    runMonitor(clifd, query);
    break;

  case OPERATE_UNACCEPTABLE:
    sendMessage(clifd, ANSWER_UNACCEPTABLE); 
    break;

  default:
    sendMessage(clifd, ANSWER_UNACCEPTABLE); 
    break;
  }
}
