#include "common.h"
#include "libWrapper.h"
#include "buffsize.h"
#include "port.h"
#include "host.h"
#include "dataDir.h"
#include "schemaDir.h"
#include "mmgr.h"
#include "memsize.h"
#include "chkptrlogdir.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _LOG_INFO_H
#define _LOG_INFO_H
#include "logInfo.h"
#endif

#define SENSOR_DIR_NAME "sensor"
#define RELATION_FILE_NAME "relation"
#define SENSOR_OBJECT_FILE_NAME "object"

/****************************************************************
 * 
 * Declaration 
 *
 ***************************************************************/
extern SCHEMA *getSchema(const char schemaName[]);
extern void initPagePtr(SCHEMA *schemaP, const int tupleid);
extern void recvback(const int sockfd, void *ptr, const int size, const int flag);
extern void unlockEntirePage(void);
extern void lockEntirePage(void);
extern void execDelete(const int tplid, SCHEMA *schemaP);
extern void chkpnt(char *memP);

/****************************************************************
 * 
 * Global Variable 
 *
 ***************************************************************/
extern SCHEMA HeadSchema;

/****************************************************************
 *
 * Private function
 *
 ***************************************************************/
static void
redoDelete(LOG_RECORD *lrP)
{
  SCHEMA *schemaP;

  schemaP = getSchema(lrP->u.delete.schemaName);
  execDelete(lrP->u.delete.tplid, schemaP);
}

static void
redoInsert(LOG_RECORD *lrP)
{
  int fd;
  char path[BUFFSIZE];
  /* SCHEMA *schemaP; */

  /*
   * Data
   */
  bzero(path, BUFFSIZE);
  sprintf(path, "%s/%s/%s/relation", getenv("HOME"), DATA_DIR, lrP->u.insert.schemaName);
  if ((fd = open(path, O_WRONLY|O_EXLOCK)) == -1) ERR;
  if (lseek(fd, lrP->u.insert.pi.offset + lrP->u.insert.pi.numOfObj * lrP->u.insert.pi.sizOfObj, SEEK_SET) == -1) ERR;
  if (write(fd, (void *)((unsigned long)lrP + sizeof(LOG_RECORD)), lrP->u.insert.pi.sizOfObj) == -1) ERR;
  if (close(fd) == -1) ERR;

  /*
   * PageInfo
   */
  lrP->u.insert.pi.numOfObj ++;
  if ((fd = open(path, O_WRONLY|O_EXLOCK)) == -1) ERR;
  if (lseek(fd, lrP->u.insert.pi.offset + PAGESIZE - sizeof(PAGEINFO), SEEK_SET) == -1) ERR;
  if (write(fd, &lrP->u.insert.pi, sizeof(PAGEINFO)) == -1) ERR;
  if (close(fd) == -1) ERR;
}

static void
redoAppend(LOG_RECORD *lrP)
{
  int fd, offset, n;
  char path[BUFFSIZE];
  char *dir;
  PAGEINFO pi;

  /* 
   * Initialize
   */
  bzero(path, BUFFSIZE);
  bzero(&pi, sizeof(PAGEINFO));
  sprintf(path, "%s/%s/%s/sensor/%s/%d/object", getenv("HOME"), DATA_DIR, lrP->u.append.schemaName, lrP->u.append.attrName, lrP->u.append.pi.tupleid);

  /*
   * Data
   */
  if ((fd = open(path, O_WRONLY|O_CREAT|O_EXLOCK|O_FSYNC, 0644)) == -1) {
    if (errno != ENOENT) {
      ERR;
    }
    else {
      if ((dir = calloc(strlen(path), sizeof(char))) == NULL) ERR;
      strncpy(dir, path, (strlen(path) - strlen("object")));
      if (mkdir(dir, 0755) == -1) ERR;
      free(dir);
      if ((fd = open(path, O_WRONLY|O_CREAT|O_EXLOCK|O_FSYNC, 0644)) == -1) ERR;
    }
  }
  offset = lrP->u.append.pi.offset + lrP->u.append.pi.numOfObj * lrP->u.append.pi.sizOfObj;

  assert(offset >= 0);
  if (lseek(fd, offset, SEEK_SET) == -1) ERR;
  if (write(fd, &lrP->u.append.obj, lrP->u.append.pi.sizOfObj) == -1) ERR;
  if (close(fd) == -1) ERR;

  /*
   * Set PageInfo
   */
  lrP->u.append.pi.numOfObj++;
  if ((fd = open(path, O_RDONLY|O_SHLOCK)) == -1) ERR;
  if (lseek(fd, lrP->u.append.pi.offset + PAGESIZE - sizeof(PAGEINFO), SEEK_SET) == -1) ERR;
  if ((n = read(fd, &pi, sizeof(PAGEINFO))) == -1) ERR;  
  if (close(fd) == -1) ERR;

  /*
   * Write the PageInfo only when, it does not reduce <numOfObj>
   */
  if (pi.numOfObj < lrP->u.append.pi.numOfObj || n == 0) {
    if ((fd = open(path, O_WRONLY|O_EXLOCK|O_FSYNC, 0644)) == -1) ERR;
    if ((n = lseek(fd, lrP->u.append.pi.offset + PAGESIZE - sizeof(PAGEINFO), SEEK_SET)) == -1) ERR;
    if ((n = write(fd, &lrP->u.append.pi, sizeof(PAGEINFO))) == -1) ERR;
    if (close(fd) == -1) ERR;
  }
}

static void
redo(LOG_RECORD *lrP)
{
  switch (lrP->type) {
  case PERSISTENT_INSERT: 
    redoInsert(lrP); 
    break;
  case PERSISTENT_APPEND: 
    redoAppend(lrP); 
    break;
  case PERSISTENT_DELETE: 
    redoDelete(lrP); 
    break;
  default: 
    D(lrP->type);
    //ERR;
    break;
  }
}

static void
setPagePtr(SCHEMA *schemaP)
{
  int i, n;
  int fd;
  char path[BUFFSIZE];
  char page[PAGESIZE];
  PAGEINFO *piP;

  bzero(path, BUFFSIZE);
  sprintf(path, "%s/%s/%s/relation", getenv("HOME"), DATA_DIR, schemaP->schemaName);
  if ((fd = open(path, O_RDONLY|O_SHLOCK)) == -1) ERR;
  for (schemaP->numOfObj = 0;; schemaP->numOfObj += piP->numOfObj ) {
    if ((n = read(fd, page, PAGESIZE)) == 0) 
      break;
    else if (n < 0) 
      ERR;
    piP = (PAGEINFO *)&page[PAGESIZE - sizeof(PAGEINFO)];
  }
  if (close(fd) == -1) ERR;
  if (schemaP->numOfObj != 0) {
    for (i = 0; i < schemaP->numOfAttr; i ++) {
      if (schemaP->attr[i].attrType == SENSOR_SEGMENT_DOUBLE) {
        if (schemaP->numOfObj != 0) {
          D(schemaP->numOfObj);
          if ((schemaP->attr[i].p = calloc(schemaP->numOfObj, sizeof(PAGEPTR))) == NULL) ERR;
        }
        else {
          if ((schemaP->attr[i].p = calloc(1, sizeof(PAGEPTR))) == NULL) ERR;            
        }
      }
    }
  }
}

/*****************************************************************************************
 *
 * Public function
 *
 *****************************************************************************************/
extern void
chkpnt(char *memP)
{
  LOG_RECORD *lrP;
  MCTL *mctlP = (MCTL *)memP;
  unsigned long orgadr, diff;

  if (mctlP->begin == 0) {
    /* The data buffer is NOT modified although it is written onto disk */
    return;
  }

  orgadr = mctlP->begin - sizeof(MCTL);
  diff = (unsigned long)memP - orgadr;

  for (mctlP = (MCTL *)memP; 
       mctlP != (MCTL *)diff;
       mctlP = (MCTL *)((unsigned long)(mctlP->next) + diff)) {
    lrP = (LOG_RECORD *)((unsigned long)mctlP + (unsigned long)sizeof(MCTL));     
    redo(lrP);
  }
}

extern void
recovery(void)
{
  int fd;
  char path[BUFFSIZE];
  char buff[REMOTE_MEMORY_SIZE];
  DIR *dirP;
  struct dirent *direntP;

  /* Initializing Directory */
  if ((dirP = opendir(CHKPTRLOGDIR)) == NULL) ERR;
  
  /* Recovery Process */
  while (1) {
    if ((direntP = readdir(dirP)) == NULL) break;
    else if ((strcmp(direntP->d_name, ".") != 0) && (strcmp(direntP->d_name, "..") != 0)) {
      /* Get data from file */
      bzero(path, BUFFSIZE);
      sprintf(path, "%s/%s/%s", getenv("HOME"), CHKPTRLOGDIR, direntP->d_name);
      S(path);
      if ((fd = open(path, O_RDONLY|O_SHLOCK)) == -1) ERR;
      if (read(fd, buff, REMOTE_MEMORY_SIZE) == -1) ERR;
      if (close(fd) == -1) ERR;

      /* Execute Checkpointing */
      chkpnt(buff);      

      /* Erasing the file */
      if (unlink(path) == -1) {
        S(path);
        ERR;
      }
    }
  }

  /* Closing Directory */
  if (closedir(dirP) == -1) ERR;
}

extern void
invokeRecovery(void)
{
  SCHEMA *schemaP;

  /* 
   * This is very important point, assuming UPS 
   */
  recovery();

  /*
   * Page init
   */
  for (schemaP = HeadSchema.next; schemaP != NULL; schemaP = schemaP->next) 
    setPagePtr(schemaP);
}
